<?
/************************************************************************/
/* FlatNuke - Flat Text Based Content Management System                 */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2003-2006 by Simone Vellei                             */
/* http://www.flatnuke.org                                              */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// include le librerie di Flatnuke necessarie
include ("config.php");
include ("functions.php");
include ("header.php");
include_once ("themes/$theme/theme.php");

// opzioni di sicurezza!
$myforum=getparam("myforum", PAR_COOKIE, SAN_FLAT);
$req=getparam("REQUEST_URI", PAR_SERVER, SAN_FLAT);
if(strstr($req,"myforum=")) {
	?><script language="javascript">window.location='index.php';</script><?
}

/*
 * Visualizza l'anteprima di una news proposta da un utente
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $news Nome assoluto del file della news da elaborare
 */
function read_signews($news) {
	$news=getparam($news,PAR_NULL,SAN_FLAT);
	global $theme;

	$string=get_file("misc/$news");
	$title=get_xml_element("fn:title",$string);
	$avatar=get_xml_element("fn:avatar",$string);
	$header=get_xml_element("fn:header",$string);
	$body=get_xml_element("fn:body",$string);
	echo "<div align=\"center\"><table width=\"500\"><tr><td>";
	OpenTableTitle("<img src=\"themes/$theme/images/read.png\" alt=\"Read\" />&nbsp;".$title);
	echo "<a href=\"index.php?mod=none_Search&amp;find=$avatar\"><img src=\"images/news/$avatar\" align=\"right\" border=\"0\" alt=\"$avatar\" /></a>";

	print stripslashes($header)."<br /><br />".stripslashes($body);

	CloseTableTitle();
	echo "</td></tr></table></div>";
}


/*
 * CASO 1: parametro $mod da GET
 */
$mod=getparam("mod", PAR_GET, SAN_FLAT);

switch($mod){

// Eliminazione di una notizia
case "delnews":
	$addr=getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);
	$file=getparam("file", PAR_GET, SAN_FLAT);
	$myfile=stripslashes(htmlspecialchars($file));
	if(is_admin()){
		$from=getparam("HTTP_REFERER", PAR_SERVER, SAN_FLAT);
		unlink($myfile);
		fnlog("News", $addr."||".$myforum."||Deleted news $myfile.");
		generate_RSS();
	}
	?><script language="javascript">window.location='<?=$from?>';</script><?
break;

// Eliminazione di una notizia proposta prima della pubblicazione
case "delpubnews":
	$addr=getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);
	$file=getparam("file", PAR_GET, SAN_FLAT);
	$myfile=stripslashes(htmlspecialchars($file));
	if(is_admin()){
		if(file_exists('misc/'.$myfile)){
			unlink('misc/'.$myfile);
		fnlog("News", $addr."||".$myforum."||Deleted news $myfile submitted by users.");
		}
	}
	?><script language="javascript">window.location='verify.php?mod=readsignews';</script><?
break;

// Pubblicazione di una notizia proposta
case "pubnews":
	$addr=getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);
	$file=getparam("file", PAR_GET, SAN_FLAT);
	$myfile=stripslashes(htmlspecialchars($file));
	if(is_admin()){
		if(file_exists('misc/'.$myfile)){
			copy('misc/'.$myfile,'news/'.time().".xml");
			unlink('misc/'.$myfile);
			fnlog("News", $addr."||".$myforum."||Published news $myfile submitted by users.");
			generate_RSS();
		}
	}
	?><script language="javascript">window.location='verify.php?mod=readsignews';</script><?
break;

// Anteprima di una notizia proposta da un utente
case "readsignews":
	if(is_admin()){
		$fpubcount=0;
		$handle = opendir('misc/');
		while ($file = readdir($handle)) {
			if (stristr($file, "news_"))
				$fpubcount++;
		}
		closedir($handle);
		if($fpubcount==0)
			print("<b>"._NOPUBNEWS."</b><br /><br />");
		$handle = opendir('misc/');
		while ($file = readdir($handle)) {
			if (stristr($file, "news_")) {
				read_signews($file);
				echo "<div align='center'>
				<form action='verify.php' method='get'>
				<input type='hidden' name='mod' value='pubnews' />
				<input type='hidden' name='file' value='$file' />
				<input type='submit' value='"._PUBNEWS."' />
				</form>
				<form action='verify.php' method='get'>
				<input type='hidden' name='mod' value='delpubnews' />
				<input type='hidden' name='file' value='$file' />
				<input type='submit' value='"._DELNEWS."' />
				</form>
				</div>";
				print "<br /><br />";
			}
		}
		closedir($handle);
		print "<a href='index.php'>"._FINDH."</a>";
	} else print "<script language='javascript'>window.location='index.php';</script>";
break;

}

/*
 * CASO 2: parametro $mod da POST
 */
$mod=getparam("mod",PAR_POST,SAN_FLAT);

switch($mod){

// Inserimento di una nuova news
case "news":
	$addr=getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);
	$file=getparam("file", PAR_GET, SAN_FLAT);
	$myfile=stripslashes(htmlspecialchars($file));

	if(isset($_POST['head']))
		$head=$_POST['head'];
	else
		$head="";
	if(isset($_POST['body']))
		$body=$_POST['body'];
	else
		$body="";

	if(isset($_POST['title']))
		$title=$_POST['title'];
	else
		$title="";

	if(isset($_POST['icon']))
		$icon=$_POST['icon'];
	else
		$icon="";

	//$myhead=stripslashes($head);
	//$mybody=stripslashes($body);
	$mybody=tag2html($body, "home");
	$myhead=tag2html($head, "home");
	$mytitle=stripslashes(htmlspecialchars($title));
	$myicon=stripslashes(htmlspecialchars($icon));

	$myhead=str_replace("\r","",$myhead);
	$myhead=str_replace("\n","<br />",$myhead);
	$mybody=str_replace("\r","",$mybody);
	$mybody=str_replace("\n","<br />",$mybody);

	if(is_admin()){
		$string  = "<?xml version='1.0'?>\n";
		$string .= "<!DOCTYPE fn:news SYSTEM \"http://flatnuke.sourceforge.net/dtd/news.dtd\">\n";
		$string .= "<fn:news xmlns:fn=\"http://flatnuke.sourceforge.net/news\">\n";
		$string .= "\t<fn:title>$mytitle</fn:title>\n";
		$string .= "\t<fn:avatar>$myicon</fn:avatar>\n";
		$string .= "\t<fn:reads>0</fn:reads>\n";
		$string .= "\t<fn:header>$myhead</fn:header>\n";
		$string .= "\t<fn:body>$mybody</fn:body>\n";
		$string .= "</fn:news>";
		fnwrite("news/".time().".xml", $string, "w", array("nonull"));
		fnlog("News", $addr."||".$myforum."||News $myfile published.");
		generate_RSS();
	}
	?><script language="javascript">window.location='index.php';</script><?
break;

// Modifica del messaggio di benvenuto
case "motd":
	$addr=getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);

	if(isset($_POST['body']))
		$body=$_POST['body'];
	else
		$body="";

	$mybody=stripslashes($body);
	if(is_admin()){
		fnwrite("misc/motd.php", $mybody, "w", array("nonull"));
		fnlog("Site maintenance", $addr."||".$myforum."||MOTD modified.");
	}
	?><script language="javascript">window.location='index.php';</script><?
break;

// Modifica del livello di una sezione
case "modlevel":
	$section=getparam("section", PAR_POST, SAN_FLAT);
	$level=getparam("level", PAR_POST, SAN_FLAT);
	$addr=getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);

	if(is_admin() and is_writeable("sections/$section")) {
		if($level!=-1) {
			fnwrite("sections/$section/level.php", $level, "w", array("nonull"));
			fnlog("Site maintenance", $addr."||".$myforum."||Level of the section $section modified to $level.");
		} else {
			unlink("sections/$section/level.php");
			fnlog("Site maintenance", $addr."||".$myforum."||Section $section with no more level restrictions.");
		}
	}
	?><script language="javascript">window.location='index.php?mod=<?=$section?>';</script><?
break;

// Elimina una sezione
case "delsection":
	$section = getparam("section", PAR_POST, SAN_FLAT);
	$addr = getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);
	if(is_admin() and is_writeable($section)) {
		if(rmdirr($section)) {
			fnlog("Site maintenance", $addr."||".$myforum."||Section $section deleted.");
		}
	}
	?><script language="javascript">window.location='index.php';</script><?
break;

// Modifica di un file
case "modcont":
	$from=getparam("from", PAR_POST, SAN_FLAT);
	$file=stripslashes(getparam("file", PAR_POST, SAN_FLAT));
	$addr=getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);

	if(isset($_POST['body']))
		$body=$_POST['body'];
	else
		$body="";

	//gestisco l'attivazione di magic quotes
	if (get_magic_quotes_gpc()){
		$mybody=stripslashes($body);
	}
	else {
		$mybody= $body;
	}

	if(is_admin() and file_exists($file)) {
		if(stristr($file,"..")) {
			//die(_NONPUOI);
			?><script language="javascript">window.location='index.php';</script><?
		}
		fnwrite($file, $mybody, "w", array());
		fnlog("Site maintenance", $addr."||".$myforum."||File ".$file." modified.");
		generate_RSS();
	}
	?><script language="javascript">window.location='<?=$from?>';</script><?
break;

// Inserimento di un commento ad una news
case "comment":
	global $guestcomment;
	$id=getparam("id", PAR_POST, SAN_FLAT);
	$addr=getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);
	if(($guestcomment == 0) && ($myforum==""))
		return;
	if($myforum=="")
		$name=_SCON;
	else $name = $myforum;

	if(isset($_POST['body']))
		$body=$_POST['body'];
	else
		$body="";

	$myname=stripslashes(htmlspecialchars($name));
	//$mybody=stripslashes(htmlspecialchars($body));
	$mybody=tag2html($body, "home");
	//$mybody=str_replace("\r","",$mybody);
	//$mybody=str_replace("\n","<br />",$mybody);
	// controllo sull'accesso concorrente
	$lockfile="news/".$id.".xml";
	if(!file_exists($lockfile)) {
		header("Location: index.php");
		return;
	}
	// accesso esclusivo alla risorsa
	$sem=lock($lockfile);
	$string=get_file($lockfile);

	// primo commento
	if(!stristr($string,"<fn:comments>")){
		$string=str_replace("</fn:news>","\t<fn:comments>\n\t\t<fn:comment>\n\t\t\t<fn:by>$myname</fn:by>\n\t\t\t<fn:date>".time()."</fn:date>\n\t\t\t<fn:post>".$mybody."</fn:post>\n\t\t</fn:comment>\n\t</fn:comments>\n</fn:news>",$string);
	}
	// c' almeno un commento
	else {
		$string=str_replace("</fn:comments>","\t<fn:comment>\n\t\t\t<fn:by>$myname</fn:by>\n\t\t\t<fn:date>".time()."</fn:date>\n\t\t\t<fn:post>".$mybody."</fn:post>\n\t\t</fn:comment>\n\t</fn:comments>",$string);
	}

	fnwrite($lockfile, $string, "w", array("nonull"));
	fnlog("News", $addr."||".$myforum."||Comment added to the news ".$id.".");
	unlock($sem);
	?><script language="javascript">window.location='index.php';</script><?
break;

// Visualizzazione dell'anteprima di una news in composizione
case "prev":
	$addr=getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);

	if(isset($_POST['head']))
		$head=$_POST['head'];
	else
		$head="";
	if(isset($_POST['body']))
		$body=$_POST['body'];
	else
		$body="";

	if(isset($_POST['title']))
		$title=$_POST['title'];
	else
		$title="";

	if(isset($_POST['icon']))
		$icon=$_POST['icon'];
	else
		$icon="";

	//$myhead=stripslashes(htmlspecialchars($head));
	//$mybody=stripslashes(htmlspecialchars($body));
	$mytitle=stripslashes(htmlspecialchars($title));
	$myicon=stripslashes(htmlspecialchars($icon));

	//if(getlevel($myforum,"home")!=10) {
		$mybody=tag2html($body, "home");
		$myhead=tag2html($head, "home");
	//	}
	//$myhead=str_replace("\n","<br />",$myhead);
	//$mybody=str_replace("\n","<br />",$mybody);

	echo "<div align=\"center\"><table width=\"500\"><tr><td>";
	OpenTableTitle("<img src=\"themes/$theme/images/news.png\" alt=\"News\" />&nbsp;".$mytitle);
	echo "<table width=\"100%\"><tr><td valign=\"top\" width=\"100%\">\n<font class=\"content\">";
	echo $myhead;
	echo "</font></td><td valign=\"top\"><a href=\"index.php?mod=none_Search&amp;find=".$myicon."\"><img border=\"0\" alt=\"".$myicon."\" src=\"images/news/".$myicon."\" /></a></td></tr></table>";
	CloseTableTitle();
	echo "<br /><br /><br /></div>";

	echo "<div align=\"center\"><table width=\"500\"><tr><td>";
	OpenTableTitle("<img src=\"themes/$theme/images/news.png\" alt=\"News\" />&nbsp;".$mytitle);
	echo "<table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font class=\"content\">";
	echo $myhead;
	echo "<br /><br />";
	echo $mybody;
	echo "</font></td><td valign=\"top\"><a href=\"index.php?mod=none_Search&amp;find=".$myicon."\"><img border=\"0\" alt=\"".$myicon."\" src=\"images/news/".$myicon."\" /></a></td></tr></table>";
	CloseTableTitle();
	echo "<br /><br /><br /></div>";

	echo "<div align=\"center\"><b><a href=\"javascript:history.back();\" >&lt;&lt;"._INDIETRO."</a></div>";
break;

// Proposta di una news da parte di un utente
case "signews":
	global $guestnews;
	$addr=getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);

	$title = getparam("title", PAR_POST, SAN_FLAT);
	$icon = getparam("icon", PAR_POST, SAN_HTML);
	$head = getparam("head", PAR_POST, SAN_HTML);
	$body = getparam("body", PAR_POST, SAN_HTML);
	$mionome = getparam("mionome", PAR_POST, SAN_HTML);
	$myname=stripslashes(htmlspecialchars($mionome));

	if(isset($_GET['guestnews'])) {
		//die(_NONPUOI);
		?><script language="javascript">window.location='index.php';</script><?
	}
	if(isset($_POST['guestnews'])) {
		//die(_NONPUOI);
		?><script language="javascript">window.location='index.php';</script><?
	}

	//controllo che sia un utente vero
	if($guestnews == 1){
		// ok
	}
	else {
		if($myforum!=$myname) {
			//break;
			?><script language="javascript">window.location='index.php';</script><?
		}
	}

	//$mybody=stripslashes(htmlspecialchars($body));
	$mytitle=stripslashes(htmlspecialchars($title));
	$myicon=stripslashes(htmlspecialchars($icon));

	$mybody=tag2html($body, "home");
	$myhead=tag2html($head, "home");
	/*
	$myhead=str_replace("<script","",$myhead);
	$myhead=str_replace("</script","",$myhead);
	$myhead=str_replace("<?","",$myhead);
	$myhead=str_replace("?>","",$myhead);
	$myhead=str_replace("\r","",$myhead);
	$myhead=str_replace("\n","<br />",$myhead);
	$mybody=str_replace("\r","",$mybody);
	$mybody=str_replace("\n","<br />",$mybody);
	$mybody=str_replace("<script","",$mybody);
	$mybody=str_replace("</script","",$mybody);
	$mybody=str_replace("<?","",$mybody);
	$mybody=str_replace("?>","",$mybody);
	*/

	$myhead="<b>$myname</b> "._HASCRITTO.":<br /><br />$myhead";
	$string  = "<?xml version='1.0'?>\n";
	$string  .= "<!DOCTYPE fn:news SYSTEM \"http://flatnuke.sourceforge.net/dtd/news.dtd\">\n";
	$string  .= "<fn:news xmlns:fn=\"http://flatnuke.sourceforge.net/news\">\n";
	$string  .= "\t<fn:title>$mytitle</fn:title>\n";
	$string  .= "\t<fn:avatar>$myicon</fn:avatar>\n";
	$string  .= "\t<fn:reads>0</fn:reads>\n";
	$string  .= "\t<fn:header>$myhead</fn:header>\n";
	$string  .= "\t<fn:body>$mybody</fn:body>\n";
	$string  .= "</fn:news>";
	fnwrite("misc/news_".time().".xml", $string, "w", array("nonull"));
	fnlog("News", $addr."||".$myforum."||New news proposed.");
	?><script language="javascript">alert("<? echo _ALERTSIG ?>");window.location='index.php';</script><?
break;

}

?></body>
</html>
