<?php

/*
--------------------------------------------------------------------
FLATCALENDAR - Calendar block for FlatNuke (http://www.flatnuke.org)
--------------------------------------------------------------------

Author:		Marco Segato
Website:	http://marcosegato.altervista.org/
email:		segatom (at) users.sourceforge.net

Author:		Giovanni Piller Cottrer
Website:	http://gigasoft.altervista.org
email:		giovanni.piller (at) gmail.com

Version:	0.9.1 - 20060809

License:	GNU General Public License 2

*/

/* ============== START SCRIPT CONFIGURATION ============== */
	$basesez = "none_Calendar";
	$baseurl = "sections/$basesez/block_calendar.php";
/* =============== END SCRIPT CONFIGURATION =============== */

if (eregi("calendar",$_SERVER['PHP_SELF'])) {
	chdir("../../");
	include_once("functions.php");
	include_once("config.php");
	include_once("languages/$lang.php");
}

// arrays from Flatnuke containing months and week days
global $mesi, $giorni;
// server time-shift taken from Flatnuke settings
global $fuso_orario;

// security conversions; if no date is given, it takes current time as default
$from = getparam("HTTP_REFERER", PAR_SERVER, SAN_NULL);
$aa   = getparam("aa", PAR_GET, SAN_FLAT);
$mm   = getparam("mm", PAR_GET, SAN_FLAT);
if ($aa=="") {
	$aa = date("Y");
}
if ($mm=="") {
	$mm = date("n");
}

// array containing all the news of the month
$arraynews = array();
$dirnews   = opendir('news');
while ($file = readdir($dirnews)) {
	$annonews = date("Y", str_replace(".xml","",$file));
	$mesenews = date("n", str_replace(".xml","",$file));
	if (!( $file=="." OR $file==".." )) {
		if ($annonews==$aa AND $mesenews==$mm) {
			array_push($arraynews, $file);
		}
	}
}
closedir($dirnews);
if(count($arraynews>0))
	rsort($arraynews);
#print_r($arraynews); //-> TEST

//---> START BUILDING CALENDAR
echo "\n<div id='calendar' class='calendar'>\n";

// print current date and time
echo "\n<div style='padding-bottom:0.5em;' align='left'>\n";
echo "<b>"._DATA.":</b> ".date("d/m/Y",time()+(3600*$fuso_orario))."<br />";
echo "<b>"._ORA.":</b> ".date("H:i",time()+(3600*$fuso_orario));
echo "\n</div>";

// print header navigation; something like:  Month Year 
$anno = $aa;
$mese = $mm;
if ($mese==1) { // first month of the year
	$back = "aa=".($anno-1)."&amp;mm=12";
	$backtitle = $mesi[11]." ".($aa-1);
} else {
	$back = "aa=".$anno."&amp;mm=".($mese-1);
	$backtitle = $mesi[$mm-2]." ".$aa;
}
if ($mese==12) { // last month of the year
	$next = "aa=".($anno+1)."&amp;mm=1";
	$nexttitle = $mesi[0]." ".($aa+1);
} else {
	$next = "aa=".$anno."&amp;mm=".($mese+1);
	$nexttitle = $mesi[$mm]." ".($aa);
}
echo "\n<div align='center'>\n";
if(check_ahah()) {
	echo "<a href=\"javascript:ahah('$baseurl?$back','calendar');\" title=\"$backtitle\">&laquo;</a>&nbsp;";
} else echo "<a href='index.php?$back' title='$backtitle'>&laquo;</a>&nbsp;";
echo "<b>".$mesi[$mm-1]."&nbsp;$aa</b>&nbsp;";
if(check_ahah()) {
	echo "<a href=\"javascript:ahah('$baseurl?$next','calendar');\" title=\"$nexttitle\">&raquo;</a>";
} else echo "<a href='index.php?$next' title='$nexttitle'>&raquo;</a>";

echo "\n</div>";

// print list of days-of-week's names
echo "\n<div class='row'>";
for ($i=1; $i<7; $i++) {
   echo "\n\t<span class='heading'>".substr($giorni[$i],0,2)."</span>";	// from monday to saturday
}
echo "\n\t<span class='heading'>".substr($giorni[0],0,2)."</span>";		// sunday
echo "\n</div>";

// print empty days
$primo = mktime(0,0,0,$mm,1,$aa); // first day of the month
$delta = date("w",$primo)-1;
#echo $delta; //-> TEST
if($delta == -1) {	// sunday as first day of the month
	$delta = 6;
}
if($delta!=0) {		// start a new week
	echo "\n<div class='row'>";
}
for ($i=0;$i<$delta;$i++) {
	echo "\n\t<span class='blankDay'>&nbsp;</span>";
}

// print all valid days
for ($i=1;$i<=date("t",$primo);$i++) {
	if (($i+$delta)%7==1) {		// first day of the week
		echo "<div class='row'>";
	}
	$thereisanews = is_there_a_news($i, $mm, $aa, $arraynews);	// check if there's a news in this day
    if (($i==date("d"))&&($mm==date("n"))&&($aa==date("Y"))) {
		if ($thereisanews!="") {
			echo "\n\t<a href=\"index.php?mod=$basesez".$thereisanews."</a>";
		} else echo "\n\t<span class='currDay' title='today'>$i</span>";	// today
    } else {
		if ($thereisanews!="") {
			echo "\n\t<a href=\"index.php?mod=$basesez".$thereisanews."</a>";
		} else echo "\n\t<span class='day'>$i</span>";
	}
	// particular cases: 1 is first day of week OR 28/29/30/31 is the last day of week
	if (($i+$delta)%7==0 OR $i==date("t",$primo)) {
		echo "\n</div>\n";
	}
}

// print options boxes to change month/year
echo "\n<div align='center'>";
echo "\n<form method='get' action='".str_replace("&","&amp;",$from)."' name='calendar_module'>";
if(check_ahah()) {
	echo "\n<select name='mm' onchange=\"javascript:ahah('$baseurl?aa='+aa.options[aa.selectedIndex].value+'&amp;mm='+this.options[this.selectedIndex].value,'calendar');\">";
} else echo "\n<select name='mm' onchange='document.calendar_module.submit()'>";

for ($i=1; $i<=12; $i++) {
    if ($i==$mm) {
		echo "\n\t<option value='$i' selected='selected'>".$mesi[$i-1]."</option>";
	} else echo "\n\t<option value='$i'>".$mesi[$i-1]."</option>";
}
echo "\n</select>";
if(check_ahah()) {
	echo "\n<select name='aa' onchange=\"javascript:ahah('$baseurl?aa='+this.options[this.selectedIndex].value+'&amp;mm='+mm.options[mm.selectedIndex].value,'calendar');\">";
} else echo "\n<select name='aa' onchange='document.calendar_module.submit()'>";
for ($i=date("Y")-10; $i<=date("Y")+5; $i++) {
	if ($i==$aa) {
		echo "\n\t<option value='$i' selected='selected'>".$i."</option>";
	} else echo "\n\t<option value='$i'>".$i."</option>";
}
echo "\n</select>";
echo "\n<noscript><br /><br /><input type='submit' value='Ok' /></noscript>";
echo "\n</form>";
echo "\n</div>\n";

// END BUILDING CALENDAR <----
echo "\n</div>\n";


/*
 * Check if there's a news in a particular day
 *
 * The function verifies if it can find a news from the
 * array $arraynews that is dated $dd/$mm/$yy.
 *
 * @param int $dd Day to check
 * @param int $mm Month to check
 * @param int $yy Year to check
 * @param array $arraynews Contains the list of news for a particular month
 *
 * @return string The string that will be printed (empty or the argument of the link)
 */
function is_there_a_news($dd, $mm, $yy, $arraynews=array()) {
	$dd = getparam($dd,PAR_NULL,SAN_FLAT);
	$mm = getparam($mm,PAR_NULL,SAN_FLAT);
	$yy = getparam($yy,PAR_NULL,SAN_FLAT);
	global $basesez;
	global $fuso_orario;

	for ($i=0; $i<count($arraynews); $i++){
		$tmp    = str_replace(".xml","",$arraynews[$i]);
		$giorno = date("j", $tmp+(3600*$fuso_orario));
		$mese   = date("n", $tmp+(3600*$fuso_orario));
		$anno   = date("Y", $tmp+(3600*$fuso_orario));
		#echo "$dd-$mm-$yy|$giorno/$mese/$anno<br />";	//-> TEST
		if($mese==$mm AND $anno==$yy AND $giorno==$dd) {
			$string = get_file('news/'.$arraynews[$i]);
			$title  = get_xml_element("fn:title",$string);
			return "&amp;aa=$anno&amp;mm=$mese&amp;dd=$giorno\" class=\"day\" title=\"News ".$giorno."/".$mese."/".$anno."\"><b>".$dd."</b>";
		}
	}
}

/*
 * Verifies if the AHAH library exists.
 *
 * @return boolean TRUE or FALSE
 */
function check_ahah() {
	if(file_exists("include/javascripts/ahah.js")) {
		return TRUE;
	} else return FALSE;
}

?>