<?php
/************************************************************************/
/* FlatNuke - Flat Text Based Content Management System                 */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2003-2004 by Simone Vellei                             */
/* http://flatnuke.sourceforge.net                                      */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/


include "header.php";
include_once "functions.php";

// automatically load PHP code in files contained in include/phpfunctions
load_php_code("include/phpfunctions");

// security option
$req=getparam("REQUEST_URI", PAR_SERVER, SAN_FLAT);
if(strstr($req,"myforum="))
	die(_NONPUOI);

// first microtime to calculate time generation page
$time1 = get_microtime();

//AUTOBUILD -->
//will be part of the installer...
if(!file_exists("misc/motd.php")){
	$fp=fopen("misc/motd.php","w");
	if(!$fp) {
		echo "<h3>Check write permission!</h3>";
		die();
	}
	fwrite($fp,_MOTDMESS);
	fclose($fp);
}
//<-- AUTOBUID

// STATISTICS -->
$from = getparam("HTTP_REFERER", PAR_SERVER, SAN_FLAT);
$host = getparam("HTTP_HOST", PAR_SERVER, SAN_FLAT);
$self = getparam("PHP_SELF", PAR_SERVER, SAN_FLAT);
$where= "http://".$host.$self;
$where = str_replace(basename($where),"",$where);
$url=str_replace("http://","",$where);
$url=str_replace("www.","",$url);
$from=str_replace("http://","",$from);
$from=str_replace("www.","",$from);
if (file_exists("sections/none_Statistiche/stat.php") AND !stristr($from,$url)) {
	include "sections/none_Statistiche/stat.php";
	stats();
}
// <-- STATISTICS

// MAINTENANCE --> _MAINT  _MAINT_MSG
if ($maintenance == "1") {
	if(!is_admin()) {
		?><div align="center" style="padding:2em;">
			<div style="background-color:#F0F0F0;max-width:250px;padding:10px;border:1px solid #999999;">
			<img alt="Flatnuke CMS login" src="images/maintenance.png" /><br />
			<br />
			<span style="color:#CC0000;">
				<b><?= _MAINT ?></b><br />
				<?= _MAINT_MSG ?>
			</span><br /><br />
			<form action="forum/index.php" method="post">
			<input type="hidden" name="op" value="login" />
			<input type="hidden" name="from" value="home" />
			<label for="username" style="font-size:20px;"><?= _NOMEUTENTE ?>:</label><br />
			<input alt="username" name="nome" size="15" id="username" style="border:0.5px solid #333333;font-size:20px;" /><br />
			<label for="password" style="font-size:20px;"><?= _PASSWORD ?></label>:<br />
			<input alt="password" name="logpassword" type="password" size="15" id="password"style="border:0.5px solid #333333;font-size:20px;" /><br />
			<br />
			<input type="submit" value="<?= _LOGIN ?>" style="border:0.5px solid #333333;font-size:16px;font-weight:bold;" />
			</form>
			</div>
		</div><?
		include_once "footer.php";
		exit();
	} else {
		echo "<div style='padding:1em;color:red;background-color:yellow;border:3px solid red;text-align:center;font-weight:bold;font-size:larger;'>"._MAINT."</div>";
	}
}
// <-- MAINTENANCE

function getflopt(){
	global $home_section, $theme;
	$req = getparam("REQUEST_URI", PAR_SERVER, SAN_FLAT);
	if(strstr($req,"myforum="))
		die(_NONPUOI);

	$op   = getparam("mod",PAR_GET,SAN_FLAT);
	$file = getparam("file",PAR_GET,SAN_FLAT);
	$file = stripslashes($file);
	$id   = getparam("id",PAR_GET,SAN_FLAT);
	$myforum = getparam("myforum",PAR_COOKIE,SAN_FLAT);

	// check option to execute
	switch($op){
		// no option given: homepage
		case "":
			// print motd content if exists
			if(file_exists("misc/motd.php") AND trim(get_file("misc/motd.php"))!="") {
				OpenTable();
				// print motd image if exists
				if(file_exists("themes/$theme/images/motd.png")) {
					echo "<img src='themes/$theme/images/motd.png' align='left' hspace='10' vspace='10' alt='Motd' />";
				} else echo "<!-- MOTD image \"themes/$theme/images/motd.png\" not found -->";
				include ("misc/motd.php");
				CloseTable();
			}
			if(($home_section == "") or !isset($home_section))
				create_news();		// display news as default
			else
				view_section($home_section);	// display section in homepage
		break;
		// read details of a news
		case "read":
			read_news($id);
		break;
		// publish a news
		case "news":
			$req=getparam("REQUEST_URI",PAR_SERVER,SAN_FLAT);
			if(strstr($req,"myforum="))
				die(_NONPUOI);
			if(is_admin())
				insert_news();
			else {
				OpenTable();
				print("<div align='center'><b>"._NOLEVELSECT."</b></div>");
				CloseTable();
				return;
			}
		break;
		// modify a file
		case "modcont":
			$req = getparam("REQUEST_URI",PAR_SERVER,SAN_FLAT);
			if(strstr($req,"myforum="))
				die(_NONPUOI);
			if(is_admin())
				edit_content($file);
			else {
				OpenTable();
				print("<div align='center'><b>"._NOLEVELSECT."</b></div>");
				CloseTable();
				return;
			}
		break;
		// insert a comment to a news
		case "comment":
			insert_comment($id);
		break;
		// view a section
		default:
			view_section($op);
		break;
	}
}

include_once "themes/$theme/theme.php";
include "themes/$theme/structure.php";
include "footer.php";

?>
