<?

/**
 * File delle funzioni di sistema
 *
 * Questo file contiene le procedure di sistema necessarie al funzionamento di FlatNuke.
 *
 * @package Funzioni_di_sistema
 * Prova {@tutorial Funzioni_di_sistema/docapi.pkg}
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @version 2.5.8
 * @copyright Copyright (c) 2003-2006
 * @license http://opensource.org/licenses/gpl-license.php GNU General Public License
 */


/**
 * Contiene funzioni condivise tra il forum e il core di FlatNuke
 */
include_once("shared.php");


/**
 * Incrementa il contatore delle visite di una news
 *
 * Incrementa di una unita' il contatore delle visite di una news.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $news Nome assoluto del file della news da elaborare
 */
function add_read($news){

	//se sono amministratore non incremento
	if (is_admin()) return;

	$news = getparam($news,PAR_NULL,SAN_FLAT);
	$lockfile = "news/$news.xml";
	// check file existance
	if(!file_exists($lockfile)) {
		OpenTable();
		print("<div align='center'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
	}
	$sem = lock($lockfile);
	$string = get_file($lockfile);
	$reads = get_xml_element("fn:reads",$string);
	//solo se non sono amministratore
	$reads += 1;
	$string = ereg_replace("<fn:reads>.*</fn:reads>","<fn:reads>$reads</fn:reads>",$string);
	fnwrite($lockfile, $string, "w", array("nonull"));
	unlock($sem);
}


/**
 * Visualizza il dettaglio di una news
 *
 * Stampa a video il dettaglio di una news compreso di titolo, intestazione,
 * corpo e commenti.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $news Nome assoluto del file della news da visualizzare
 */
function read_news($news){
	global $theme, $mesi, $giorni, $fuso_orario, $newspp;

	$news    = getparam($news,     PAR_NULL,   SAN_FLAT);
	$myforum = getparam("myforum", PAR_COOKIE, SAN_FLAT);

	// check if the news really exists
	if(!file_exists("news/$news.xml")) {
		OpenTable();
		print("<div align='center'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
	}

	add_read($news);

	$fd=get_file("news/$news.xml");
	$title=get_xml_element("fn:title",$fd);
	$avatar=get_xml_element("fn:avatar",$fd);
	$header=get_xml_element("fn:header",$fd);
	$body=get_xml_element("fn:body",$fd);
	$comments=get_xml_element("fn:comments",$fd);
	$comment=get_xml_array("fn:comment",$comments);

	OpenTableTitle("<img src='themes/$theme/images/read.png' alt='Read' />&nbsp;".$title);

	$w3c_title = _ARGOMENTO.": ".eregi_replace("\.png$|\.gif$|\.jpeg$|\.jpg$","",$avatar);
	echo "<a href='index.php?mod=none_Search&amp;where=news&amp;find=$avatar'>";
	echo "<img src='images/news/$avatar' align='right' border='0' alt='$avatar' title='$w3c_title' /></a>";
	print stripslashes($header)."<br /><br />".stripslashes($body);

	print "<br /><div align='center'><hr size='1' />";
	// Creation date
	echo _POSTATO.$giorni[date("w",$news+(3600*$fuso_orario))].date(" d ",$news+(3600*$fuso_orario));
	// Times read
	$tmp = date("m", $news+(3600*$fuso_orario));
	if($tmp<10)
		$tmp = str_replace("0","",$tmp);
	print $mesi[$tmp-1];
	echo date(" Y - ",$news+(3600*$fuso_orario)).date("H:",$news+(3600*$fuso_orario)).date("i",$news+(3600*$fuso_orario))." ("._LETTO;
	$tmp = ereg_replace(".*<fn:reads>","",$fd);
	$tmp = ereg_replace("</fn:reads>.*","",$tmp);
	echo " $tmp "._VOLTE.")</div><br />";

	OpenTable();
	echo "<b>"._COMMENTI."</b>";
	echo " | <a href='index.php?mod=comment&amp;id=$news' title='"._ADDCOMM." news: $title'>"._ADDCOMM."</a>";
	echo " | <a href='print.php?news=$news' target='new' title='"._STAMPA." news: $title'>"._STAMPA."</a>";
	if(is_admin()) {
		echo  " | <a href='index.php?mod=modcont&amp;file=news/$news.xml&amp;from=index.php' title='"._MODIFICA." news: $title'>"._MODIFICA."</a>";
		echo " | <a href='#' onclick=\"check('verify.php?mod=delnews&amp;file=news/$news.xml')\" title='"._ELIMINA." news: $title'>"._ELIMINA."</a>";
	}
	CloseTable();

	for($j=0;$j<count($comment);$j++){
		print "<br />";
		$user=get_xml_element("fn:by",$comment[$j]);
		print "<div class='comment' style='min-height:105px;'>";
		// inserisco l'avatar nei commenti
		if(file_exists("forum/users/$user.php")){
			$fd=file("forum/users/$user.php");
			$img=str_replace("\n","",str_replace("#","",$fd[7]));
			if($img!=""){
				if(!stristr($img,"http://"))
					echo "<img src='forum/".$img."' alt='avatar' border='0' align='left' hspace='10' vspace='5' style='max-width:100px' />";
				else
					echo "<img src='".$img."' alt='avatar' border='0' align='left' hspace='10' vspace='5' style='max-width:100px' />";
			} else echo "<img src='forum/images/blank.png' alt='avatar' border='0' align='left' hspace='10' vspace='5' style='max-width:100px' />";
		} else echo "<img src='forum/images/blank.png' alt='avatar' border='0' align='left' hspace='10' vspace='5' style='max-width:100px' />";
		// autore del commento
		print "<b>"._DA."</b> $user  ";
		// data di inserzione del commento
		$date_comment = get_xml_element("fn:date",$comment[$j]);
		if(is_numeric($date_comment)){
			print "<b>"._DATA.":</b> ";
			echo $giorni[date("w",$date_comment+(3600*$fuso_orario))].date(" d ",$date_comment+(3600*$fuso_orario));
			$tmp_c = date("m",$date_comment+(3600*$fuso_orario));
			if ($tmp_c<10)
				$tmp_c = str_replace("0","",$tmp_c);
			print $mesi[$tmp_c-1];
			$date_comment = date(" Y - ",$date_comment+(3600*$fuso_orario)).date("H:",$date_comment+(3600*$fuso_orario)).date("i",$date_comment+(3600*$fuso_orario));
		}
		else $date_comment = "/";
		print "$date_comment<br /><br />";
		// contenuto del commento
		print stripslashes(get_xml_element("fn:post",$comment[$j]));
		print "</div>";
	}
	echo "<br /><hr noshade='noshade' size='1' />";

	// ricerca della notizia precedente e di quella successiva
	$array_news = array();
	$handle = opendir("news");
	while ($file = readdir($handle)) {
		if (!( $file=="." OR $file==".." )) {
			array_push($array_news, $file);
		}
	}
	closedir($handle);
	if(count($array_news)>0)
		sort($array_news);
	while ($cur_news = current($array_news)) {
		if ($cur_news == "$news.xml") {
			$current = current($array_news);
			$key = key($array_news);
			if($key-1 < 0)
				$prev = _NOPREVNEWS;
			else $prev = "<a href='index.php?mod=read&amp;id=".str_replace(".xml","",$array_news[$key-1])."'>&#171; "._PREVNEWS."</a>";
			if($key+1 > count($array_news)-1)
				$next = _NONEXTNEWS;
			else $next = "<a href='index.php?mod=read&amp;id=".str_replace(".xml","",$array_news[$key+1])."'>"._NEXTNEWS." &#187;</a>";
			echo "<div align='center'>$prev | $next</div>";
		}
		next($array_news);
	}

	// elenco delle ULTIME notizie con stesso argomento di quella visualizzata
	echo "<hr noshade='noshade' size='1' /><p align='center'><b>"._RELATEDNEWSLAST."</b></p>";
	argument_search("news", $avatar, $newspp);
	// link per leggere elenco di TUTTE le notizie con stesso argomento di quella visualizzata
	echo "<hr noshade='noshade' size='1' /><p align='center'><b>"._RELATEDNEWSALL."</b></p><p align='center'>";
	echo "<a href='index.php?mod=none_Search&amp;where=news&amp;find=$avatar'>";
	echo "<img src='images/news/$avatar' border='0' alt='$avatar' title='$w3c_title' /></a></p>";

	CloseTableTitle();
}


/**
 * Ricerca una determinata stringa all'interno delle news o dei topics del forum
 *
 * Esegue una ricerca di una stringa all'interno dei files presenti nella directory
 * delle news o dei topics del forum, stampandone un elenco
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @since 2.5.7
 *
 * @param string $where Sezione di ricerca, 'news' oppure 'forum/topics'
 * @param string $find Stringa da ricercare
 * @param number $max_news Indica il numero massimo di news da stampare; se 0 le stampa tutte
 */
function argument_search($where, $find, $max_news=0) {
	global $theme;

	$where=getparam($where,PAR_NULL, SAN_FLAT);
	$find=getparam($find,PAR_NULL, SAN_FLAT);

	if($where=="")
		$find="";
	$haveresult = 0;
	$num_news = 0;
	if((trim($find)!="") and file_exists($where)) {
		$addr=getparam("REMOTE_ADDR",PAR_SERVER,SAN_FLAT);
		$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
		//fnlog("Search", $addr."||".$myforum."||Search done in $where about \"$find\"."); // too verbose, produces too big logs
		$modlist = array();
		$handle = opendir($where);
		while ($file = readdir($handle)) {
			if (!( $file=="." OR $file==".." )) {
				array_push($modlist, $file);
			}
		}
		closedir($handle);
		if(count($modlist)>0)
			rsort($modlist);
		// se num. massimo di news da stampare ($max_news)  0, le stampo tutte
		if($max_news==0)
			$max_news = count($modlist);
		// stampa la lista delle ultime news con stesso argomento
		for ($i=0; $i<count($modlist) AND $num_news<$max_news; $i++) {
			$string = get_file($where.'/'.$modlist[$i]);
			$found = 0;
			if(stristr($string, $find)) {
				$found = 1;
				$haveresult = 1;
				$num_news++;
			}
			if($found==1) {
				if($where=="news") {
					$title = get_xml_element("fn:title", $string);
					if($title=="")
						$title = _LEGGITUTTO;
					$reads = get_xml_element("fn:reads", $string);
					$id = str_replace(".xml", "", $modlist[$i]);
					echo "<img src='themes/$theme/images/read.png' alt='Read'>&nbsp;<a href='index.php?mod=read&amp;id=$id' />$title</a> ";
					echo "(".date("d/m/Y - H:i", $id).") "._LETTO."$reads "._VOLTE."<br />";
				}
				if($where=="forum/topics") {
					$title = get_xml_element("ff:topic", $string);
					if($title=="")
						$title = _LEGGITUTTO;
					$id = str_replace(".xml", "", $modlist[$i]);
					echo "<img src='themes/$theme/images/read.png' alt='Read'>&nbsp;<a href='forum/index.php?op=topic&quale=$id' />$title</a> ";
					echo "(".date("d/m/Y - H:i", $id).")<br />";
				}
			}
		}
		if($haveresult==0) {
			echo _NORESULT."<br /><a href=\"javascript:history.back();\">&lt;&lt; "._INDIETRO."</a>";
		}
	}
	else {
		?><div align="center">
		<form action="index.php" method="get">
		<input type="hidden" name="mod" value="none_Search" />
		<?=_CERCASTR?><br /><br />
		<input type="radio" name="where" value="news" />News
		<input type="radio" name="where" value="forum/topics" />Forum<br />
		<input type="text" name="find" size="14" /><br /><br />
		<input type="submit" value="<?=_CERCA?>" />
		</form>
		</div><?
	}
}


/**
 * Conta i commenti associati ad una news
 *
 * Calcola il numero di commenti inseriti per una news e lo restituisce.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $news Nome assoluto del file della news da elaborare
 * @return number Numero dei commenti
 */
function count_comment($news){

	$news=getparam($news,PAR_NULL,SAN_FLAT);
	$com=0;
	$fd=file("news/$news.xml");
	for($j=1; $j<count($fd);$j++){
		if(stristr($fd[$j],"<fn:comment>"))
			$com+=1;
	}
	return $com;
}


/**
 * Permette di scaricare un file dalla sezione "Download"
 *
 * Permette di scaricare un file dalle sezione "Download" gestendone
 * il conteggio dei downloads.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $file Nome assoluto del file da scaricare
 */
function go_download($mysect, $file){
	//-> DEPRECATED!
}


/**
 * Visualizza tutte le classi di download
 *
 * Visualizza tutte le classi di download filtrate secondo il parametro $filter
 * presenti nella directory <i>/sections/Download/</i>, stampandone l'eventuale
 * descrizione.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $filter Filtro per le classi di download
 */
function view_download($mysect, $filter){
	//-> DEPRECATED!
}


/**
 * Visualizza una sezione
 *
 * Visualizza il contenuto della sezione passata come parametro.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $section Nome assoluto della sezione da visualizzare
 */
function view_section($section){

	if (file_exists("include/redefine/view_section.php")){
		include("include/redefine/view_section.php");
		return;
	}

	global $theme;

	// security checks
	$section = getparam($section,PAR_NULL,SAN_FLAT);
	$file = getparam("file", PAR_GET, SAN_FLAT);
	$mode = getparam("mode", PAR_GET, SAN_FLAT);
	$myforum = getparam("myforum",PAR_COOKIE, SAN_FLAT);

	// prevents to go up/down to other directories
	if(stristr($section,"..")) die(_NONPUOI);
	if(stristr($file,"..")) die(_NONPUOI);

	// delete null byte, it could disclose subdirectories
	$section = str_replace(chr(00),"",$section);

	// check if section really exists
	if(!file_exists("sections/$section")) {
		OpenTable();
		print("<div align='center'><b>"._SECTNOTEXIST."</b></div>");
		CloseTable();
		return;
	}

	// CHECKING SECTION PERMISSIONS -->
	// if I have set a level, I check it
	$sectlevel = getsectlevel($section);
	if($sectlevel!=-1){
		if($myforum){
			if(getlevel($myforum,"home") < $sectlevel){
				OpenTable();
				print("<div align='center'><b>"._NOLEVELSECT."</b></div>");
				CloseTable();
				return;
			}
		} else {
			OpenTable();
			print("<div align='center'><b>"._NOLEVELSECT."</b></div>");
			CloseTable();
			return;
		}
	}
	// <-- END CHECKING SECTION PERMISSIONS

	if($file!="")
		$sect = $section."/$file";
	else
		$sect = $section;

	// Build navigation bar of the section
	$tit = "";
	$albero = explode("/",$sect);
	for($i=0;$i<sizeof($albero);$i++){
		$mypath = "";
		for($j=0;$j<=$i;$j++){
			if($i>0 and ($j!=$i)){
				$mypath .= $albero[$j]."/";
			} else {
				$mypath .= $albero[$j];
			}
		}
		$tmp = str_replace("none_","",$albero[$i]);
		$tmp = eregi_replace("^[0-9][0-9]_","",$tmp);
		if($i!=(sizeof($albero)-1)){
			$accesskey="";
			if (get_access_key($mypath)!=""){
				$accesskey = "accesskey=\"".get_access_key($mypath)."\"";
			}
			$tit .= "<a href='index.php?mod=".rawurlencodepath($mypath)."' title=\""._GOTOSECTION.": ".str_replace("_"," ",$tmp)."\" $accesskey>".str_replace("_"," ",$tmp)."</a>/";
		} else {
			$tit .= str_replace("_"," ",$tmp);
			$tit = ereg_replace("\.[a-z0-9]{1,4}$","",$tit); // delete file extension
		}
	}

	// Find the image that identifies the current section; if not find, it takes the default one by the theme
	if(file_exists("sections/$section/section.png")) {
		$section_image = "sections/$section/section.png";
	} else $section_image = "themes/$theme/images/section.png";

	// Start printing section
	OpenTableTitle("<a title=\"\" accesskey=\"0\"><img src='$section_image' alt='Section' /></a>&nbsp;".stripslashes($tit));

	// Include code for section's header
	load_php_code("include/section/header");

	if($file==""){
		if(file_exists("sections/$section/section.php")){
			include("sections/$section/section.php");
			echo "<br />";
		}
		/* Download section with Fdplus */
		if(file_exists("sections/$section/download")) {
			echo "<br />";
			include_once("download/fd+.php");
			fd_overview();
		}
		/* Gallery section */
		if(file_exists("sections/$section/gallery")) {
			echo "<br />";
			include("gallery/gallery.php");
			$pag = getparam("pag",PAR_GET,SAN_FLAT);
			if($pag != "") {
				$galleryparms = "&amp;pag=".$pag;
			} else {
				$galleryparms = "";
			}
		} else $galleryparms = "";
		// Link to print this section
		echo "<div align='right'><a href='print.php?mod=".rawurlencodepath($section)."$galleryparms' target='new' title=\""._STAMPA."\"><img src='themes/$theme/images/print.png' border='0' alt='print' /></a></div>";
	}
	else{
		include(stripslashes('sections/'.$section.'/'.$file));
		echo "<div align='right'><a href='print.php?mod=".rawurlencodepath($section)."&amp;file=".rawurlencodepath($file)."' title=\""._STAMPA."\"><img src='themes/$theme/images/print.png' border='0' alt='print' /></a></div>";
	}

	// Include code for section's footer
	load_php_code("include/section/footer");

	// Print the list of sub-sections
	$modlist = array();
	$handle = opendir('sections/'.$section);
	while ($file = readdir($handle)) {
		if(!stristr($file,"none_")){
			if ( (!ereg("[.]",$file)) and is_dir("sections/".$section."/".$file)) {
				if (!user_can_view_section("$section/$file")) continue;
				array_push($modlist, $file);
			}
		}
	}
	closedir($handle);
	if(count($modlist)>0) {
		sort($modlist);
		echo "<br /><br />";
		OpenTable();
		for ($i=0; $i < sizeof($modlist); $i++) {
			if(stristr($modlist[$i],"_")){
				$tmp = eregi_replace("^[0-9][0-9]_","",$modlist[$i]);
				$tmp = str_replace("_"," ",$tmp);
			}
			// compatibility with old Flatnuke versions...
			else $tmp = $modlist[$i];

			// Find the image that identifies the current subsection; if not find, it takes the default one by the theme
			if(file_exists("sections/$section/$modlist[$i]/section.png")) {
				$subsection_image = "sections/$section/$modlist[$i]/section.png";
			} else $subsection_image = "themes/$theme/images/subsection.png";

			echo "<img src='$subsection_image' alt='Subsection' />&nbsp;<a href='index.php?mod=".rawurlencodepath($section."/".$modlist[$i])."' title=\""._GOTOSECTION.": $tmp\"";

			if (get_access_key($section."/".$modlist[$i])!=""){
				echo " accesskey=\"".get_access_key($section."/".$modlist[$i])."\"";
			}

			echo ">$tmp</a><br />";
		}
		CloseTable();
	}

	// Administration of the section (visible only to administrtaors)
	$file = stripslashes($file);
	echo "<hr size='1' />";
	if(is_admin()) {
		echo "<div>";
		// modify section or section's file
		if($file=="") {
			if(is_writable("sections/".$section."/section.php"))
				print "<div style='float:left;padding:2px;'><form action='index.php' method='get'>
			<input type='hidden' name='mod' value='modcont' />
			<input type='hidden' name='from' value='".str_replace("&","&amp;",getparam("REQUEST_URI", PAR_SERVER, SAN_FLAT))."' />
			<input type='hidden' name='file' value='sections/".$section."/section.php' />
			<input type='submit' value='"._MODIFICA."' />
			</form></div>";
		}
		else {
			if(is_writable("sections/".$section."/".$file))
				print "<div style='float:left;padding:2px;'><form action='index.php' method='get'>
			<input type='hidden' name='mod' value='modcont' />
			<input type='hidden' name='from' value='".str_replace("&","&amp;",getparam("REQUEST_URI",PAR_SERVER,SAN_FLAT))."' />
			<input type='hidden' name='file' value='sections/$section/".$file."' />
			<input type='submit' value='"._MODIFICA."' />
			</form></div>";
		}
		// delete section --> TO TEST BETTER
		/*if(is_writeable("sections/$section")) {
			print "<div style='float:left;padding:2px;'>
		<form action='verify.php' method='post'>
		<input type='hidden' name='mod' value='delsection' />
		<input type='hidden' name='section' value='sections/$section' />
		<input type='submit' value='"._ELIMINA."' />
		</form></div>";
		}*/
		// manage section's level
		$level = getsectlevel($section);
		print "<div style='float:right;'><form action='verify.php' method='post'>";
		print "<input type='hidden' name='mod' value='modlevel' />";
		print "<input type='hidden' name='section' value='".$section."' />";
		print "<b>"._LEVEL."</b>: ";
		if(!is_writeable("sections/$section")) {
			print "<select name='level' disabled></select> "._FIG_ALERTNOTWR;
			print "</form></div>";
		} else {
			print "<select name='level'>";
			print "<option value='-1'>---</option>";
			for($i=0;$i<11;$i++){
				if($level==$i)
					print "<option value='$i' selected='selected'>$i</option>";
				else
					print "<option value='$i' >$i</option>";
			}
			print "</select>";
			print "&nbsp;<input type='submit' value='OK' />";
			print "</form></div>";
		}
	echo "</div>";
	}
	CloseTableTitle();
}

/**
 * Elenca le sezioni ed i link ad esse associati
 *
 * Restituisce un array contenente le sezioni ed un secondo
 * array contenente i link preformattati alle sezioni stesse.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @since 2.5.8
 *
 * @param string $path Directory delle sezioni da scorrere
 * @param string $result Specifica se restituire i nomi delle sezioni ('names') oppure i loro link ('links')
 * @return array Lista dei nomi o lista dei link delle sezioni trovate
 */
function list_sections($path, $result){
	$path   = getparam($path,   PAR_NULL, SAN_FLAT);
	$result = getparam($result, PAR_NULL, SAN_FLAT);
	$modlist   = array();
	$link_list = array();

	$handle = opendir($path);
	while ($file = readdir($handle)) {
		if (!( $file=="." or $file==".." ) and (!ereg("^\.",$file) and ($file!="CVS") and !stristr($file,"none_") )) {
			if (!user_can_view_section($file)) continue;
			array_push($modlist, $file);
		}
	}
	closedir($handle);

	if(count($modlist)<=0){
		return(null);
	}

	sort($modlist);

	$j=0;
	for ($item_num=0; $item_num < count($modlist); $item_num++) {
		if(!stristr($modlist[$item_num],"none_")){
			if(stristr($modlist[$item_num],"_")){
				$tmp=eregi_replace("^[0-9][0-9]_","",$modlist[$item_num]);
				$tmp=str_replace("_"," ",$tmp);
			}
			else
				$tmp=$modlist[$item_num];
		$link_list[$j] = "<a href=\"index.php?mod=".rawurlencodepath($modlist[$item_num])."\" title=\" "._GOTOSECTION.": $tmp\"";
		if (get_access_key($modlist[$item_num])!=""){
			$link_list[$j] = $link_list[$j]." accesskey=\"".get_access_key($modlist[$item_num])."\"";
		}
		$link_list[$j] = $link_list[$j].">$tmp</a>";
		$j++;
		}
	}

	switch($result) {
		case "names":
			return($modlist);
		break;
		case "links":
			return($link_list);
		break;
	}
}

/**
 * Crea il menu principale
 *
 * Crea un blocco contenente il menu principale elencando tutte le directories
 * che in <i>/sections/</i> non iniziano con "none_":
 *  - prima vengono, in ordine alfabetico, le directories che iniziano
 *    con un carattere (es: Prova);
 *  - di seguito, in ordine crescente, quelle che iniziano con una coppia
 *    di numeri (es: 03_Prova).
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * //-> DEPRECATED! USE list_sections() AND BUILD THE MENU FROM THE THEME
 */
function create_menu(){
	global $theme;

	if (file_exists("include/redefine/create_menu.php")){
		include("include/redefine/create_menu.php");
		return;
	}

	$modlist = list_sections("sections","links");

	if($modlist == null)
		return;

	// backward theme compatibility
	if(function_exists("OpenBlock")){
		OpenBlock("themes/$theme/images/menu.png",_MAINMENUTITLE);
	}
	else {
		OpenTableTitle("<img src=\"themes/$theme/images/menu.png\" alt=\"Menu\" />&nbsp;"._MAINMENUTITLE);
	}

	echo "&#187;&nbsp;<a href=\"index.php\" title=\""._HOMEMENUTITLE."\" accesskey=\"h\">"._HOMEMENUTITLE."</a><br />";

	for ($item_num=0; $item_num < count($modlist); $item_num++) {
		echo "&#187;&nbsp;".$modlist[$item_num]."<br />";
	}

	// backward theme compatibility
	if(function_exists("CloseBlock"))
		CloseBlock();
	else
		CloseTableTitle();
	echo "<br />";
}


/**
 * Visualizza i blocchi laterali
 *
 * Visualizza il contenuto dei blocchi laterali presenti nelle directories
 * <i>/blocks/dx/</i> oppure <i>/blocks/sx/</i> a seconda del parametro passato;
 * non vengono stampati i blocchi che iniziano per "none_".
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $edge Lato dei blocchi da stampare
 */
function create_blocks($edge){
	global $theme;

	if (file_exists("include/redefine/create_blocks.php")){
		include("include/redefine/create_blocks.php");
		return;
	}

	$edge=getparam($edge,PAR_NULL,SAN_FLAT);
	$modlist = array();

	$handle=opendir('blocks/'.$edge);
	while ($file = readdir($handle)) {
		if (!is_dir("blocks/$edge/$file") and (!ereg("^\.",$file)) and !stristr($file,"none_")) {
			array_push($modlist, $file);
		}
	}
	closedir($handle);

	if(count($modlist)>0)
		sort($modlist);
	for ($item_num=0; $item_num < count($modlist); $item_num++) {
		$tmp=eregi_replace("^[0-9][0-9]_","",$modlist[$item_num]);
		$title=str_replace("_"," ",str_replace(".php","",$tmp));
		// backward theme compatibility
		if(function_exists("OpenBlock")){
			OpenBlock("themes/$theme/images/block.png",$title);
		}
		else {
			OpenTableTitle("<img src=\"themes/$theme/images/menu.png\" alt=\"$title\" />&nbsp;$title");
		}
		include ("blocks/$edge/$modlist[$item_num]");
		if(function_exists("CloseBlock"))
			CloseBlock();
		else
			CloseTableTitle();
		echo "<br />";
	}
}


/**
 * Visualizza in homepage il motd e le news
 *
 * Visualizza in homepage un numero di news (a partire dalla piu' recente)
 * secondo quanto indicato in fase di configurazione.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 */
function create_news(){
	global $newspp, $theme;

	if (file_exists("include/redefine/create_news.php")){
		include("include/redefine/create_news.php");
		return;
	}

	$modlist = array();

	$handle = opendir('news');
	while ($file = readdir($handle)) {
		if (!( $file=="." or $file==".." ) and (!ereg("^\.",$file)and ($file!="CVS"))) {
			array_push($modlist, $file);
		}
	}
	closedir($handle);
	if(count($modlist)>0)
		rsort($modlist);

	for ($i=0; $i < count($modlist); $i++) {
		if ($i>=$newspp)
			break;
		$string = get_file("news/$modlist[$i]");
		print "<br />";
		$title  = ereg_replace(".*<fn:title>","",$string);
		$title  = ereg_replace("</fn:title>.*","",$title);
		$header = ereg_replace(".*<fn:header>","",$string);
		$header = ereg_replace("</fn:header>.*","",$header);
		$avatar = ereg_replace(".*<fn:avatar>","",$string);
		$avatar	= ereg_replace("</fn:avatar>.*","",$avatar);
		$ntitle = "<img src=\"themes/$theme/images/news.png\" alt=\"News\" />&nbsp;$title";
		//grendizer: prima l'avatar, poi l'header
		OpenTableTitle($ntitle);
		$w3c_title = _ARGOMENTO.": ".eregi_replace("\.png$|\.gif$|\.jpeg$|\.jpg$","",$avatar);
		echo "<a href=\"index.php?mod=none_Search&amp;where=news&amp;find=$avatar\"><img src=\"images/news/$avatar\" border=\"0\" alt=\"$w3c_title\" title=\"$w3c_title\" align=\"right\" /></a><br />";
		echo stripslashes($header);
		CloseTableTitle2(str_replace(".xml","",$modlist[$i]));
	}
}


/**
 * Visualizza una textarea per inserire una news
 *
 * Permette di inserire direttamente online una nuova notizia,
 * tramite una comoda textarea.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 */
function insert_news(){

	global $sitename;

	$refbody = getparam("refbody", PAR_GET, SAN_FLAT);
	$refurl = getparam("refurl", PAR_GET, SAN_FLAT);
	$reftitle = getparam("reftitle", PAR_GET, SAN_FLAT);
	
	OpenTableTitle(_ADDNEWS);
	echo "<form action=\"verify.php\" method=\"post\" name=\"insnews\">
	<input type=\"hidden\" name=\"mod\" value=\"news\" />
	<b>"._TITNOTIZIA."</b><br />
	<input type=\"text\" name=\"title\" style=\"width: 95%\" value=\"".$reftitle."\"><br><br>
	<b>"._ARGOMENTO."</b><br />
	<img name=\"avatar\" src=\"images/nonews.png\" border=\"0\" alt=\"Argomento\" />
	<br />
	<select name=\"icon\" onChange='document.insnews.avatar.src=\"images/news/\"+this.options[this.selectedIndex].value'>";

	$modlist = array();
	$handle=opendir('images/news');
	while ($file = readdir($handle)) {
		if (!( $file=="." or $file==".." ) and (!ereg("^\.",$file)and ($file!="CVS")) ) {
			array_push($modlist, $file);
		}
	}
	closedir($handle);
	if(count($modlist)>0)
		sort($modlist);
	for ($i=0; $i < count($modlist); $i++) {
		echo "<option value=\"$modlist[$i]\">".	str_replace("_"," ", ereg_replace("\..*","",$modlist[$i]))."</option>\n";
	}

	echo "</select><br /><br />";
	// bbcodes panel
	bbcodes_js();
	bbcodes_panel("head", "home", "formatting"); echo "<br />";
	bbcodes_panel("head", "home", "emoticons"); echo "<br />";
	echo "<b>"._INTMESSAGGIO."</b><br />";
	if($refbody != "")
		echo "<textarea cols=\"50\" rows=\"20\" name=\"head\" style=\"width: 95%\">$refbody\n\nLink: <a href=\"$refurl\">$refurl</a></textarea><br><br>";
	else
		echo "<textarea cols=\"50\" rows=\"20\" name=\"head\" style=\"width: 95%\"></textarea><br><br>";

	// bbcodes panel
	bbcodes_panel("body", "home", "formatting"); echo "<br />";
	bbcodes_panel("body", "home", "emoticons"); echo "<br />";
	echo "<b>"._CORPOMESSAGGIO."</b><br />";
	echo "<textarea cols=\"50\" rows=\"20\" name=\"body\"  style=\"width: 95%\"></textarea><br /><br />
	<input type=\"submit\" value=\""._INSNOTIZIA."\" />
	</form>";
	echo "
	<script type=\"text/javascript\">
		function preview(){
			document.prev.title.value=document.insnews.title.value;
			document.prev.icon.value=document.insnews.icon.value;
			document.prev.head.value=document.insnews.head.value;
			document.prev.body.value=document.insnews.body.value;
		}
	</script>";
	echo "<form name=\"prev\" action=\"verify.php\"  method=\"post\">
	<input type=\"hidden\" name=\"mod\" value=\"prev\" />
	<input type=\"hidden\" name=\"title\" />
	<input type=\"hidden\" name=\"icon\" />
	<input type=\"hidden\" name=\"head\" />
	<input type=\"hidden\" name=\"body\" />
	<input type=\"submit\" value=\""._ANTEPRIMA."\" onMouseOver='preview();' />
	</form>";
	echo "<br>"._FASTNEWSSTR."<br><a href=\"javascript:if(navigator.userAgent.indexOf('Safari') >= 0){Q=getSelection();}else{Q=document.selection?document.selection.createRange().text:document.getSelection();}location.href='http://".$_SERVER["HTTP_HOST"].$_SERVER["PHP_SELF"]."?mod=news&refbody='+encodeURIComponent(Q)+'&refurl='+encodeURIComponent(location.href)+'&reftitle='+encodeURIComponent(document.title);\">$sitename &raquo; FlatNuke Fast News</a>";
	CloseTableTitle();
}


/**
 * Visualizza una textarea per commentare una news
 *
 * Permette di inserire un commento alla notizia passata come parametro,
 * tramite una comoda textarea.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $news Nome assoluto del file della news da modificare
 */
function insert_comment($news){
	global $sitename,$guestcomment;

	$news=getparam($news,PAR_NULL,SAN_FLAT);
	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

	$modlist = array();
	// cerca se la news passata esiste veramente
	$handle = opendir('news');
	while ($file = readdir($handle)) {
		if (!($file == "." or $file == "..")) {
			array_push($modlist, $file);
		}
	}
	closedir($handle);
	// se non c' muore con dolore!
	if(!in_array($news.".xml", $modlist)) {
		OpenTable();
		print("<div align='center'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
	}

	//  se si tenta di fare il furbo passando come
	// argomento guestcomment=1 non lo permette!
	$req=getparam("REQUEST_URI", PAR_SERVER, SAN_FLAT);
	if(strstr($req,"guestcomment="))
		$guestcomment=0;

	OpenTableTitle(_ADDCOMM);

	if(($myforum!="") or ($guestcomment==1)){
		echo "<form action=\"verify.php\" method=\"post\">
		<input type=\"hidden\" name=\"mod\" value=\"comment\" />
		<input type=\"hidden\" name=\"id\" value=\"$news\" />";
		// bbcodes panel
		bbcodes_js();
		bbcodes_panel("body", "home", "formatting"); echo "<br />";
		bbcodes_panel("body", "home", "emoticons"); echo "<br />";
		echo "<textarea cols=\"50\" rows=\"20\" name=\"body\" style=\"width: 95%\" ></textarea><br /><br />
		<input type=\"submit\" value=\""._FINVIA."\" />
		</form><br />";
		read_news($news);
	}
	else{
		print _DEVIREG." <b>".$sitename."</b> "._DEVIREG2;
	}
	CloseTableTitle();
}


/**
 * Visualizza una textarea per la modifica di un file
 *
 * Permette di modificare direttamente online il file passato come parametro,
 * tramite una comoda textarea che ne visualizza il contenuto.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $filename Nome del file da modificare
 */
function edit_content($filename){
	if (file_exists("include/redefine/edit_content.php")){
		include("include/redefine/edit_content.php");
		return;
	}

	$filename=getparam($filename,PAR_NULL,SAN_FLAT);
	$from=getparam("from",PAR_GET,SAN_FLAT);
	$from=stripslashes($from);

	if(stristr($filename,"..") or !file_exists($filename)) {
		OpenTable();
		print("<div align='center'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
	}

	OpenTableTitle(_MODIFICA." ".$filename);
	echo "<form action=\"verify.php\" method=\"post\">
	<input type=\"hidden\" name=\"mod\" value=\"modcont\" />
	<input type=\"hidden\" name=\"from\" value=\"".$from."\" />
	<textarea cols=\"80\" rows=\"30\" name=\"body\" style=\"width: 95%\">";
	echo htmlspecialchars(file_get_contents($filename));
	echo "</textarea><br /><br />
	<input type=\"hidden\" name=\"file\" value=\"".$filename."\" />
	<input type=\"submit\" value=\""._MODIFICA."\" />
	</form>";
	CloseTableTitle();
}


/**
 * Effettua il parsing di un feed RSS esterno
 *
 * Legge il file di un feed RSS esterno al sito e ne genera una stampa
 * leggibile e ordinata con le notizie segnalate, completa di link
 * per raggiungerle sul sito di origine.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $url Indirizzo del feed RSS
 * @return null|string Nulla se non trova il file, oppure il contenuto del feed RSS
 */
function parse_RSS($url){

	$url=getparam($url,PAR_NULL,SAN_FLAT);

	if ($url != "") {
		if (!ereg("http://",$url)) {
			$url = "http://$url";
		}
		$rdf = parse_url($url);
		$fp = fsockopen($rdf['host'], 80, $errno, $errstr, 15);
		if (!$fp) {
			print(_NORSS);
			return;
		}
		if ($fp) {
			@fputs($fp, "GET " . $rdf['path'] . "?" . $rdf['query'] . " HTTP/1.0\r\n");
			@fputs($fp, "HOST: " . $rdf['host'] . "\r\n\r\n");
			$string = "";
			while(!feof($fp)) {
				$pagetext = fgets($fp,228);
				$string .= chop($pagetext);
			}
			fputs($fp,"Connection: close\r\n\r\n");
			fclose($fp);
			$items = explode("</item>",$string);

			$content = "";
			$cont = 0;
			for ($i=0;$i<sizeof($items)-1;$i++) {
				$link = ereg_replace(".*<link>","",$items[$i]);
				$link = ereg_replace("</link>.*","",$link);
				$title2 = ereg_replace(".*<title>","",$items[$i]);
				$title2 = ereg_replace("</title>.*","",$title2);
				// some feeds are exposed with CDATA format
				$title2 = str_replace("<![CDATA[","",$title2);
				$title2 = str_replace("]]>","",trim($title2));
				if ($items[$i] == "" AND $cont != 1) {
					$content = "";
				} else {
					if (strcmp($link,$title2) AND $items[$i] != "") {
						$cont = 1;
						$content .= "<b><big>&middot;</big></b>&nbsp;<a href=\"$link\" target=\"new\">$title2</a><br />\n";
					}
				}
			}
		}
	}
	return $content;
}


/**
 * Genera il feed RSS
 *
 * Genera il file <i>/misc/backend.xml</i> che contiene le news presenti in
 * homepage; il file XML e' strutturato per essere letto con un normale aggregator
 * RSS, ed e' compatibile con le {@link http://feedvalidator.org/docs/rss2.html specifiche RSS 2.0}.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20050206: RSS 2.0 support
 */
function generate_RSS() {
	global $sitename, $newspp, $admin_mail;

	$url = "http://".getparam("HTTP_HOST", PAR_SERVER, SAN_FLAT).getparam("PHP_SELF", PAR_SERVER, SAN_FLAT);
	$url = str_replace(basename($url),"",$url);

	// tag apertura del feed
	$body = "<?xml version=\"1.0\" encoding=\""._CHARSET."\"?>\n<rss version=\"2.0\">\n\t<channel>\n";
	// informazioni generali sul feed
	$body .= "\t\t<title>$sitename</title>\n\t\t<link>$url</link>\n\t\t<description><![CDATA[\"$sitename\" HEADLINES]]></description>\n";
	$body .= "\t\t<managingEditor>$admin_mail</managingEditor>\n\t\t<generator>FlatNuke RSS Generator - http://www.flatnuke.org</generator>\n";
	$body .= "\t\t<lastBuildDate>".date("D, d M Y H:i:s",time())." GMT</lastBuildDate>\n";
	// carico array con le news ordinate per data
	$handle = opendir('news');
	$modlist = array();
	while ($file = readdir($handle)) {
        if (!( $file=="." or $file=="..") and (!ereg("^\.",$file) and ($file!="CVS"))) {
			array_push($modlist, $file);
		}
	}
	closedir($handle);
	if(count($modlist)>0)
		rsort($modlist);
	// creazione tag per ognuna delle news
	for ($i=0; $i < count($modlist); $i++) {
		if ($i>=$newspp)
			break;
		$string = get_file("news/$modlist[$i]");
		$mytitle = get_xml_element("fn:title",$string);
		$mydesc = str_replace("<br>","<br />",get_xml_element("fn:header",$string));
		$id = str_replace(".xml","",$modlist[$i]);
		$body .= "\t\t<item>\n";
		$body .= "\t\t\t<title>$mytitle</title>\n";
		$body .= "\t\t\t<link>$url"."index.php?mod=read&amp;id=$id</link>\n\t\t\t<description><![CDATA[$mydesc]]></description>\n";
		$body .= "\t\t\t<pubDate>".date("D, d M Y H:i:s",$id)." GMT</pubDate>\n";
		$body .= "\t\t</item>\n";
	}
	// tag chiusura del feed
	$body.="\t</channel>\n</rss>";
	// scrittura del feed
	fnwrite("misc/backend.xml", $body, "w", array("nonull"));
}


/**
 * Restituisce il livello di una sezione
 *
 * Restituisce il livello della sezione passata come parametro, leggendolo dal
 * file <i>/section/nomesezione/level.php</i>:
 *  - -1 se non esiste il file level.php, la sezione sara' visibile da tutti;
 *  - 0 per una sezione visibile solo da utenti registrati;
 *  - da 1 a 9 per una sezione visibile solo da utenti di livello intermedio;
 *  - 10 per una sezione visibile solo da utenti amministratore.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 *
 * @param string $section Nome della sezione
 * @return int -1 se la sezione non ha livello, oppure un numero di livello da 0 a 10
 */
function getsectlevel($section){
	$section=getparam($section,PAR_NULL,SAN_FLAT);
	if(!file_exists("sections/$section/level.php"))
		return(-1);
	$fp=file("sections/$section/level.php");
	return((int)str_replace("\n","",$fp[0]));
}


/**
 * Funzione alternativa a html_entity_decode()
 *
 * Rimpiazza la funzione nativa di PHP html_entity_decode() per gli utenti
 * che utilizzano una versione di PHP piu' vecchia della 4.3.0.
 *
 * @author Documentazione ufficiale PHP - {@link http://it.php.net/manual/en/function.html-entity-decode.php}
 *
 * @param string $string
 * @return string Una stringa che preserva i caratteri speciali HTML
 */
function unhtmlentities($string) {
  	/*$trans_tbl = get_html_translation_table(HTML_ENTITIES);
	$trans_tbl = array_flip($trans_tbl);
        return strtr($string, $trans_tbl);*/
}


/**
 * Genera un log di attivita'
 *
 * Aggiunge al file <i>/misc/log/log.php</i> una riga che contiene
 * la data e l'ora di produzione della segnalazione di log, la zona
 * di origine e una descrizione dell'attivita' effettuata.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @since 2.5.4
 *
 * @param string $zone Nome della sezione cui si riferisce il log
 * @param string $txt Testo del log da salvare
 */
function fnlog($zone, $txt){
	$zone=getparam($zone,PAR_NULL,SAN_FLAT);
	$txt=getparam($txt,PAR_NULL,SAN_FLAT);
	if($zone == "Forum") {
		$pref="../";
		$flog = $pref."misc/log";
	}
	else {
		$pref ="";
		$flog = "misc/log";
	}
	// prepare environment if not present
	if(!is_dir($flog))
		mkdir($flog, 0777);
	//log rotate every 1MB
	if(file_exists("$flog/log.php") AND (filesize("$flog/log.php") >= 1048576)) {
		rename("$flog/log.php",$pref."misc/log/log-".time().".php");
		$fp=fopen("$flog/log.php","a");
		fwrite($fp, "<?exit(1);?>\n");
		fclose($fp);
	}
	// check file existance and write an empty file
	if(!file_exists("$flog/log.php")) {
		$fp=fopen("$flog/log.php","a");
		fwrite($fp, "<?exit(1);?>\n");
		fclose($fp);
	}
	// write log file
	if (file_exists("$flog/log.php")){
		$fp=fopen("$flog/log.php","a");
		$string =  date ("d/m/Y H:i:s");
		$string = $string." $zone: $txt\n";
		fwrite($fp,$string);
		fclose($fp);
	}
}


/**
 * Mostra le informazioni sul copyright di un modulo
 *
 * Crea un link da cui e' possibile visualizzare una finestra popup
 * con informazioni dettagliate sul copyright del modulo corrente.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @since 2.5.4
 *
 * @param string $modulo Nome del modulo installato
 * @param string $versione Versione del modulo installato
 * @param string $autore Nome dell'autore del modulo
 * @param string $email E-mail dell'autore del modulo
 * @param string $homepage Homepage dell'autore del modulo
 * @param string $licenza Licenza di rilascio del modulo
 */
function module_copyright($modulo, $versione, $autore, $email, $homepage, $licenza) {
	$modulo   = getparam($modulo,   PAR_NULL, SAN_FLAT);
	$versione = getparam($versione, PAR_NULL, SAN_FLAT);
	$autore   = getparam($autore,   PAR_NULL, SAN_FLAT);
	$email    = getparam($email,    PAR_NULL, SAN_FLAT);
	$email    = email_mask($email);
	$homepage = getparam($homepage, PAR_NULL, SAN_FLAT);
	$licenza  = getparam($licenza,  PAR_NULL, SAN_FLAT);

	echo "<script language=\"JavaScript\" type=\"text/JavaScript\">
	var dom = (document.getElementById) ? true : false;
	var ns5 = ((navigator.userAgent.indexOf(\"Gecko\")>-1) && dom) ? true: false;
	var ie5 = ((navigator.userAgent.indexOf(\"MSIE\")>-1) && dom) ? true : false;
	var ns4 = (document.layers && !dom) ? true : false;
	var ie4 = (document.all && !dom) ? true : false;
	var nodyn = (!ns5 && !ns4 && !ie4 && !ie5) ? true : false;

	window.onload=function(){
		tooltip = (ns4)? document.fncopyright.document: (ie4)? document.all['fncopyright']: (ie5||ns5)? document.getElementById('fncopyright'): null;
		tipcss = (ns4)? document.fncopyright: tooltip.style;
		if(dom && ns5) {
			tipcss.position = 'fixed';
		}
		else {
			tipcss.position = 'absolute';
		}
	}

	function copyshow(){
		tooltip = (ns4)? document.fncopyright.document: (ie4)? document.all['fncopyright']: (ie5||ns5)? document.getElementById('fncopyright'): null;
		tipcss = (ns4)? document.fncopyright: tooltip.style;
		if(tipcss.visibility==\"visible\")
			tipcss.visibility=\"hidden\";
		else
			tipcss.visibility=\"visible\";
	}
	</script>";

	echo "<br /><div align=\"right\"><a href=\"javascript:;\" onClick=\"copyshow();\" title=\"Copyright info\">Copyright &copy; <b>$modulo</b></a></div><br />";
	echo "<div id='fncopyright' style=\"top: 15px; left: 15px; display: block; visibility: hidden; background-color: #FFFBA6; border: 1px solid; padding: 5px;\">";
	echo "<p align='center'><b>Copyright informations</b></p>Module developed for the <b><a href='http://flatnuke.sf.net'>flatnuke</a></b> CMS<br /><br />";
	echo "<b>Module name</b>: $modulo<br /><b>Version</b>: $versione<br /><b>License</b>: $licenza<br />";
	echo "<b>Author</b>: $autore<br /><b>E-mail</b>: <a href='mailto:$email'>".str_replace("%20"," ",$email)."</a><br /><b>Home page</b>: <a href='$homepage' target='_blank' title='$homepage'>$homepage</a> <br />";
	echo "<p align='center'><b><a href='javascript:;' onClick=\"copyshow();\">Close</a></b></p></div>";
}


/**
 * Gestione tag per codice html
 *
 * Rimpiazza i pseudo-tag ([b], [i], ecc) con i tag html)
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20050916: Unificato la funzione per l'uso nel sito e nel forum
 * @since 2.5.7
 *
 * @param string $string Stringa da verificare
 * @param string $where Riferimento alla root per l'esecuzione del codice: 'home' per le news, 'forum' per il forum
 * @return string Codice HTML
 */
function tag2html($string, $where) {
	// verifico provenienza della chiamata e adatto i richiami alle directories
	/*$string=getparam($string,PAR_NULL,SAN_FLAT);
	$where=getparam($where,PAR_NULL,SAN_FLAT);*/

	switch($where) {
		case "home":
			$prepath = "forum/";
		break;
		case "forum":
			$prepath = "";
		break;
	}
	// solo l'amministratore pu usare codice HTML
	$myforum=getparam("myforum", PAR_COOKIE, SAN_FLAT);
	if(getlevel($myforum,$where) < 10) {
		$string = str_replace("<", "&lt;", $string);
		$string = str_replace(">", "&gt;", $string);
	}
	$string = str_replace("|", "", $string);
	// emoticons
	$string = str_replace("[:)]", "<img src='".$prepath."emoticon/01.png' alt=':)' />", $string);
	$string = str_replace("[:(]", "<img src='".$prepath."emoticon/02.png' alt=':(' />", $string);
	$string = str_replace("[:o]", "<img src='".$prepath."emoticon/03.png' alt=':o' />", $string);
	$string = str_replace("[:p]", "<img src='".$prepath."emoticon/04.png' alt=':p' />", $string);
	$string = str_replace("[:D]", "<img src='".$prepath."emoticon/05.png' alt=':D' />", $string);
	$string = str_replace("[:!]", "<img src='".$prepath."emoticon/06.png' alt=':!' />", $string);
	$string = str_replace("[:O]", "<img src='".$prepath."emoticon/07.png' alt=':O' />", $string);
	$string = str_replace("[8)]", "<img src='".$prepath."emoticon/08.png' alt='8)' />", $string);
	$string = str_replace("[;)]", "<img src='".$prepath."emoticon/09.png' alt=';)' />", $string);
	// formattazione testo
	$string = str_replace("\n", "<br />", $string);
	$string = str_replace("\r", "", $string);
	$string = str_replace("[b]", "<b>", $string);
	$string = str_replace("[/b]", "</b>", $string);
	$string = str_replace("[i]", "<i>", $string);
	$string = str_replace("[/i]", "</i>", $string);
	$string = str_replace("[quote]", "<div style='margin-left:1.5em;'><hr noshade /><i>", $string);
	$string = str_replace("[/quote]", "</i><hr noshade /></div>", $string);
	$string = str_replace("[code]", "<div style='margin-left:1.5em;'><pre>", $string);
	$string = str_replace("[/code]", "</pre></div>", $string);
	// solo l'amministratore pu inserire immagini
	switch($where) {
		case "home":
			if(is_admin()) {
				$string = str_replace("[img]", "<br /><img src=\"", $string);
				$string = str_replace("[/img]", "\" alt=\"uploaded_image\" /><br />", $string);
			}
		break;
		case "forum":
			if((getlevel($myforum,$where)==10) AND versecid2($myforum)) {
				$string = str_replace("[img]", "<br /><img src=\"", $string);
				$string = str_replace("[/img]", "\" alt=\"uploaded_image\" /><br />", $string);
			}
		break;
	}

	// colori del testo
	$string = str_replace("[red]", "<span style=\"color : #ff0000\">", $string);
	$string = str_replace("[green]", "<span style=\"color : #00ff00\">", $string);
	$string = str_replace("[blue]", "<span style=\"color : #0000ff\">", $string);
	$string = str_replace("[pink]", "<span style=\"color : #ff00ff\">", $string);
	$string = str_replace("[yellow]", "<span style=\"color : #ffff00\">", $string);
	$string = str_replace("[cyan]", "<span style=\"color : #00ffff\">", $string);
	$string = str_replace("[/red]", "</span>", $string);
	$string = str_replace("[/blue]", "</span>", $string);
	$string = str_replace("[/green]", "</span>", $string);
	$string = str_replace("[/pink]", "</span>", $string);
	$string = str_replace("[/yellow]", "</span>", $string);
	$string = str_replace("[/cyan]", "</span>", $string);

	// WIKIPEDIA
	$items = explode("[/wp]",$string);
	for ($i = 0; $i < count($items); $i++) {
		$wp="";
		if(stristr($items[$i],"[wp")){
			$wp_lang = ereg_replace(".*\[wp lang=","",$items[$i]);
			$wp_lang = ereg_replace("\].*","",$wp_lang);
			$wp = ereg_replace(".*\[wp.*\]", "", $items[$i]);
			$wp = ereg_replace("\[/wp\].*", "", $wp);
			if ($wp != "") {
				$nuovowp="<a style=\"text-decoration: none; border-bottom: 1px dashed; color: blue;\" target=\"new\" href=\"http://$wp_lang.wikipedia.org/wiki/$wp\">$wp</a>";
			$string=str_replace("[wp lang=$wp_lang]".$wp."[/wp]", $nuovowp, $string);
			}
		}
	}

	$items = "";
	// URLs
	$items = explode("[/url]",$string);
	for ($i = 0; $i < count($items); $i++) {
		$url="";
		if(stristr($items[$i],"[url]")){
			$url = ereg_replace(".*\[url\]", "", $items[$i]);
			$url = ereg_replace("\[/url\].*", "", $url);
			if ($url != "") {
				if (stristr($url, "http://") == FALSE) {
					$nuovourl="<a target=\"new\" href=\"http://$url\">$url</a>";
				} else {
					$nuovourl="<a target=\"new\" href=\"$url\">$url</a>";
				}
			$string=str_replace("[url]".$url."[/url]", $nuovourl, $string);
			}
		}
	}

	return ($string);
}


/**
 * Dichiara una funzione JS per il pannello dei pulsanti BBCODES
 *
 * Dichiara una funzione JS che viene utilizzata dal pannello dei
 * pulsanti BBCODES per inserire il testo corretto nell'area di testo
 * indicata come terzo parametro.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20050906: added parameter 'area' in JS function
 * @author Bjrn Splinter <insites@gmail.com> | 20050912: removed additional chars inserted before and after tag1/tag2 in 'if(document.selection) {}
 * @since 2.5.7
 *
 */
function bbcodes_js() {
	echo "<script type='text/javascript'>
		function insertTags(tag1, tag2, area) {
			var txta = document.getElementsByName(area)[0];
			txta.focus();
			if (document.selection) {
				var sel  = document.selection.createRange();
				sel.text = tag2
					? tag1 + sel.text + tag2
					: tag1;
			}
			else if (txta.selectionStart != undefined) {
				var before = txta.value.substring(0, txta.selectionStart);
				var sel    = txta.value.substring(txta.selectionStart, txta.selectionEnd);
				var after  = txta.value.substring(txta.selectionEnd, txta.textLength);
				txta.value = tag2
					? before + tag1 + sel + tag2 + after
					: before + \"\" + tag1 + \"\" + after;
			}
		}
	</script>";
}


/**
 * Crea il pannello dei pulsanti BBCODES
 *
 * Crea il pannello dei pulsanti BBCODES per inserire il testo corretto
 * nell'area di testo indicata come parametro.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20050906: added parameter 'area' in JS function
 * @author Bjrn Splinter <insites@gmail.com> | 20050912: added variable 'prepath', changed some '' to "" to prevent IE script errors
 * @since 2.5.7
 *
 * @param string $area Area di testo in cui inserire i BBCODES
 * @param string $where Riferimento alla root per l'esecuzione del codice: 'home' per le news, 'forum' per il forum
 * @param string $what 'formatting' per creare il pannello con i tasti di formattazione testo, 'emoticons' per le emoticons
 */
function bbcodes_panel($area, $where, $what) {
	$area=getparam($area,PAR_NULL,SAN_FLAT);
	$where=getparam($where,PAR_NULL,SAN_FLAT);
	$what=getparam($what,PAR_NULL,SAN_FLAT);

	$myforum=getparam("myforum", PAR_COOKIE, SAN_FLAT);
	// verifico provenienza della chiamata e adatto i richiami alle directories
	switch($where) {
		case "home":
			$prepath = "forum/";
		break;
		case "forum":
			$prepath = "";
		break;
	}
	// stampo la parte di pannello selezionata
	switch($what) {
		case "formatting":
		?><img OnClick="javascript:insertTags('[b]', '[/b]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/bold.png" border="0" alt="bold" title="bold" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[i]', '[/i]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/italic.png" border="0" alt="italic" title="italic" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[quote]', '[/quote]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/quote.png" border="0" alt="quote" title="quote" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[code]', '[/code]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()"src="<?=$prepath?>emoticon/code.png" border="0" alt="code" title="code" style="cursor: pointer;"/>
		<? // solo l'amministratore pu inserire immagini
		switch($where) {
			case "home":
				if((getlevel($myforum,$where)==10) AND versecid($myforum)) {
					?><img OnClick="javascript:insertTags('[img]', '[/img]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/image.png" border="0" alt="image" title="image" style="cursor: pointer;"/><?
				}
			break;
			case "forum":
				if((getlevel($myforum,$where)==10) AND versecid2($myforum)) {
					?><img OnClick="javascript:insertTags('[img]', '[/img]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/image.png" border="0" alt="image" title="image" style="cursor: pointer;"/><?
				}
			break;
		}
		?>
		<img OnClick="javascript:insertTags('[red]', '[/red]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/red.png" border="0" alt="red" title="red" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[green]', '[/green]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/green.png" border="0" alt="green" title="green" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[blue]', '[/blue]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/blue.png" border="0" alt="blue" title="blue" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[pink]', '[/pink]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/pink.png" border="0" alt="pink" title="pink" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[yellow]', '[/yellow]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()"  src="<?=$prepath?>emoticon/yellow.png" border="0" alt="yellow" title="yellow" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[cyan]', '[/cyan]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/cyan.png" border="0" alt="cyan" title="cyan" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[url]', '[/url]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/url.png" border="0" alt="url" title="url" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[wp lang=en]', '[/wp]', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/wikipedia.png" border="0" alt="wikipedia" title="wikipedia" style="cursor: pointer;"/>
			<?
		break;
		case "emoticons":
		?><img OnClick="javascript:insertTags('[:)]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/01.png" border="0" alt="Happy" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[:(]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/02.png" border="0" alt="Triste"  style="cursor: pointer;"/>
		<img  OnClick="javascript:insertTags('[:o]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/03.png" border="0" alt="sorpresa"  style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[:p]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/04.png" border="0" alt="linguaccia"  style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[:D]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/05.png" border="0" alt="risata" style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[:!]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/06.png" border="0" alt="indifferente"  style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[:O]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/07.png" border="0" alt="sbalordito"  style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[8)]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/08.png" border="0" alt="fighetto"  style="cursor: pointer;"/>
		<img OnClick="javascript:insertTags('[;)]', '', '<?=$area?>')" onMouseOver="document.getElementsByName('<?=$area?>')[0].focus()" src="<?=$prepath?>emoticon/09.png" border="0" alt="occhiolino" style="cursor: pointer;"/>

			<?
		break;
	}
}


/**
 * Verifica se l'utente  amministratore
 *
 * Funzione che verifica se l'utente che sta visualizzando la pagina 
 * in possesso o meno delle credenziali di amministratore del sito.
 *
 * @author Aldo Boccacci <zorba_@tin.it>
 * @since 2.5.8
 *
 * @return boolean VERO o FALSO
 */
function is_admin(){
	$myforum = getparam("myforum", PAR_COOKIE, SAN_FLAT);
	if ($myforum == "") {
		return FALSE;
	}
	if ((getlevel($myforum, "home"))=="10" AND versecid($myforum)) {
		return TRUE;
	}
	else return FALSE;
}


/**
 * Restituisce TRUE se il visitatore  un utente regolarmente loggato
 *
 * Funzione che restituisce TRUE se il visitatore collegato al portale  un utente regolarmente
 * registrato. Restituisce FALSE in caso contrario
 *
 * @author Aldo Boccacci <zorba_@tin.it>
 * @since 2.5.8
 *
 * @return TRUE se l'utente collegato  un utente normale, FALSE se  un ospite o un amministratore
 */
function is_user(){
	$myforum = getparam("myforum", PAR_COOKIE, SAN_FLAT);
	if ($myforum == "") {
		return FALSE;
	}
	if (getlevel($myforum, "home")>"-1" AND getlevel($myforum, "home")<"10" AND versecid($myforum)) {
		return TRUE;
	}
	else return FALSE;
}


/**
 * Restituisce TRUE se l'utente collegato  un ospite non loggato
 *
 * Questa funzione restituisce TRUE se il visitatore collegato al sito  un semplice ospite.
 * Restituisce FALSE se si tratta di un utente o un amministratore regolarmente loggati.
 *
 * @author Aldo Boccacci <zorba_@tin.it>
 * @since 2.5.8
 *
 * @return TRUE se l'utente collegato  un ospite, FALSE se  un utente normale o un amministratore
 */
function is_guest(){
	if (is_admin() or is_user())
		return FALSE;
	else return TRUE;
}


/**
 * Restituisce lo username dell'utente collegato (se valido)
 *
 * Funzione che restituisce lo username dell'utente collegato al portale. (se valido e regolarmente loggato)
 * Se l'utente collegato  in realt un ospite o se non  regolarmente loggato restituisce
 * una stringa vuota.
 *
 * @author Aldo Boccacci <zorba_@tin.it>
 * @since 2.5.8
 *
 * @return lo username dell'utente collegato
 */
function get_username(){
	if (is_guest())
		return "";
	$myforum = getparam("myforum", PAR_COOKIE, SAN_FLAT);

	if (is_alphanumeric($myforum))
		return $myforum;
	else return "";
}


/**
 * Restistuisce TRUE se l'utente collegato pu vedere la sezione specificata da $mod
 *
 * Questa funzione restituisce TRUE se l'utente collegato al portale ha i permessi per visualizzare la sezione
 * richiesta.
 * Indicando anche il secondo parametro si possono verificare i permessi di un determinato utente.
 *
 * @author Aldo Boccacci <zorba_@tin.it>
 * @since 2.5.8
 *
 * @param string $mod  il mod della sezione di cui verificare i permessi di visione
 * @param string $user l'utente di cui verificare i permessi. Se non viene specificato questo parametro,
 *                     o se la stringa  vuota si verifica l'utente attualmente collegato al portale
 * @return TRUE se l'utente pu vedere la sezione, FALSE in caso contrario
 */
function user_can_view_section($mod,$user=""){
	$mod = getparam($mod,PAR_NULL,SAN_FLAT);
	if (!check_path($mod,"","false")) return FALSE;
	if ($user==""){
		$user = getparam("myforum", PAR_COOKIE, SAN_FLAT);
	}
	else $user = getparam($user,PAR_NULL,SAN_FLAT);

	if (!is_dir("sections/$mod")) return FALSE;

	$sectlevel="";
	$sectlevel = getsectlevel($mod);

	if ($sectlevel=="-1") return TRUE;
	else {
		if (getlevel($user,"home") < $sectlevel) return FALSE;
		else return TRUE;

	}

	return FALSE;
}


/**
 * Restistuisce TRUE se l'utente collegato pu vedere la sezione specificata da $mod
 *
 * Questa funzione verifica se l'utente collegato ha i permessi di scrittura nella sezione
 * passata come parametro.
 * Indicando anche il secondo parametro si possono verificare i permessi di un determinato utente.
 * La funzione non controlla i permessi di scrittura sui file a livello di filesystem: questi andranno
 * controllati a parte.
 *
 * @author Aldo Boccacci <zorba_@tin.it>
 * @since 2.5.8
 *
 * @param string $mod  il mod della sezione di cui verificare i permessi di scrittura
 * @param string $user l'utente di cui verificare i permessi. Se non viene specificato questo parametro,
 *                     o se la stringa  vuota si verifica l'utente attualmente collegato al portale
 * @return TRUE se l'utente pu modificare la sezione, FALSE in caso contrario
 * NOTA: attualmente restituisce TRUE soltanto se l'utente interessato  un amministratore
 */
function user_can_edit_section($mod,$user=""){
	$mod = getparam($mod,PAR_NULL,SAN_FLAT);
	if (!check_path($mod,"","false")) return FALSE;
	if ($user==""){
		$user = getparam("myforum", PAR_COOKIE, SAN_FLAT);
	}
	else $user = getparam($user,PAR_NULL,SAN_FLAT);

	if (!is_dir("sections/$mod")) return FALSE;

	if ((getlevel($user, "home"))=="10" AND versecid($user)) return TRUE;

	return FALSE;
}


/**
 * Restituisce l'accesskey della sezione specificata
 *
 * Funzione che restituisce l'accesskey della sezione specificata come parametro.
 * L'accesskey deve essere un singolo carattere alfanumerico e deve essere specificato nel file
 * accesskey.php eventualmente presente nella sezione specificata.
 *
 * @author Aldo Boccacci <zorba_@tin.it>
 * @since 2.5.8
 *
 * @param string $mod il mod della sezione di cui restituire l'accesskey
 * @return l'accesskey della sezione specificata
 */
function get_access_key($mod){
	$mod = getparam($mod,PAR_NULL,SAN_FLAT);
	if (!check_path($mod,"","false")) return "";

	if (!is_dir("sections/$mod")) return "";
	if (!file_exists("sections/$mod/accesskey.php")) return "";

	$accesskey="";
	$accesskey = trim(get_file("sections/$mod/accesskey.php"));

	if (strlen($accesskey)!=1) return "";

	if (!is_alphanumeric($accesskey)) return "";

	return $accesskey;
}

/**
 * carica il profilo dell'utente specificato
 *
 * Carica il profilo dell'utente specificato e restituisce un array con i dati.
 * La struttura dell'array restituito :
 * $data['password'] = la password codificata in md5 dell'utente
 * $data['name'] = il nome scelto dal'utente
 * $data['mail'] = l'indirizzo e-mail specificato
 * $data['homepage'] = l'home page
 * $data['work'] = il lavoro
 * $data['avatar'] = l'avatar scelto dall'utente
 * $data['sign'] = la firma che sar accodata ai messaggi
 * $data['level'] = il livello dell'utente
 *
 * @param string $user il nome dell'utente di cui caricare il profilo
 * @return un array con i dati dell'utente
 * @since 2.5.8
 * @author Aldo Boccacci <zorba_@tin.it>
 */
function load_user_profile($user){
	$user = getparam($user,PAR_NULL, SAN_FLAT);
	//per salvare il log
	$addr=getparam("REMOTE_ADDR",PAR_SERVER,SAN_FLAT);
	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

	if (!is_alphanumeric($user)){
		return NULL;
	}

	$userdata = "";
	$userprofile= array();
	if (file_exists("forum/users/$user.php")){

		$userdata = file("forum/users/$user.php");


		//la password
		if (is_alphanumeric(eregi_replace("^#","",$userdata[1]))){
			$userprofile['password'] = eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[1])));
		}
		else {
			fnlog("load_user_profile", "$addr||$myforum||md5 password not valid! (user: $user)");
// 			die("md5 password is not valid!");
		}

		//il nome
		$userprofile['name'] = eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[2])));

		//la mail
		$userprofile['mail'] = eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[3])));

		//home page
		$userprofile['homepage'] = eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[4])));

		//lavoro
		$userprofile['work'] = eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[5])));

		//provenienza
		$userprofile['from'] = eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[6])));

		//avatar
		$userprofile['avatar'] = eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[7])));

		//firma
// 		include_once("include/php_filters/kses.php");
// 		$sign_allowed = array('a' => array ('href' => array ()), 'br' => array(),
// 		'b'=>array(),'i'=>array(),'u' => array());
// 		$userprofile['sign'] = kses(stripslashes(eregi_replace("^#","",eregi_replace("\n$","",$userdata[8]))),$sign_allowed);
		$userprofile['sign'] = stripslashes(eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[8],"<br>,<br/>,<br />"))));


		//livello
		$check_level = "";
		$check_level = trim(eregi_replace("^#","",strip_tags($userdata[9])));
		if (ctype_digit($check_level) and ($check_level>=0) and ($check_level<=10)){
			$userprofile['level'] = eregi_replace("^#","",$userdata[9]);
		}
		else $userprofile['level'] = "-1";

	}
	else return NULL;

	return $userprofile;
}

?>
