<?

/************************************************************************/
/* FlatNuke - Flat Text Based Content Management System                 */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2003-2004 by Simone Vellei                             */
/* http://flatnuke.sourceforge.net                                      */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

include_once "../functions.php";
include_once "../shared.php";

// impostazione di sicurezza
$req=getparam("REQUEST_URI", PAR_SERVER, SAN_FLAT);
if(strstr($req,"myforum="))
	die();

// imposto primo microtime per il calcolo delle tempistiche di generazione pagina
$time1 = get_microtime();

$op=getparam("op",PAR_ALL,SAN_FLAT);

if($op=="logout"){
	logout();
}
elseif($op=="login"){
	login();
}
// cancella utente
elseif($op=="deluser") {

	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
	$addr=getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
	$user=getparam("user", PAR_GET, SAN_FLAT);
	$from=getparam("from", PAR_GET, SAN_FLAT);

	// io mi posso cancellare da solo
	// gli amministratori possono cancellare tutti
	if((($user==$myforum) and versecid2($user)) or ((getlevel($myforum,"forum")==10) and versecid2($myforum))){
		if($myforum==$user){
			$url=getparam("PHP_SELF",PAR_SERVER, SAN_FLAT);
			$path=pathinfo($url);
			$url=str_replace("/forum","",$path["dirname"]);
			if($url=="")
				$url="/";
			setcookie("myforum","",time()+99999999,"$url");
		}
		if(file_exists("users/".$user.".php"))
			unlink("users/".$user.".php");

		fnlog("Forum", $addr."||".$myforum."||User ".$user." deleted.");
		if ($from=="home")
			 echo "<script language=javascript>window.location='../index.php';</script>";
		else
			 echo "<script language=javascript>window.location='index.php';</script>";
	}
}

else{
	// MANUTENZIONE -->
	include_once "../config.php";
	$myforum = getparam("myforum", PAR_COOKIE, SAN_FLAT);
	if ($maintenance == "1" and !(isset($myforum) and (getlevel($myforum,"forum")==10) and versecid2($myforum))) {
		Header("Location: ../index.php");
		exit();
	}
	if ($maintenance == "1") {
		// language definition
		switch($lang) {
			case "de" OR "en" OR "es" OR "pt":
				include_once ("../languages/$lang.php");
			break;
			default:
				include_once ("../languages/it.php");
		}
		echo "<div style='padding:1em;color:red;background-color:yellow;border:3px solid red;text-align:center;font-weight:bold;font-size:larger;'>"._MAINT."</div>";
	}
	// <-- MANUTENZIONE

	include "header.php";

	// EVITA DI COSTRUIRE SCRIPT AD HOC
	// PER ALTERARE DATI IN POST
	//controlla il numero dei post
	// CANCELLATO

	switch($op){
		case "vis_reg":
			vis_reg();
		break;
		case "vis_login":
			vis_login();
		break;
		case "reg_sic":
			reg_sic();
		break;
		case "reg":
			reg();
		break;
		case "newtopic":
			newtopic();
		break;
		case "regtopic":
			regtopic();
		break;
		case "members":
			members();
		break;
		case "modprof":
			modprof();
		break;
		case "profile":
			profile();
		break;
		case "topic":
			topic();
		break;
		case "help":
			include "help.php";
		break;
		case "":
			main();
		break;
	}
}



function vis_reg(){

	//controllo se  possibile registrarsi sulo sito
	if (isset($_GET['reguser']) or isset($_POST['reguser']) or isset($_COOKIE['reguser'])) die(_NONPUOI);
	global $reguser;
	if ($reguser!="1") die(_NONPUOI);
	global $back,$border;
	?>
	<br /><br />
	<form action=index.php method=post name="registra">
	<table width='80%' border='0' cellspacing='0' cellpadding='0' bgcolor='<?=$border?>' >
	<tbody><tr>
	<td>
	<table width='100%' border='0' cellspacing='1' cellpadding='3'>
	<tbody>
	<tr>
	<td bgcolor="<?=$back?>" colspan="5">
	<center>
	<b><?=_FREG ?></b>
	<br />
	<?=_FCAMPI ?>
	</center>
	</td></tr><tr>
	<td bgcolor="<?=$back?>">

<!-- 	<form action=index.php method=post name="registra"> -->
	<input type=hidden name=op value=reg />
	<!-- TEMPORANEY USERNAME (it isn't a bug inside the system!) -->
	<?// if(isset($_GET['usr'])) echo "<input type=\"hidden\" name=\"tmp_usr\" value=\"".$_GET['usr']."\"" ?>

	<?=_NOMEUTENTE?>*: </td>
	<td bgcolor="<?=$back?>">
	<input name=nome<? //if(isset($_GET['usr'])) echo " value=\"".$_GET['usr']."\"" ?> /></td>
	</tr><tr>
	<td bgcolor="<?=$back?>">
	<?=_PASSWORD?>*: </td><td bgcolor="<?=$back?>">
	<input name="regpass" type="password" /></td>
	</tr><tr>
	<td bgcolor="<?=$back?>">
	<?=_PASSWORD?>*:<br /></td><td bgcolor="<?=$back?>">
	<input name="reregpass" type="password" /></td>
	</tr><tr>
	<td bgcolor="<?=$back?>">
	<?=_FNOME?>: </td><td bgcolor="<?=$back?>">
	<input name=anag /></td>
	</tr><tr>
	<td bgcolor="<?=$back?>">
	<?=_FEMAIL?>: </td><td bgcolor="<?=$back?>">
	<input name=email<? //if(isset($_GET['usr'])) echo " value=\"".$_GET['usr']."@(domain)\"" ?> /></td>
	</tr><tr>
	<td bgcolor="<?=$back?>">
	<?=_FHOME?>: </td><td bgcolor="<?=$back?>">
	<input name=homep value="http://" /></td>
	</tr><tr>
	<td bgcolor="<?=$back?>">
	<?=_FPROFES?>: </td><td bgcolor="<?=$back?>">
	<input name=prof /></td>
	</tr><tr>
	<td bgcolor="<?=$back?>">
	<?=_FPROV?>: </td><td bgcolor="<?=$back?>">
	<input name=prov /></td>
	</tr><tr>
	<td bgcolor="<?=$back?>">
	<?=_FAVAT?>: </td>

	<td bgcolor="<?=$back?>">
	<img name="avatar" src="../images/nonews.png" alt="avatar" border="0" style="max-width:120px;" />
	<br />
	<select name="ava" onChange='document.avatar.src="images/"+this.options[this.selectedIndex].value'>
	<option value="">----</option>
	<?
	#$modlist = "";
	$modlist = array();
	$handle=opendir('images');
	while ($file = readdir($handle)) {
        if (!( $file=="." or $file==".." )) {
			array_push($modlist, $file);
		}
	}
	closedir($handle);
	if(count($modlist)>0)
		sort($modlist);
	for ($i=0; $i < count($modlist); $i++) {
		echo "<option value=\"$modlist[$i]\">$modlist[$i]</option>\n";
	}?>
	</select>
	<br /><br />
	<?=_FAVATREM?>:<br /><br />
	<input type="text" name="url_avatar" />
	</td>
	</tr><tr>
	<td bgcolor="<?=$back?>" valign=top>
	<?=_FFIRMA?>:
	</td><td bgcolor="<?=$back?>">
	<textarea name=firma rows=5 cols=23></textarea>
	</td>
	</tr>
	<tr><td bgcolor="<?=$back?>" colspan=5>
	<blockquote><p><?=_REG_AGREEMENT_TERMS?></p></blockquote>
	<center>
	<input type=submit value="<?=_FINVIA?>" />
	</center>
	<!--</form>-->
	</td>
	</tr>
	</tbody>
	</table>
	</td>
	</tr>
	</tbody>
	</table>
	</form>
	<?
}



function main(){
	global $back,$border,$topicperpage,$postperpage,$giorni,$mesi,$fuso_orario;
	global $theme;

	$page=getparam("page", PAR_GET, SAN_FLAT);
	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

	if ($page == "") {$page = 0;}
	if ($page != 0) {$page = $page - 1;}

	?>
	<br /><br />
	<table border='0' cellspacing='0' cellpadding='0' bgcolor='<?=$border?>' width="95%">
	<tbody><tr>
	<td>
	<table width='100%' border='0' cellspacing='1' cellpadding='3'>
	<tbody>
	<tr>
	<? if(($myforum!="") and versecid2($myforum)){
		?><td bgcolor="<?=$back?>" colspan="5" align="center">
		<a href="index.php?op=newtopic&amp;mode=nuovo"><?=_FNUOVOTOP?></a>
		</td>
		</tr>
		<tr><?
	}
	?><td bgcolor="<?=$back?>">
	<b><?=_FTITTOP?></b>
	</td>
	<td bgcolor="<?=$back?>" align="center" width=100>
	<b><?=_FNPAG?></b>
	</td>

	<td bgcolor="<?=$back?>" align="center">
	<b><?=_FNMESS?></b>
	</td>
	<td bgcolor="<?=$back?>" align="center">
	<b><?=_FINIPOST?></b>
	</td>
	<td bgcolor="<?=$back?>" align="center">
	<b><?=_FULTPOST?></b>
	</td>

	</tr><?
	//////////////////////////////////////////////////////////////////
	// procedura per odinare i topic per data di modifica        /////
	//////////////////////////////////////////////////////////////////
	$topic=array();
	$files_directory = "topics";
	$new_array = array();
	$files = array();
	$fdirectory = opendir( "$files_directory" );
	while ($file = readdir($fdirectory)) {
		if (($file == ".") || ($file == "..")) {
		} else {
			array_push($files, $file);
		}
	}

	foreach($files as $key =>$file){
		$c_date = filemtime("$files_directory/$file");
		$new_array[$c_date] = $file;
	}
	krsort($new_array);

	while ($this_array = each($new_array)) {
		$value = $this_array['value'];
		$key = $this_array['key'];
		$key_convert = date("M j, h:ia", $key);
		array_push($topic, $value);
	}
	clearstatcache();

	// fine ordinamento topics
	for($x=$page*$topicperpage; $x<$topicperpage*($page+1); $x=$x+1) {
		if(isset($topic[$x]))
			$pippo=$topic[$x];
		else $pippo="";
		if($pippo!=""){
			$fp=file("topics/$pippo");
			$quanti=0;
			for($j=1; $j<count($fp);$j++){
				if(stristr($fp[$j],"</ff:post>"))
					$quanti+=1;
			}

			$string=get_file("topics/$pippo");
			$subj=get_xml_element("ff:topic",$string);
			$topicinfo=get_xml_array("ff:post",$string);
			$poster1=get_xml_element("ff:poster",$topicinfo[0]);
			$date1=get_xml_element("ff:postime",$topicinfo[0]);
			$poster2=get_xml_element("ff:poster",$topicinfo[$quanti-1]);
			$date2=get_xml_element("ff:postime",$topicinfo[$quanti-1]);

			$pages = "";
			for ($thispagenum = 1; $thispagenum <= ceil($quanti / $postperpage); $thispagenum = $thispagenum + 1) {
				$pages = $pages . "[<a href=\"index.php?op=topic&amp;quale=".str_replace(".xml","",$pippo)."&amp;page=" . $thispagenum ."\">".$thispagenum."</a>] ";
			}

			print "<tr><td bgcolor=\"$back\"><a href=\"index.php?op=topic&amp;quale=".str_replace(".xml","",$pippo)."\">$subj</a>";
			print "</td>";
			print "<td bgcolor=\"$back\" align=\"center\" width=100>$pages</td>";
			print "<td bgcolor=\"$back\" align=\"center\">$quanti</td>";
			print "<td bgcolor=\"$back\" align=\"center\">$poster1<br />";
			print $giorni[date("w",$date1+(3600*$fuso_orario))];
			print date(" d ",$date1+(3600*$fuso_orario));
			$tmp=date(" m",$date1+(3600*$fuso_orario));
			if ($tmp<10)
				$tmp=str_replace("0","",$tmp);
			print $mesi[$tmp-1];
			print date(" Y - ",$date1+(3600*$fuso_orario));
			print date("H:",$date1+(3600*$fuso_orario));
			print date("i",$date1+(3600*$fuso_orario));
			print "</td>";
			print "<td bgcolor=\"$back\" align=\"center\">$poster2<br />";
			print $giorni[date("w",$date2+(3600*$fuso_orario))];
			print date(" d ",$date2+(3600*$fuso_orario));
			$tmp=date(" m",$date2+(3600*$fuso_orario));
			if ($tmp<10)
				$tmp=str_replace("0","",$tmp);
			print $mesi[$tmp-1];
			print date(" Y - ",$date2+(3600*$fuso_orario));
			print date("H:",$date2+(3600*$fuso_orario));
			print date("i",$date2+(3600*$fuso_orario));
			print "</td></tr>";

			$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

			// permette di modificare e eliminare i post
			if((getlevel($myforum,"forum")==10) and versecid2($myforum)){
				print "<tr><td bgcolor=\"$back\" colspan=\"5\" align=\"center\">";
				print "<img src=\"../themes/$theme/images/modify.png\" alt=\"Modify\" />&nbsp;<a href=\"../index.php?mod=modcont&amp;file=forum/topics/$pippo&amp;from=forum\">"._MODIFICA."</a>";
				print " | <img src=\"../themes/$theme/images/delete.png\" alt=\"Delete\" />&nbsp;<a href='#' onclick=\"check('../verify.php?mod=delnews&amp;file=forum/topics/$pippo')\">"._ELIMINA."</a>";
				print "</td></tr>";
			}
		}
	}

	$pages = "";
	if(count($topic) > $topicperpage){
		for ($thispagenum = 1; $thispagenum <= ceil(count($topic) / $topicperpage); $thispagenum = $thispagenum + 1) {
			if($thispagenum != ($page+1))
				$pages = $pages . "[<a href=\"index.php?page=" . $thispagenum ."\">".$thispagenum."</a>] ";
			else $pages = $pages . "[".$thispagenum."] ";
		}
	}
	?><tr>
	<td align="center" colspan=6 bgcolor="<?=$back?>">
	<?=$pages?>
	</td></tr>
	</tbody>
	</table>
	</td>
	</tr>
	</tbody>
	</table><?
}



function vis_login(){
	global $back,$border;
	?><br /><br />
	<form action=index.php method=post>
	<table border='0' cellspacing='0' cellpadding='0' bgcolor='<?=$border?>' >
	<tbody><tr>
	<td>
	<table width='100%' border='0' cellspacing='1' cellpadding='3'>
	<tbody>
	<tr>
	<td bgcolor="<?=$back?>" colspan=5>
	<center>
	<b><?=_FLOGIN?></b></center>
	</td></tr><tr>
	<td bgcolor="<?=$back?>">

	<!--<form action=index.php method=post>-->
	<input type=hidden name=op value=login />

	<?=_NOMEUTENTE?>: </td><td bgcolor="<?=$back?>">
	<input name=nome /></td></tr><tr><td bgcolor="<?=$back?>">
	<?=_PASSWORD?>: </td><td bgcolor="<?=$back?>">
	<input name=logpassword type=password /></td></tr><tr><td bgcolor="<?=$back?>" colspan=5>
	<center><?
	// remember login checkbox
	global $remember_login;
	if($remember_login==1) {
		echo "<div style=\"margin:1em;\"><label for=\"rememberlogin\">"._REMEMBERLOGIN."</label>";
		echo "<input type=\"checkbox\" alt=\"remember_login\" name=\"rememberlogin\" id=\"rememberlogin\" /><br />";
		echo "</div>";
	} else echo "<br />";
	// login button
	?><input type=submit value="<?=_LOGIN?>" />
	</center>
	<!--</form>-->
	</td>
	</tr>
	</tbody>
	</table>
	</td>
	</tr>
	</tbody>
	</table>
	</form><?
}


function reg(){
	//controllo se  possibile registrarsi sulo sito
	if (isset($_GET['reguser']) or isset($_POST['reguser']) or isset($_COOKIE['reguser'])) die(_NONPUOI);
	global $reguser;
	if ($reguser!="1") die(_NONPUOI);

	global $back,$border;
	$nome=getparam("nome",PAR_POST,SAN_FLAT);
	if(isset($_POST['regpass'])) $regpass=$_POST['regpass'];
		else $regpass="";
	if(isset($_POST['reregpass'])) $reregpass=$_POST['reregpass'];
		else $reregpass="";
	if(isset($_POST['anag'])) $anag=$_POST['anag'];
		else $anag="";
	if(isset($_POST['email'])) $email=$_POST['email'];
		else $email="";
	if(isset($_POST['homep'])) $homep=$_POST['homep'];
		else $homep="";
	if(isset($_POST['prof'])) $prof=$_POST['prof'];
		else $prof="";
	if(isset($_POST['prov'])) $prov=$_POST['prov'];
		else $prov="";
	if(isset($_POST['ava'])) $ava=$_POST['ava'];
		else $ava="";
	if(isset($_POST['url_avatar']) AND eregi("(jpg|jpeg|png|gif)",get_file_extension($_POST['url_avatar'])) )
		$url_avatar=$_POST['url_avatar'];
		else $url_avatar="images/blank.png";
	if(isset($_POST['firma'])) $firma=$_POST['firma'];
		else $firma="";

	$nome=str_replace("\r","",str_replace("\n","",$nome));
	$nome=str_replace(chr(10),"",str_replace(chr(13),"",$nome));
	$nome=str_replace(".","",$nome);
	$nome=str_replace("/","",$nome);
	$nome=str_replace("\\","",$nome);

	$regpass=str_replace("\r","",str_replace("\n","",$regpass));
	$regpass=str_replace(chr(10),"",str_replace(chr(13),"",$regpass));

	$reregpass=str_replace("\r","",str_replace("\n","",$reregpass));
	$reregpass=str_replace(chr(10),"",str_replace(chr(13),"",$reregpass));

	$anag=str_replace("\r","",str_replace("\n","",$anag));
	$anag=str_replace(chr(10),"",str_replace(chr(13),"",$anag));

	$email=str_replace("\r","",str_replace("\n","",$email));
	$email=str_replace(chr(10),"",str_replace(chr(13),"",$email));

	$homep=str_replace("\r","",str_replace("\n","",$homep));
	$homep=str_replace(chr(10),"",str_replace(chr(13),"",$homep));

	$prof=str_replace("\r","",str_replace("\n","",$prof));
	$prof=str_replace(chr(10),"",str_replace(chr(13),"",$prof));

	$prov=str_replace("\r","",str_replace("\n","",$prov));
	$prov=str_replace(chr(10),"",str_replace(chr(13),"",$prov));

	$ava=str_replace("\r","",str_replace("\n","",$ava));
	$ava=str_replace(chr(10),"",str_replace(chr(13),"",$ava));

	$url_avatar=str_replace("\r","",str_replace("\n","",$url_avatar));
	$url_avatar=str_replace(chr(10),"",str_replace(chr(13),"",$url_avatar));

	$firma=str_replace("\r","",str_replace("\n","",$firma));
	$firma=str_replace(chr(10),"",str_replace(chr(13),"",$firma));

	# Simple control to verify if the user have the default email
	/*if($email != $_POST['tmp_usr']."@(domain)"){
	}else{
		$email = "";
	}*/

	//XXX
	// solo alla primo che si registra
	// verr dato livello=10

	?>
	<br /><br />
	<table border='0' cellspacing='0' cellpadding='0' bgcolor='<?=$border?>' width="95%">
	<tbody><tr>
	<td>
	<table width='100%' border='0' cellspacing='1' cellpadding='3'>
	<tbody>
	<tr>
	<td bgcolor="<?=$back?>" colspan=5>
	<?
	if(!file_exists("users/$nome.php")){
		if(($nome=="") OR ($regpass=="") OR (stristr($nome," ")) OR (strlen($nome)>13) OR (stristr($nome,"\"")) OR (stristr($nome,"\\")) OR ($regpass != $reregpass) or !is_alphanumeric($nome)){
			print _FERRCAMPO."<br />
		<a href=\"javascript:history.back()\">&lt;&lt;"._INDIETRO."</a>";
		}
		else{ // checking for files in users' directory -> MUST be empty at first install!!
			$path = "users";
			$members = array();
			$dhandle = opendir($path);
			while ($file = readdir($dhandle)) {
				if (($file != ".") AND ($file != "..")) {
					array_push($members, $file);
				}
			}
			closedir($dhandle);
			// installing profile
			if(file_exists("../misc/firstinstall")) {
				if(count($members)==0) {
					$level=10;
				}
			else $level=0;
			unlink("../misc/firstinstall");
			}
			else {
				$level=0;
			}

			$nome=str_replace("<","",$nome);
			$nome=str_replace(">","",$nome);
			$nome=stripslashes($nome);
			$regpass=str_replace("<","",$regpass);
			$regpass=str_replace(">","",$regpass);
			$anag=str_replace(">","",$anag);
			$anag=str_replace("<","",$anag);
			$anag=stripslashes($anag);
			$email=str_replace("<","",$email);
			$email=str_replace(">","",$email);
			$email=stripslashes($email);
			$homep=str_replace("<","",$homep);
			$homep=str_replace(">","",$homep);
			$homep=stripslashes($homep);
			$prof=str_replace("<","",$prof);
			$prof=str_replace(">","",$prof);
			$prof=stripslashes($prof);
			$prov=str_replace("<","",$prov);
			$prov=str_replace(">","",$prov);
			$prov=stripslashes($prov);
			$ava=str_replace("<","",$ava);
			$ava=str_replace(">","",$ava);
			if ($ava=="")
				$ava="blank.png";
			if ($url_avatar!="images/blank.png") {
				$ava = $url_avatar;
				$ava = str_replace("<", "", $ava);
				$ava = str_replace(">", "", $ava);
			}
			else {
				$ava = str_replace("<", "", $ava);
				$ava = str_replace(">", "", $ava);
				$ava = "images/".$ava;
			}
			$firma=str_replace("<","",$firma);
			$firma=str_replace(">","",$firma);
			$firma=stripslashes($firma);
			# Mette la password in MD5
			$regpass = md5 ($regpass);
			$firma=str_replace("\n","<br />",$firma);
			/*$fp=fopen("users/$nome.php","w");
			// queste write non hanno bisogno di controlli
			// d'accesso concorrente in quanto
			// sono accessibili solo dall'utente
			// sul proprio file
			fwrite($fp,"<?exit(1);\n");
			fwrite($fp,"#$regpass\n");
			fwrite($fp,"#$anag\n");
			fwrite($fp,"#$email\n");
			fwrite($fp,"#$homep\n");
			fwrite($fp,"#$prof\n");
			fwrite($fp,"#$prov\n");
			fwrite($fp,"#$ava\n");
			fwrite($fp,"#$firma\n");
			fwrite($fp,"#$level\n");
			fwrite($fp,"?>\n");
			fclose($fp);*/
			$string  = "<?exit(1);\n";
			$string .= "#$regpass\n";
			$string .= "#$anag\n";
			$string .= "#$email\n";
			$string .= "#$homep\n";
			$string .= "#$prof\n";
			$string .= "#$prov\n";
			$string .= "#$ava\n";
			$string .= "#$firma\n";
			$string .= "#$level\n";
			$string .= "?>\n";
			fnwrite("users/$nome.php", $string, "w", array("nonull"));


			$addr=getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
			$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

			fnlog("Forum", $addr."||".$myforum."||New registered user $nome.");

			echo _FORAREG;
			?><br />
			<a href="index.php?op=vis_login">&lt;&lt;<?=_LOGIN?></a><?
		}
	}
	else{
		?><?=_FUSERSCE?><br /><a href="index.php?op=vis_reg">&lt;&lt;<?=_INDIETRO?></a><?
	}
	?>
	</td>
	</tr>
	</tbody>
	</table>
	</td>
	</tr>
	</tbody>
	</table><?
}



function login(){
	global $back,$border;
	$nome=getparam("nome",PAR_POST,SAN_FLAT);
	$nome=str_replace("<","",$nome);
	$nome=str_replace(">","",$nome);
	$from=getparam("from",PAR_POST,SAN_FLAT);
	$logpassword=getparam("logpassword",PAR_POST,SAN_FLAT);
	$rememberlogin = getparam("rememberlogin", PAR_POST, SAN_FLAT);

	$lpass=md5($logpassword);

	if(!file_exists("users/$nome.php") || ($nome=="")){
		include "header.php";
		?><br /><br />
		<table border='0' cellspacing='0' cellpadding='0' bgcolor='<?=$border?>' width="95%">
		<tbody><tr>
		<td>
		<table width='100%' border='0' cellspacing='1' cellpadding='3'>
		<tbody>
		<tr>
		<td bgcolor="<?=$back?>" colspan=5>
		<b><?=$nome?></b> <?=_FNONREG?><br /><a href="index.php?op=vis_reg">&lt;&lt;<?=_REGORA?></a>
		</td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table><?
	}
	else {
		$fp=file("users/$nome.php");
		$tmp=chop($fp[1]);
		$passwd=str_replace("#","",$tmp);
		if($passwd==$lpass){
		// imposto bene il path del cookie!
			$url=getparam("PHP_SELF",PAR_SERVER, SAN_FLAT);
			$path=pathinfo($url);
			$url=str_replace("/forum","",$path["dirname"]);
			if($url=="")
				$url="/";
			// manage cookies' life
			include_once "../config.php";
			if($remember_login==0 OR $rememberlogin=="") {
				setcookie("myforum",$nome,0,"$url");
				setcookie("secid",md5($nome.getpass($nome)),0,"$url");
			} else {
				setcookie("myforum",$nome,time()+99999999,"$url");
				setcookie("secid",md5($nome.getpass($nome)),time()+99999999,"$url");
			}
			$addr=getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
			$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

			fnlog("Forum", $addr."||".$myforum."||User $nome login.");

			if($from=="home"){
				?><script language=javascript>window.location='<?=getparam("HTTP_REFERER", PAR_SERVER, SAN_FLAT)?>';</script><?
			} else{
				include "header.php";
				if(stristr(getparam("HTTP_REFERER", PAR_SERVER, SAN_FLAT),"op=vis_login")){
				?><script language=javascript>window.location='index.php';</script><?		}
				else {
				?><script language=javascript>window.location='<?=getparam("HTTP_REFERER", PAR_SERVER, SAN_FLAT)?>';</script><?}
			}
	 	}
		else{
			include "header.php";
			?><br /><br />
			<table border='0' cellspacing='0' cellpadding='0' bgcolor="<?=$border?>" width="95%">
			<tbody><tr>
			<td>
			<table width='100%' border='0' cellspacing='1' cellpadding='3'>
			<tbody>
			<tr>
			<td bgcolor="<?=$back?>" colspan=5>
			<b><?=$nome?></b> <?=_FERRPASS?><br /><a href="javascript:history.back()">&lt;&lt;<?=_INDIETRO?></a>
			</td>
			</tr>
			</tbody>
			</table>
			</td>
			</tr>
			</tbody>
			</table><?
		}
	}
}



function logout(){

	$from = getparam("from", PAR_GET, SAN_FLAT);
	$url=getparam("PHP_SELF",PAR_SERVER, SAN_FLAT);

	$path=pathinfo($url);
	$url=str_replace("/forum","",$path["dirname"]);
	if($url=="")
		$url="/";
	$addr=getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

	setcookie("secid","",NULL,"$url");
	setcookie("myforum","",NULL,"$url");

	fnlog("Forum", $addr."||".$myforum."||User $myforum logout.");

	if ($from=="home"){
		?><script language=javascript>window.location='<?=getparam("HTTP_REFERER", PAR_SERVER, SAN_FLAT)?>';</script><?
	}
	else{
		?><script language=javascript>window.location='<?=getparam("HTTP_REFERER", PAR_SERVER, SAN_FLAT)?>';</script><?
	}

}



function members(){
	global $border,$back,$memberperpage;

	$page=getparam("page", PAR_GET, SAN_FLAT);
	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
	$req=getparam("REQUEST_URI",PAR_SERVER, SAN_FLAT);
	if(strstr($req,"myforum="))
		die(_NONPUOI);

	if ($page == "") {$page = 0;}
	if ($page != 0) {$page = $page - 1;}

	?><br /><br />
	<table border='0' cellspacing='0' cellpadding='0' bgcolor="<?=$border?>" width="95%">
	<tbody><tr>
	<td>
	<table width='100%' border='0' cellspacing='1' cellpadding='3'>
	<tbody>
	<tr><?

	if (($myforum!="") and versecid2($myforum)){?>
		<td bgcolor="<?=$back?>">
			<b><?=_NOMEUTENTE?></b>
		</td>
		<td bgcolor="<?=$back?>">
			<b><?=_LEVEL?></b>
		</td>
		<td bgcolor="<?=$back?>">
			<b><?=_FNOME?></b>
		</td>
		<td bgcolor="<?=$back?>">
			<b><?=_FEMAIL?></b>
		</td>
		<td bgcolor="<?=$back?>">
			<b><?=_FHOME?></b>
		</td>
		</tr><?

		$members=array();
		$dhandle = opendir("users");
		while ($file = readdir($dhandle)) {
			if (($file == ".") || ($file == "..") ||($file==".php")) {
			} elseif(get_file_extension($file)=="php") {
				array_push($members, $file);
			}
		}
		sort ($members);
		reset ($members);
		for($x=$page*$memberperpage; $x<$memberperpage*($page+1); $x=$x+1) {
			if (isset($members[$x])) {
				$pippo=$members[$x];
				print "<tr>";
				print "<td bgcolor=\"$back\" >";
				$fp=file("users/$pippo");
				$tmp=str_replace(".php","",$pippo);
				print "<a href=\"index.php?op=profile&amp;user=$tmp\">$tmp</a><br />";
				print "</td>";
				print "<td bgcolor=\"$back\" align='center'>".str_replace("#","",$fp[9])."</td>";
				print "<td bgcolor=\"$back\">".str_replace("#","",$fp[2])."</td>";
				print "<td bgcolor=\"$back\"><a href=\"mailto:".email_mask(str_replace("#","",$fp[3]))."\">".str_replace("%20"," ",email_mask(str_replace("#","",$fp[3])))."</a></td>";
				print "<td bgcolor=\"$back\"><a href=\"".str_replace("\n","",str_replace("#","",$fp[4]))."\" target=blank>".str_replace("\n","",str_replace("#","",$fp[4]))."</a></td>";
				print "</tr>";
			}
		}
		$pages="";
		if(count($members)>$memberperpage){
			$pages = "";
			for ($thispagenum = 1; $thispagenum <= ceil(count($members) / $memberperpage); $thispagenum = $thispagenum + 1) {
				if($thispagenum != ($page+1))
					$pages = $pages . "[<a href=\"index.php?op=members&amp;page=" . $thispagenum ."\">".$thispagenum."</a>] ";
				else
					$pages = $pages . "[".$thispagenum."] ";
			}
		}
		?><tr>
		<td bgcolor="<?=$back?>" align=center colspan=5>
		<?=$pages;?>
		</td>
		</tr>
		<?
	}
	else{
		print "<td bgcolor=\"$back\">"._FERRACC."</td></tr>";
	}
	?></tbody>
	</table>
	</td>
	</tr>
	</tbody>
	</table><?
}



function profile(){
	global $back,$border;

	$user=getparam("user", PAR_GET, SAN_FLAT);
	if($user=="")
		return;

	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

	if(!file_exists("users/$user.php")) {?>
		<br /><br />
		<table border='0' cellspacing='0' cellpadding='0' bgcolor='<?=$border?>' width='400'>
		<tbody><tr>
		<td>
		<table width='100%' border='0' cellspacing='1' cellpadding='3'>
		<tbody>
		<tr>
		<td bgcolor="<?=$back?>" colspan=5 rowspan=6 valign=top align=center>User not registered
		</td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table><?
			return;

		}

	if(($myforum!="") and versecid2($myforum)){
		?><br /><br />
		<table border='0' cellspacing='0' cellpadding='0' bgcolor='<?=$border?>' width='400'>
		<tbody><tr>
		<td>
		<table width='100%' border='0' cellspacing='1' cellpadding='3'>
		<tbody>
		<tr>
		<td bgcolor="<?=$back?>" colspan=5 rowspan=6 valign=top align=center>
		<?
		$fp=file("users/$user.php");
		?><b><?=$user?></b>
		<br /><br />
		<img src="<?=eregi_replace("\n","",str_replace("#","",$fp[7]))?>" alt="avatar" border="0" style="max-width:120px;" />
		<br /><br /><?
		if (($myforum==$user) and versecid2($myforum)){
			print "<a href=\"index.php?op=modprof&amp;user=$user\">"._FMODPROF."</a> ";
		}
		?>
		</td>
		<td bgcolor="<?=$back?>"><b><?=_FNOME?>:</b></td>
		<td bgcolor="<?=$back?>"><?=stripslashes(str_replace("#","",$fp[2]))?></td>
		</tr>
		<tr>
		<td bgcolor="<?=$back?>"><b><?=_FEMAIL?>:</b></td>
		<td bgcolor="<?=$back?>"><a href="mailto:<?=email_mask(str_replace("#","",$fp[3]))?>"><?=str_replace("%20"," ",email_mask(str_replace("#","",$fp[3])))?></a></td>
		</tr>
		<tr>
		<td bgcolor="<?=$back?>"><b><?=_FHOME?>:</b></td>
		<td bgcolor="<?=$back?>"><a href=<?=str_replace("\n","",str_replace("#","",$fp[4]))?> target=blank><?=str_replace("\n","",str_replace("#","",$fp[4]))?></a></td>
		</tr>
		<tr>
		<td bgcolor="<?=$back?>"><b><?=_FPROFES?>:</b></td>
		<td bgcolor="<?=$back?>"><?=stripslashes(str_replace("#","",$fp[5]))?></td>
		</tr>
		<tr>
		<td bgcolor="<?=$back?>"><b><?=_FPROV?>:</b></td>
		<td bgcolor="<?=$back?>"><?=stripslashes(str_replace("#","",$fp[6]))?></td>
		</tr>
		<tr>
		<td bgcolor="<?=$back?>"><b><?=_LEVEL?>:</b></td>
		<td bgcolor="<?=$back?>"><?=stripslashes(str_replace("#","",$fp[9]))?></td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table><?
		// se sono io che modifico il mio profilo o sono un'amministratore
		$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
		if(((getparam("user", PAR_GET, SAN_FLAT)==$myforum) and versecid2($user)) or ((getlevel($myforum,"forum")==10) and versecid2($myforum))){
			print "<br /><b><a href='#' onclick=\"check('index.php?op=deluser&amp;user=".getparam("user",PAR_GET,SAN_FLAT)."')\">"._FDELUTENTE."</a></b>&nbsp;|&nbsp;";
			print "<b><a href=\"index.php?op=modprof&amp;user=".getparam("user",PAR_GET,SAN_FLAT)."\">"._FMODPROF."</a></b>";
		}
	}
	else
		print "<br /><table><td bgcolor=\"$back\">"._FERRACC."</td></tr></table>";
}



function modprof(){
	global $back,$border;
	$user=getparam("user", PAR_GET, SAN_FLAT);

	if($user=="")
		return;

	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

	$req=getparam("REQUEST_URI",PAR_SERVER, SAN_FLAT);
	if(strstr($req,"myforum="))
		die(_NONPUOI);

	// io posso modificare il mio profilo
	// l'amministratore pu modificare tutti i profili
	if((($user==$myforum) and versecid2($user)) or ((getlevel($myforum,"forum")==10) and versecid2($myforum))){
		$fp=file("users/$user.php");
		?><br /><br />
		<form action=index.php method=post name=registra>
		<table border='0' cellspacing='0' cellpadding='0' bgcolor='<?=$border?>' >
		<tbody><tr>
		<td>
		<table width='100%' border='0' cellspacing='1' cellpadding='3'>
		<tbody>
		<tr>
		<td bgcolor="<?=$back?>" colspan=5>
		<center>
		<b><?=_FMODPROFTIT?> <?=$user?></b>
		</center>
		</td></tr>
		<tr>
		<td bgcolor="<?=$back?>">

		<!--<form action=index.php method=post name=registra>-->
		<input type=hidden name=op value=reg_sic />
		<input type=hidden name=nome value=<?=$user?> />

		<?=_PASSWORD?>*: <br />(<?=_FDIVERS?>)</td><td bgcolor="<?=$back?>">
		<input name=regpass type=password value="" /></td>
		</tr><tr>
		<td bgcolor="<?=$back?>">
		<?=_FNOME?>: </td><td bgcolor="<?=$back?>">
		<input name=anag value="<?=stripslashes(str_replace("#","",$fp[2]))?>" /></td>
		</tr><tr>
		<td bgcolor="<?=$back?>">
		<?=_FEMAIL?>: </td><td bgcolor="<?=$back?>">
		<input name=email value="<?=stripslashes(str_replace("#","",$fp[3]))?>" /></td>
		</tr><tr>
		<td bgcolor="<?=$back?>">
		<?=_FHOME?>: </td><td bgcolor="<?=$back?>">
		<input name=homep value="<?=stripslashes(str_replace("\n","",str_replace("#","",$fp[4])))?>" /></td>
		</tr><tr>
		<td bgcolor="<?=$back?>">
		<?=_FPROFES?>: </td><td bgcolor="<?=$back?>">
		<input name=prof value="<?=stripslashes(str_replace("#","",$fp[5]))?>" /></td>
		</tr><tr>
		<td bgcolor="<?=$back?>">
		<?=_FPROV?>: </td><td bgcolor="<?=$back?>">
		<input name=prov value="<?=stripslashes(str_replace("#","",$fp[6]))?>" /></td>
		</tr><tr>
		<td bgcolor="<?=$back?>">
		<?=_FAVAT?>:
		<!--</font>--></td><td bgcolor="<?=$back?>">

		<img name="avatar" src="<?=str_replace("\n","",str_replace("#","",$fp[7]))?>" alt="avatar" border="0" style="max-width:120px;" />
		<br />
		<select name="ava" onChange='document.avatar.src="images/"+this.options[this.selectedIndex].value'>
		<option value="">----</option><?
		$modlist = array();
		$handle=opendir('images');
		while ($file = readdir($handle)) {
			if (!( $file=="." or $file==".." )) {
				array_push($modlist, $file);
			}
		}
		closedir($handle);
		if(count($modlist)>0)
			sort($modlist);
		for ($i=0; $i < sizeof($modlist); $i++) {
			echo "<option value=\"$modlist[$i]\" ";
			if((str_replace("#images/","",$fp[7]))==$modlist[$i]."\n")
				echo "selected='selected'";
			echo ">$modlist[$i]</option>\n";
        }
		?>
		</select><br /><br />
		<?=_FAVATREM?>:<br /><br /><?
		if(strstr($fp[7],"http://")){
			print "<input type=\"text\" name=\"url_avatar\" value=".str_replace("#","",$fp[7])." />";
		}
		else {
			print "<input type=\"text\" name=\"url_avatar\" />";
		}
		?></td>
		</tr><tr>
		<td bgcolor="<?=$back?>" valign=top>
		<?=_FFIRMA?>:
		</td>
		<td bgcolor="<?=$back?>">
		<?$tmp=str_replace("#","",$fp[8]);
		$tmp=str_replace("<br />","\n",$tmp);
		$tmp=chop($tmp);
		?><textarea name=firma rows=5 cols=23><?=stripslashes($tmp);?></textarea>
		</td><?
		$level=str_replace("#","",str_replace("\n","",$fp[9]));
		$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
		if((getlevel($myforum,"forum")==10) and versecid2($myforum)){
			?></tr><tr>
			<td bgcolor="<?=$back?>" valign=top>
			<?=_LEVEL?>
			</td>
			<td bgcolor="<?=$back?>" valign=top>
			<?
			print("<select name=\"level\">");
			for($i=0;$i<11;$i++){
				if($level==$i)
					print("<option value=\"$i\" selected='selected'>$i</option>");
				else print("<option value=\"$i\" >$i</option>");
			}
			print("</select>");
			?>
			</td><?
		}
		?></tr><tr><td bgcolor="<?=$back?>" colspan=5>
		<center>
		<?
		if ( !(getlevel($myforum,"forum")==10 and versecid2($myforum)) ) {
			print("<input name=\"level\" value=\"$level\" type=\"hidden\" />");
		}
		?>
		<input type=submit value="<?=_FINVIA?>" />
		</center>
		<!--</form>-->
		</td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table>
		</form><?
	}
}



function reg_sic(){

	//controllo se  possibile registrarsi sulo sito
	if (isset($_GET['reguser']) or isset($_POST['reguser']) or isset($_COOKIE['reguser'])) die(_NONPUOI);
	global $reguser;
	if ($reguser!="1"){
		//posso continuare solo se sto modificando il mio profilo.
		//oppure se sto modificando il profilo di un altro in qualit di amministratore
		$nome="";
		$myforum="";
		$nome=getparam("nome",PAR_POST,SAN_FLAT);
		$nome=str_replace("\r","",str_replace("\n","",$nome));
		$nome=str_replace(chr(10),"",str_replace(chr(13),"",$nome));
		$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
		if (!is_alphanumeric($nome)) die(_NONPUOI);
		if (!file_exists("users/$nome.php")) die(_NONPUOI."1");
		if (getlevel($myforum,"forum")=="-1") die(_NONPUOI."2");
		if (!versecid2($myforum)) die(_NONPUOI."2 1/2");
		if ($nome!=$myforum and !(getlevel($myforum,"forum")=="10" and versecid2($myforum))) die(_NONPUOI."3");
// 		if (!(getlevel($myforum,"forum")!="-1" and versecid($myforum))) die(_NONPUOI."4");
// 	die(_NONPUOI);
	}
	global $back,$border;

	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
	$nome=getparam("nome",PAR_POST,SAN_FLAT);

	if(isset($_POST['regpass'])) $regpass=$_POST['regpass'];
		else $regpass="";
	if(isset($_POST['reregpass'])) $reregpass=$_POST['reregpass'];
		else $reregpass="";
	if(isset($_POST['anag'])) $anag=$_POST['anag'];
		else $anag="";
	if(isset($_POST['email'])) $email=$_POST['email'];
		else $email="";
	if(isset($_POST['homep'])) $homep=$_POST['homep'];
		else $homep="";
	if(isset($_POST['prof'])) $prof=$_POST['prof'];
		else $prof="";
	if(isset($_POST['prov'])) $prov=$_POST['prov'];
		else $prov="";
	if(isset($_POST['ava'])) $ava=$_POST['ava'];
		else $ava="";
	if(isset($_POST['url_avatar']) AND eregi("(jpg|jpeg|png|gif)",get_file_extension($_POST['url_avatar'])) )
		$url_avatar=$_POST['url_avatar'];
		else $url_avatar="images/blank.png";
	if(isset($_POST['firma'])) $firma=$_POST['firma'];
		else $firma="";
	if(isset($_POST['level'])) $level=$_POST['level'];
		else $level="";

	$myforum=str_replace("\r","",str_replace("\n","",$myforum));
	$myforum=str_replace(chr(10),"",str_replace(chr(13),"",$myforum));
	$myforum=str_replace(".","",$myforum);
	$myforum=str_replace("/","",$myforum);
	$myforum=str_replace("\\","",$myforum);
	$regpass=str_replace("\r","",str_replace("\n","",$regpass));
	$regpass=str_replace(chr(10),"",str_replace(chr(13),"",$regpass));
	$anag=str_replace("\r","",str_replace("\n","",$anag));
	$anag=str_replace(chr(10),"",str_replace(chr(13),"",$anag));
	$nome=str_replace("\r","",str_replace("\n","",$nome));
	$nome=str_replace(chr(10),"",str_replace(chr(13),"",$nome));
	$email=str_replace("\r","",str_replace("\n","",$email));
	$email=str_replace(chr(10),"",str_replace(chr(13),"",$email));
	$homep=str_replace("\r","",str_replace("\n","",$homep));
	$homep=str_replace(chr(10),"",str_replace(chr(13),"",$homep));
	$prof=str_replace("\r","",str_replace("\n","",$prof));
	$prof=str_replace(chr(10),"",str_replace(chr(13),"",$prof));
	$prov=str_replace("\r","",str_replace("\n","",$prov));
	$prov=str_replace(chr(10),"",str_replace(chr(13),"",$prov));
	$ava=str_replace("\r","",str_replace("\n","",$ava));
	$ava=str_replace(chr(10),"",str_replace(chr(13),"",$ava));
	$url_avatar=str_replace("\r","",str_replace("\n","",$url_avatar));
	$url_avatar=str_replace(chr(10),"",str_replace(chr(13),"",$url_avatar));
	$firma=str_replace("\r","",str_replace("\n","",$firma));
	$firma=str_replace(chr(10),"",str_replace(chr(13),"",$firma));
	$level=str_replace("\r","",str_replace("\n","",$level));
	$level=str_replace(chr(10),"",str_replace(chr(13),"",$level));


	//registro limite
	if($level>10)
		$level=10;
	// io posso modificare il mio ma solo se mantengo il livello!!!
	// l'amministratore pu modificare tutti i profili

	if((($nome==$myforum) and (getlevel($nome,"forum")==$level) and versecid2($nome)) or ((getlevel($myforum,"forum")==10) and versecid2($myforum))){
		?><br /><br />
		<table border='0' cellspacing='0' cellpadding='0' bgcolor="<?=$border?>" width="95%">
		<tbody><tr>
		<td>
		<table width='100%' border='0' cellspacing='1' cellpadding='3'>
		<tbody>
		<tr>
		<td bgcolor="<?=$back?>" colspan=5>
		<?
		$nome=str_replace("<","",$nome);
		$nome=str_replace(">","",$nome);
		$nome=stripslashes($nome);
		$regpass=str_replace("<","",$regpass);
		$regpass=str_replace(">","",$regpass);
		$anag=str_replace("<","",$anag);
		$anag=str_replace(">","",$anag);
		$anag=stripslashes($anag);
		$email=str_replace("<","",$email);
		$email=str_replace(">","",$email);
		$email=stripslashes($email);
		$homep=str_replace("<","",$homep);
		$homep=str_replace(">","",$homep);
		$homep=stripslashes($homep);
		$prof=str_replace("<","",$prof);
		$prof=str_replace(">","",$prof);
		$prof=stripslashes($prof);
		$prov=str_replace("<","",$prov);
		$prov=str_replace(">","",$prov);
		$prov=stripslashes($prov);
		if ($url_avatar!="images/blank.png") {
			$ava = $url_avatar;
			$ava = str_replace("<", "", $ava);
			$ava = str_replace(">", "", $ava);
		} else {
			$ava = "images/".$ava;
			$ava = str_replace("<", "", $ava);
			$ava = str_replace(">", "", $ava);
		}
		//$ava=str_replace("<","",$ava);
		//$ava=str_replace(">","",$ava);
		$firma=str_replace("<","",$firma);
		$firma=str_replace(">","",$firma);
		$firma=stripslashes($firma);
		# Mette la pass in MD5
		if(($regpass=="")){
			$fpp=file("users/$nome.php");
			$regpass=str_replace("\n","",(str_replace("#","",$fpp[1])));
		}
		else{
			$regpass = md5 ($regpass);
		}
		$firma=str_replace("\n","<br />",$firma);
		/*$fp=fopen("users/$nome.php","w");
		// queste write non hanno bisogno di controlli
		// d'accesso concorrente in quanto
		// sono accessibili solo dall'utente
		// sul proprio file
		fwrite($fp,"<?exit(1);\n");
		fwrite($fp,"#$regpass\n");
		fwrite($fp,"#$anag\n");
		fwrite($fp,"#$email\n");
		fwrite($fp,"#$homep\n");
		fwrite($fp,"#$prof\n");
		fwrite($fp,"#$prov\n");
		fwrite($fp,"#$ava\n");
		fwrite($fp,"#$firma\n");
		fwrite($fp,"#$level\n");
		fwrite($fp,"?>\n");
		fclose($fp);*/
		$string  = "<?exit(1);\n";
		$string .= "#$regpass\n";
		$string .= "#$anag\n";
		$string .= "#$email\n";
		$string .= "#$homep\n";
		$string .= "#$prof\n";
		$string .= "#$prov\n";
		$string .= "#$ava\n";
		$string .= "#$firma\n";
		$string .= "#$level\n";
		$string .= "?>\n";
		fnwrite("users/$nome.php", $string, "w", array("nonull"));
		fnlog("Forum", getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT)."||".$myforum."||User $myforum changed his profile.");?>
		<?=_FOKMODPROF?>
		</td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table>
		<!-- automatic redirect to the message after 2 seconds -->
		<meta http-equiv="Refresh" content="1; URL=index.php?op=profile&amp;user=<?=$nome?>"><?
	}
}



function topic(){
	global $back,$border,$postperpage,$giorni,$mesi,$fuso_orario,$theme;

	$quale=getparam("quale", PAR_GET, SAN_FLAT);
	$page=getparam("page", PAR_GET, SAN_FLAT);

	if(stristr($quale,".."))
		die(_NONPUOI);

	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

	if(!file_exists("topics/$quale".".xml")) {
		OpenTable();
		print("<div align='middle'><b>"._NORESULT."</b></div>");
		CloseTable();
		return;
	}

	$string=get_file("topics/$quale.xml");
	$posts=get_xml_array("ff:post",$string);
	if($page==""){$page=0;}
	if($page!=0){$page=$page-1;}

	?><br /><br />
	<table border='0' cellspacing='0' cellpadding='0' bgcolor="<?=$border?>" width="95%">
	<tbody><tr>
	<td>
	<table width='100%' border='0' cellspacing='1' cellpadding='3'>
	<tbody>
	<tr>
	<? if(($myforum!="") and versecid2($myforum)){
		?><td bgcolor="<?=$back?>" colspan=4 align=center>
		<a href="index.php?op=newtopic&amp;mode=ris&amp;quale=<?=$quale?>&amp;page=<?=$page+1?>"><?=_FRISP?></a>
		</td>
		</tr>
		<tr><?
	}
	?><td bgcolor="<?=$back?>" align="center">
	<b><?=_FUTENTE?></b>
	</td>
	<td bgcolor="<?=$back?>" align="center">
	<b><?=_FMESS?></b>
	</td>
	</tr><?
	for($x=$page*$postperpage; $x<$postperpage*($page+1); $x=$x+1) {
		if(isset($posts[$x]))
			$unsplitpost = $posts[$x];
		else
			$unsplitpost="";
		if ($unsplitpost != "") {
			$poster=get_xml_element("ff:poster",$unsplitpost);
			$subj=get_xml_element("ff:subj",$unsplitpost);
			$postbody=get_xml_element("ff:postbody",$unsplitpost);
			$postime=get_xml_element("ff:postime",$unsplitpost);
			?><tr>
			<td bgcolor="<?=$back?>"  valign="top" align="center" width="140">
			<?
			if (file_exists("users/$poster.php")){
				$fp=file("users/$poster.php");
				print "<img src=\"".str_replace("\n","",str_replace("#","",$fp[7]))."\" alt='avatar' border='0' style='max-width:120px;' /><br />";
				print "<br /><b>$poster</b><br /><br />";
				// tabella per livello
				$level=str_replace("#","",$fp[9]);
				if(!file_exists("../themes/$theme/images/level_y.gif") OR !file_exists("../themes/$theme/images/level_n.gif")) {
					$level_img_y = "../images/useronline/level_y.gif";
					$level_img_n = "../images/useronline/level_n.gif";
				} else {
					$level_img_y = "../themes/$theme/images/level_y.gif";
					$level_img_n = "../themes/$theme/images/level_n.gif";
				}
				print "<div style='position:relative;float:left;width:30px;'>0</div>";
				print "<div style='position:relative;float:right;width:30px;text-align:right;'>10</div>";
				print "<div style='position:relative;margin-left:0px;margin-right:0px;text-align:center;'><b>"._LEVEL." $level</b></div>";
				print "<div align='center'>";
				print "<hr size='1' noshade width='100%' />";
				for($i=0; $i<$level; $i++) {
					print "<img align='middle' src='$level_img_y' alt='level' />";
				}
				for($j=$i; $j<10; $j++) {
					print "<img align='middle' src='$level_img_n' alt='level' />";
				}
				print "<hr size='1' noshade width='100%' />";
				print "</div>";
				print "<a href=\"index.php?op=profile&amp;user=$poster\"><img src=\"icons/profile.png\" alt=\"profile\" border=0 /></a>&nbsp;<a href=\"mailto:".email_mask(str_replace("#","",$fp[3]))."\"><img src=\"icons/mail.png\" alt=\"mail\" border=0 /></a>&nbsp;<a href=\"".str_replace("\n","",str_replace("#","",$fp[4]))."\" target=blank><img src=\"icons/home.png\" alt=\"home page\" border=0 /></a>";
			}
			else{
				print "<br /><b>$poster</b>";
			}
			?></td><td bgcolor="<?=$back?>" valign="top"><?
			print $giorni[date("w",$postime+(3600*$fuso_orario))];
			print date(" d ",$postime+(3600*$fuso_orario));
			$tmp=date(" m",$postime+(3600*$fuso_orario));
			if ($tmp<10)
				$tmp=str_replace("0","",$tmp);
			print $mesi[$tmp-1];
			print date(" Y - ",$postime+(3600*$fuso_orario));
			print date("H:",$postime+(3600*$fuso_orario));
			print date("i",$postime+(3600*$fuso_orario));
			?><br /><br />
			<b><?=$subj?>:</b><br />
			<?=stripslashes($postbody)?>
			</td>
			</tr><?
		}
	}

	$pages = "";
	if(((count($posts)))>$postperpage){
		for ($thispagenum = 1; $thispagenum <= ceil((count($posts)) / $postperpage); $thispagenum = $thispagenum + 1) {
			if($thispagenum!=($page+1))
				$pages = $pages . "[<a href=\"index.php?op=topic&amp;quale=$quale&amp;page=" . $thispagenum ."\">".$thispagenum."</a>] ";
			else
				$pages = $pages . "[".$thispagenum."] ";
		}
	}
	?>
<!-- 	</td> -->
<!-- 	</tr> -->
	<tr><?
	if(($myforum!="") and versecid2($myforum)){
		?><td bgcolor="<?=$back?>" colspan=4 align="center">
		<a href="index.php?op=newtopic&amp;mode=ris&amp;quale=<?=$quale?>&amp;page=<?=$page+1?>"><?=_FRISP?></a>
		</td>
		</tr>
		<tr><?
	}
	?><td bgcolor="<?=$back?>" align="center" colspan=2>
	<?=$pages;?>
	</td>
	</tr>
	</tbody>
	</table>
	</td>
	</tr>
	</tbody>
	</table><?
}



function newtopic(){
	#mode vale nuovo o rispondi
	global $back,$border,$postperpage;

	$quale=getparam("quale", PAR_GET, SAN_FLAT);
	$page=getparam("page", PAR_GET, SAN_FLAT);
	$mode=getparam("mode", PAR_GET, SAN_FLAT);
	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

	if(stristr($quale,".."))
		die(_NONPUOI);

	if(($myforum!="") and versecid2($myforum)){
		// bbcodes panel
		bbcodes_js();
		?>
		<br /><br />
		<form action=index.php method=post name="newtopic">
		<table border='0' cellspacing='0' cellpadding='0' bgcolor="<?=$border?>" width="650">
		<tbody><tr>
		<td>
		<table width='100%' border='0' cellspacing='1' cellpadding='3'>
		<tbody>
		<tr>
		<td bgcolor="<?=$back?>" colspan=5>
		<center>
		<b><?
		if($mode=="nuovo"){
			print _FNUOVOTOP;
		}
		else{
			print _FNUOVOMESS;
		} ?>
		</b>
		<br />
		</center>
		</td></tr><tr>
		<td colspan="2" bgcolor="<?=$back?>" align="center">
		<!-- icone  -->
		<!--<form action=index.php method=post name="newtopic">-->
		<? // bbcodes panel
		bbcodes_panel("mess", "forum", "formatting"); echo " ";
		bbcodes_panel("mess", "forum", "emoticons"); echo "<br />";
		?>
		</td></tr><tr>
		<td bgcolor="<?=$back?>">
		<input type=hidden name=op value=regtopic />
		<input type=hidden name=quale value=<?=$quale?> />
		<input type=hidden name=mode value=<?=$mode?> />
		<?=_FOGG?>: </td>
		<td bgcolor="<?=$back?>"><?
		// include l'oggetto del messaggio originale
		// nell'oggetto del messaggio di risposta.
		$subjtmp="";
		if($mode=="ris"){
			if(!file_exists("topics/$quale".".xml")) {
				OpenTable();
				print("<div align='middle'><b>"._NORESULT."</b></div>");
				CloseTable();
				return;
			}
			$string=get_file("topics/$quale.xml");
			$subjtmp="Re: ".get_xml_element("ff:topic",$string);
		}
		?><input name=subj  value="<?=$subjtmp?>" size=63 /></td>
		</tr><tr>
		<td bgcolor="<?=$back?>" valign=top>
		<?=_FMESS?>: </td><td bgcolor="<?=$back?>">
		<textarea name=mess rows=20 cols=79></textarea></td>
		</tr>
		<tr><td bgcolor="<?=$back?>" colspan=5>
		<center>
		<input type=submit value="<?=_FINVIA?>" />
		</center>
<!-- 		</form> -->
		<!--
		<a href="emoticons" onclick="window.open('emoticons', 'emoticons.php', 'HEIGHT=200,resizable=yes,scrollbars=yes,WIDTH=250');return false;">Emoticons</a>-->
		</td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table>
		</form><?
		// include in fondo al messaggio l'ultima pagina del thread
		if($mode=="ris"){
			topic();
		}
	}
}



function regtopic(){
	global $back,$border,$postperpage;

	$quale=getparam("quale",PAR_POST,SAN_FLAT);

	if(stristr($quale,".."))
		die(_NONPUOI);

	$mode=$_POST['mode'];
	$subj=$_POST['subj'];
	$mess=$_POST['mess'];
	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

	if(($myforum!="") and versecid2($myforum)){
		?><br /><br />
		<table border='0' cellspacing='0' cellpadding='0' bgcolor="<?=$border?>" width="95%">
		<tbody><tr>
		<td>
		<table width='100%' border='0' cellspacing='1' cellpadding='3'>
		<tbody>
		<tr>
		<td bgcolor="<?=$back?>" colspan=5>
		<?
		if(($subj=="")||($mess=="")){
			print _FERRCAMPO."<br /><a href=\"javascript:history.back()\">&lt;&lt;"._INDIETRO."</a>";
		}
		else{
			$subj=stripslashes($subj);
			$mess=stripslashes($mess);
			$subj = tag2html($subj, "forum");
			$mess = tag2html($mess, "forum");

			$fp=file("users/$myforum.php");
			$firma=chop($fp[8]);
			$firma=str_replace("#","",$firma);
			if($firma!="")
				$mess.="<br /><br />---<br />$firma";
			if($mode=="nuovo"){
				/*$fp=fopen("topics/".time().".xml","w");
				// queste write non hanno bisogno di controlli
				// d'accesso concorrente in quanto
				// viene chiamata solo alla creazione del topic
				fwrite($fp,"<?xml version='1.0'?>
<!DOCTYPE ff:forum SYSTEM 'http://flatnuke.sourceforge.net/dtd/forum.dtd'>
<ff:forum xmlns:ff='http://flatnuke.sourceforge.net/forum'>
<ff:topic>$subj</ff:topic>
<ff:posts>
	<ff:post>
		<ff:poster>$myforum</ff:poster>
		<ff:subj>$subj</ff:subj>
		<ff:postbody>$mess</ff:postbody>
		<ff:postime>".time()."</ff:postime>
	</ff:post>
</ff:posts>
</ff:forum>");
				fclose($fp);*/
				$string_topic  = "<?xml version='1.0'?>\n";
				$string_topic .= "<!DOCTYPE ff:forum SYSTEM 'http://flatnuke.sourceforge.net/dtd/forum.dtd'>\n";
				$string_topic .= "<ff:forum xmlns:ff='http://flatnuke.sourceforge.net/forum'>\n";
				$string_topic .= "<ff:topic>$subj</ff:topic>\n";
				$string_topic .= "<ff:posts>\n";
				$string_topic .= "\t<ff:post>\n";
				$string_topic .= "\t\t<ff:poster>$myforum</ff:poster>\n";
				$string_topic .= "\t\t<ff:subj>$subj</ff:subj>\n";
				$string_topic .= "\t\t<ff:postbody>$mess</ff:postbody>\n";
				$string_topic .= "\t\t<ff:postime>".time()."</ff:postime>\n";
				$string_topic .= "\t</ff:post>\n";
				$string_topic .= "</ff:posts>\n";
				$string_topic .= "</ff:forum>";
				fnwrite("topics/".time().".xml", $string_topic, "w", array("nonull"));
				fnlog("Forum", getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT)."||".$myforum."||User $myforum created new topic.");
				print _FTOPOK."<br />
				<a href=\"index.php\">&lt;&lt;"._FLEGGI."</a>";
				// automatic redirect to the index after 1 seconds
				?><meta http-equiv="Refresh" content="1; URL=index.php"><?
			}
			elseif($mode=="ris"){
				if(!file_exists("topics/$quale".".xml")) {
					OpenTable();
					print("<div align='middle'><b>"._NORESULT."</b></div>");
					CloseTable();
					return;
				}
				$lockfile="topics/$quale.xml";
				// controllo accessi
				// sulla risposta invece
				// ci pu essere concorrenza
				$sem=lock($lockfile);
				$string=get_file($lockfile);
				$string=str_replace("</ff:posts>","\t<ff:post>
		<ff:poster>$myforum</ff:poster>
		<ff:subj>$subj</ff:subj>
		<ff:postbody>$mess</ff:postbody>
		<ff:postime>".time()."</ff:postime>
	</ff:post>
</ff:posts>",$string);
				/*$fp=fopen($lockfile,"w");
				fwrite($fp,$string);
				fclose($fp);*/
				fnwrite($lockfile, $string, "w", array("nonull"));
				fnlog("Forum", getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT)."||".$myforum."||Post added by user $myforum in $quale.xml topic.");
				unlock($sem);
				if(!file_exists("topics/$quale".".xml")) {
					OpenTable();
					print("<div align='middle'><b>"._NORESULT."</b></div>");
					CloseTable();
					return;
				}
				$fp=get_file("topics/$quale.xml");
				$items = explode("</ff:post>",$fp);
				$quanti=count($items)-1;
				$page=ceil($quanti / $postperpage);
				print _FMESSOK."<br /><a href=\"index.php?op=topic&amp;quale=$quale&amp;page=$page\">&lt;&lt;"._FLEGGI."</a>";
				// automatic redirect to the message after 2 seconds
				?><meta http-equiv="Refresh" content="1; URL=index.php?op=topic&quale=<?=$quale?>&page=<?=$page?>"><?
			}
		}
		?></td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table><?
	}
}

include "footer.php";
?>
