<?php
/**
 * Questo script deve le sue origini a FD di Detronizator - aka Ivan De Marino
 * Modifiche di Aldo Boccacci
 * e-mail: zorba_ (AT) tin.it
 * sito web: www.aldoboccacci.it
 * versione: 0.7
 *
 * (Da usare con Flatnuke >= 2.5.7)
 *
 * Il codice del metodo getIcon proviene quasi interamente dal progetto Autoindex
 *
 * This program is free software. You can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 */

//lo script non pu essere richiamato direttamente

if (eregi("fd+.php",$_SERVER['PHP_SELF'])) {
    Header("Location: ../index.php");
    fd_die("");
}
//verifico i dati in post
// if ((count($_POST)!=0) and (trim($_SERVER["HTTP_REFERER"])!="") and !(stristr($_SERVER["HTTP_REFERER"],$_SERVER["HTTP_HOST"]))) fd_die("Error! FD+: ".__LINE__."
// 	\$_SERVER[\"HTTP_HOST\"]= ".$_SERVER["HTTP_HOST"]."
// 	\$_SERVER[\"HTTP_REFERER\"]=".$_SERVER["HTTP_REFERER"]."
// 	\$_POST= ".count($_POST));

//CONFIGURAZIONE
/**
 * imposta le estenzioni riconosciute
 * NOTA: i files con estensioni divise da un punto come "tar.gz", vengono riconosciuti
 * solo grazie alla parte dopo l'ultimo punto.
 * Se vuoi che i files tar.gz vengano riconosciuti, dovrai inserire come estensione "gz"
 * Non lasciate spazi tra le estensioni
 */
$extensions = "gz,tgz,tar,rar,zip,bz2,7z,rpm,deb,tar,doc,dot,rtf,sxw,stw,sxi,csv,sxc,sxd,pot,xls,pdf,ps,gzip,html,htm,txt,jpeg,jpg,gif,png,tiff,bmp,odt,ott,odm,oth,ods,ots,odg,otg,odp,otp,odf,odb,sig,asc,java";

/**
 * La massima dimensione dei files da trasferire
 */
$maxFileSize = "2000000";

/**
 * Scegli lo stile delle icone da associare ai file.
 * I valori possibili sono: kde e redmond
 */
$icon_style = "kde";

/**
 * per quante ore devo considerare nuovo un file?
 * (192 ore = 1 settimana)
 */
$newfiletime = 192;

/**
 * se impostato a 1 calcola automaticamente la somma md5 se non viene
 * impostata dall'utente
 */
$automd5 = 0;

/**
 * se impostato a 1 calcola automaticamente la somma sha1 se non viene
 * impostata dall'utente
 */
$autosha1 = 1;

/**
 * Indica se mostrare o meno il nome dell'utente che ha caricato il file
 * 0 = non viene mostrato | 1 = viene mostrato
 */
$showuploader = "1";

/**
 * Indica l'estensione che devono avere le firme gpg dei file
 */
$extsig = "sig";

//FINE CONFIGURAZIONE
//NON MODIFICARE NULLA SOTTO QUESTA LINEA
//-----------------------------------------------------------------------------------------

//Il file che conterr l'elenco dei file pi scaricati
$max_download_file = "fd_top_download.php";

//Il nome della cartella di archivio
$archivedir = "none_archivedir";

//L'estensione dei file di descrizione
//questa variabile non  ancora usata
$desc_extension=".description";

//il file di log
$fdlogfile ="misc/log/fdpluslog.php";

//ci sono prolemi con register_globals=off
$GLOBALS['archivedir'] = $archivedir;
$GLOBALS['extensions'] = $extensions;
$GLOBALS['icon_style'] = $icon_style;
$GLOBALS['newfiletime'] = $newfiletime;
$GLOBALS['max_download_file'] = $max_download_file;
$GLOBALS['desc_extension'] = $desc_extension;
$GLOBALS['fdlogfile'] = $fdlogfile;
$GLOBALS['showuploader'] = $showuploader;
$GLOBALS['extsig'] = trim($extsig);

include_once("config.php");
include_once("functions.php");
include_once("shared.php");

//impostazione lingua
global $lang;
if (!isset($lang))$lang="it";
if (isset($_COOKIE['userlang'])){

	if (file_exists("languages/".str_replace(".php","",$_COOKIE['userlang']).".php")) $lang = str_replace(".php","",$_COOKIE['userlang']);
}

if ($lang=="en" or $lang=="es"){
    include_once ("languages/fd+lang/fd+en.php");
    include_once ("languages/$lang.php");
}
else if ($lang=="it"){
    include_once ("languages/fd+lang/fd+it.php");
    include_once ("languages/it.php");
}
else if ($lang=="de"){
    include_once ("languages/fd+lang/fd+de.php");
    include_once ("languages/de.php");
}
else if ($lang=="pt"){
    include_once ("languages/fd+lang/fd+pt.php");
    include_once ("languages/pt.php");
}
else {
    include_once ("languages/fd+lang/fd+en.php");
    include_once ("languages/$lang.php");
}
//fine impostazione lingua

	//A seconda dei parametri passati si intraprender l'azione opportuna
	//PARAMETRI GET
	if (isset($_GET['fdaction'])){
		if ($_GET['fdaction']=="confirmDelete"){
			if (isset($_GET['fdfile'])) $file = $_GET['fdfile'];
			else return;
			if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
			confermaElimina($file);
		}

		else if ($_GET['fdaction']=="delete"){
			if (isset($_GET['fdfile'])) $file = $_GET['fdfile'];
			else return;
			if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
			elimina($file);
		}

		else if ($_GET['fdaction']=="hide"){
			if (isset($_GET['fdfile'])) $file = $_GET['fdfile'];
			else return;
			if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
			if (eregi("^false$|^true$",trim($_GET['value']))) $value = trim($_GET['value']);
			else fd_die("<b>Value</b> must be true or false! FD+: ".__LINE__);

			hide_file($file,$value);

		}

		else if ($_GET['fdaction']=="archive"){
			if (isset($_GET['fdfile'])) $file = $_GET['fdfile'];
			else return;
			if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
			archivia($file,$archivedir);
		}

		else if ($_GET['fdaction']=="renameinterface"){
			if (isset($_GET['fdfile'])) $file = $_GET['fdfile'];
			else return;
			if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
			rename_interface($file);
		}

		else if ($_GET['fdaction']=="modify"){
			if (isset($_GET['fdfile'])) $file = $_GET['fdfile'];
			else return;
			if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
			modifica($file,$maxFileSize);
		}

		else if ($_GET['fdaction']=="save"){
			if (isset($_POST['showinblocks'])) $showinblocks= $_POST['showinblocks'];
			else $showinblocks="false";
			salva($maxFileSize,$_POST['filename'],$_POST['description'],$_POST['version'],$_POST['md5'],$_POST['sha1'],$extensions,$automd5,$autosha1,$showinblocks,$_POST['fdfilelevel']);
		}

		else if ($_GET['fdaction']=="addfile"){
			nuovoFile($maxFileSize);
		}

		else if ($_GET['fdaction']=="ripristina"){
			if (isset($_GET['fdfile'])) $file = $_GET['fdfile'];
			else return;
			if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
			ripristina($file,$archivedir);
		}

		else if ($_GET['fdaction']=="download"){
			if (isset($_GET['url'])) $url = $_GET['url'];
			else return;
			if (!fd_check_path($url,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
			track($url);
		}
		else if ($_GET['fdaction']=="moveinterface"){
			if (isset($_GET['fdfile'])) $fdfile = $_GET['fdfile'];
			else return;
			if (!fd_check_path($fdfile,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
			move_file_interface($fdfile);
		}
		else if ($_GET['fdaction']=="movefileconfirm"){
			if (isset($_GET['fdfile'])) $fdfile = $_GET['fdfile'];
			else return;
			if (isset($_GET['newdir'])) $newdir = $_GET['newdir'];
			else return;
			if (!fd_check_path($fdfile,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
// 			echo $newdir;
			if (!fd_check_path($newdir,"./sections/","false")) fd_die(_FDNONPUOI.__LINE__);

			move_file_confirm($fdfile,eregi_replace("^\./","",$newdir));
		}
		else fdlogf("\$_GET['fdaction'] value is invalid: ".strip_tags($_GET['fdaction'])." FD+: ".__LINE__);

	}

	//PARAMETRI POST
	if (isset($_POST['fdaction'])){
		if ($_POST['fdaction']=="createsectinterface"){
			mksection_interface();
		}
		else if ($_POST['fdaction']=="addfile"){
			nuovoFile($maxFileSize);
		}
		else if ($_POST['fdaction']=="createsect"){
			if (isset($_POST['fdmod'])) $fdmod = $_POST['fdmod'];
			else return;
			if (isset($_POST['fdnewsect'])) $fdnewsect = $_POST['fdnewsect'];
			else return;
			if (isset($_POST['fdsecthidden'])) $fdsecthidden = $_POST['fdsecthidden'];
			else $fdsecthidden="false";
// 			echo "hidden: $fdsecthidden e originale:".$_POST['fdsecthidden'];
			mksection($fdmod,$fdnewsect,$fdsecthidden);
		}
		else if ($_POST['fdaction']=="renamefile"){
			if (isset($_POST['oldfilename'])) $oldfinename = $_POST['oldfilename'];
			else return;
			if (isset($_POST['newfilename'])) $newfilename = $_POST['newfilename'];
			else return;
			if (isset($_POST['fdpath'])) $fdpath = $_POST['fdpath'];
			else return;
			rename_file($oldfinename,$newfilename,$fdpath);
		}
		else if ($_POST['fdaction']=="movefile"){
			if (isset($_POST['fdfile'])) $fdfile = $_POST['fdfile'];
			else return;
			if (isset($_POST['newdir'])) $newdir = eregi_replace("^\./","",$_POST['newdir']);
			else return;
			fd_move_file($fdfile,$newdir);
		}
		else if ($_POST['fdaction']=="upload"){
			if (isset($_POST['showinblocks'])){
				if (trim($_POST['showinblocks'])!="") $showinblocks =$_POST['showinblocks'];
				else $showinblocks="true";
			}
			else $showinblocks="false";
			upload($maxFileSize,$_POST['path'], $_POST['filename'], $_POST['description'], $_POST['version'],$_POST['md5'],$_POST['sha1'],$extensions,$automd5,$autosha1,$showinblocks,$_POST['fdfilelevel']);
		}

		//User upload
		else if ($_POST['fdaction']=="useraddfile"){
			include_once("fduser.php");
			user_addfile();
		}
		else if ($_POST['fdaction']=="userupload"){
			include_once("fduser.php");
			user_upload();
		}
		else if ($_POST['fdaction']=="publishuserfileinterface"){
			include_once("fduser.php");
			publish_interface();
		}
		else if ($_POST['fdaction']=="publishuserfile"){
			include_once("fduser.php");
			publish_file($_POST['fdfile']);
		}
		else if ($_POST['fdaction']=="deleteuserfile"){
			include_once("fduser.php");
			delete_file($_POST['fdfile']);
		}
		else fdlogf("\$_POST['fdaction'] value is invalid: \"".strip_tags($_POST['fdaction'])."\" FD+: ".__LINE__);
	}


/**
 * Il metodo base: mostra la sezione con tutti i download
 * @author Aldo Boccacci
 */
function fd_view_section(){
global $extensions,$icon_style,$archivedir,$newfiletime,$extsig;
	/* Costruisco il PATH della directory */

	$mod ="";
	if (!isset($_GET['mod'])) return;
	if (fd_check_path($_GET['mod'],"","false")) $mod=$_GET['mod'];
	else return;

	$path = "sections/$mod";

	if (!fd_check_path($path,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);

	//se c' bisogno rinomino la cartella di archivio
	rename_archivedir($archivedir);
	$extensions_array=array();
	$extensions_array = explode(",",$extensions);

	/* Per tutti i file*/
	foreach (glob($path."/*") as $filename) {
		//visualizzo ciascun file
		if (!eregi("\.php.$|\.php$",$filename)) {
			//se si tratta di una firma gpg ed esiste il file corrispondente
			//non devo visualizzare il file (sar integrato nel box del file corrispondente)
			if (!eregi("\.$extsig$",$filename) or !file_exists(eregi_replace("\.$extsig$","",$filename)))	{
				fd_view_file($filename);
			}
		}
	}

	//amministrazione della sezione
	echo "<br>";
	echo "<div align=center>";
	if (is_dir("sections/none_Statistiche/download_stats/")){
		echo "<a href=\"index.php?mod=none_Statistiche/download_stats\" title=\""._FDSTATTITLE."\">"._FDSTAT."</a>";
		echo "<br>";
	}


	if(is_admin()){
		//controllo se ci troviamo in una dir di archivio
		$lastdir = strrchr(dirname($filename),"/");
		if (!eregi($archivedir,$lastdir)){
			if (is_writable(dirname($filename))){
				//echo "<br><a href=\"index.php?mod=none_Fdplus&amp;fdaction=addfile&amp;fdfile=new&amp;path=$path\" title=\""._FDADDFILETITLE."\"><b>"._FDADDFILE."</b></a>";

				//pulsante per aggiungere un nuovo file
				echo "<br><form action=\"index.php?mod=none_Fdplus\" method=\"POST\">
				<input type=\"hidden\" name=\"path\" value=\"$path\" readonly=\"readonly\">
				<input type=\"hidden\" name=\"fdaction\" value=\"addfile\" readonly=\"readonly\">
				<input type=\"hidden\" name=\"fdfile\" value=\"new\" readonly=\"readonly\">
				<input type=\"SUBMIT\" value=\""._FDADDFILE."\"></form>";

				//pulsante per creare una nuova sezione
				echo "<form action=\"index.php?mod=none_Fdplus\" method=\"POST\">
				<input type=\"hidden\" name=\"fdmod\" value=\"".$_GET['mod']."\" readonly=\"readonly\">
				<input type=\"hidden\" name=\"fdaction\" value=\"createsectinterface\" readonly=\"readonly\">
				<input type=\"SUBMIT\" value=\""._FDCREATESECTDOWNLOAD."\"></form>";
			}
			else echo "<br><span style=\"color : #ff0000;\">"._FDREDONLYDIR."</span>";
		}
	}
	echo "</div><br>";

	module_copyright("FDplus",get_fd_version(),"<b>Aldo Boccacci</b> aka Zorba","zorba_(AT)tin.it", "http://www.aldoboccacci.it", "Gpl version 2.0");

	global $theme;
	if (file_exists("sections/$mod/$archivedir/section.php")){
		opentable();
		echo "<img src=\"themes/$theme/images/subsection.png\" alt=\"Subsection\">&nbsp;<a href=\"index.php?mod=".rawurlencodepath($mod."/".$archivedir)."\" title=\""._FDARCHIVEGO."\">"._FDARCHIVEDIR."</a>";
		closetable();
	}



}

/**
 * elimina il file da scaricare con il corrispettivo .description
 * @param string $file il file da eliminare
 * @author Aldo Boccacci
 */
function elimina($file){

	include_once("shared.php");
	if (!isset($_GET['mod'])) return;
	else if ($_GET['mod']!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);
	if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);

	if(is_admin()){
	if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!file_exists($file.".description")) fd_die("The file $file is not managed by FD+. FD+: ".__LINE__);
// 		/*include "config.php";*/ global $siteurl;

		if (unlink($file)&&unlink("$file.description")){
			echo _FDDELOK."<br><b>".$file."</b> ";
			//._FDAND."<br><b> ".$file.".description</b><br>";
			//l'utente che ha modificato il file
			$myforum="";
			if (isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
			if (!is_alphanumeric($myforum)) $myforum ="";
			if (!versecid($myforum)) $myforum = "";

			fdlogf("$file deleted by $myforum");

		}

		global $extsig;
		if ($extsig=="") $extsig="sig";
		if (file_exists($file.".$extsig")){
			if (unlink($file.".$extsig")){
				fdlogf("succesfully deleted gpg sign: $file.$extsig");
			}
			else echo "I was no able to delete the gpg sign: $file.$extsig";
		}

		//permetti di ritornare
		$path = eregi_replace("http://","",dirname($file));
		#$path = eregi_replace($siteurl, "", $path);
		$path = eregi_replace("/sections/", "", $path);
		$path = eregi_replace("sections/", "", $path);
		echo "<br><br><div align=\"center\"><a href=\"index.php?mod=".rawurlencodepath($path)."\"><b>"._FDRETURN."</b></a></div>";

	}
}


/**
 * Prima di eliminare definitivamente un file, chiedo conferma dell'operazione
 * @param string $file il file da eliminare
 * @author Aldo Boccacci
 */
function confermaElimina($file){
// 	include("shared.php");
	if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!file_exists($file.".description")) fd_die("The file $file is not managed by FD+. FD+: ".__LINE__);
	if (!isset($_GET['mod'])) return;
	else if ($_GET['mod']!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);
	if(!is_admin()) fd_die(_FDNONPUOI.__LINE__);

	?>
	<div align="center">
	<br><? echo _FDDELSURE; ?><b><? echo $file; ?></b>?
	<br><br>
	<a href="index.php?mod=none_Fdplus&amp;fdaction=delete&amp;fdfile=<? echo rawurlencodepath($file); ?>"><? echo _FDDEL; ?></a>
	<a href="javascript:history.back()"><? echo _FDCANC; ?></a>
	</div>
	<?
}

/**
 * Questa funzione consente di archiviare in una sottocartella un file messo in download.
 * Utile per tenere traccia delle vecchie versioni dei nostri file.
 * @param string $file il file da archiviare
 * @param string $archivedir la cartella di archivio
 * @author Aldo Boccacci
 */
function archivia($file,$archivedir){
// 	include_once("shared.php");
	if(!is_admin()) fd_die(_FDNONPUOI.__LINE__);
	if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!fd_check_path($archivedir,"","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!isset($_GET['mod'])) return;
	else if ($_GET['mod']!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);
	if(is_admin()){
// 		/*include "config.php";*/ global $siteurl;
		$path="";
		$path = dirname($file);
		if (!file_exists("$path/$archivedir/section.php")){

			mkdir("$path/$archivedir/",0777);
			$archive_section = fopen("$path/$archivedir/section.php","w");
			fputs($archive_section,"<?include_once(\"download/fd+.php\");\nfd_view_section()\n?>");
			fclose($archive_section);
		}
		$filename="";
		$filename = basename($file);
		rename($file,"$path/$archivedir/$filename");
		rename("$file.description","$path/$archivedir/$filename.description");

		global $extsig;
		if ($extsig=="") $extsig="sig";
		if (file_exists($file.".$extsig")){
			if (rename($file.".$extsig","$path/$archivedir/$filename.$extsig")){
				fdlogf("archived gpg sign: $file.$extsig");
			}
			else echo "I was not able to archive the gpg sign: $file.$extsig";
		}

		//l'utente che ha modificato il file
		$myforum="";
		if (isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
		if (!is_alphanumeric($myforum)) $myforum ="";
		if (!versecid($myforum)) $myforum = "";

		fdlogf("$file archived by $myforum");

	}
	$description=array();
	$description = load_description("$path/$archivedir/$filename");
	insert_in_max_download("$path/$archivedir/$filename",$description['hits']);
	echo "<br><br><div align=\"center\">"._FDARCHIVEOK."<br><br>";
			$path = eregi_replace("http://","",$path);
// 			$path = eregi_replace($siteurl, "", $path);
// 			$path = eregi_replace("/sections/", "", $path);
			$path = eregi_replace(".*sections/", "", $path);
			echo "<a href=\"index.php?mod=".rawurlencodepath($path)."\"><b>"._FDARCHIVERETURN."</b></a> | ";
			echo "<a href=\"index.php?mod=".rawurlencodepath("$path/$archivedir/")."\"><b>"._FDARCHIVEGO."</b></a></div>";
// 			echo "</div>";

}

/**
 * Riporta il file archiviato alla cartella di origine
 * @param string $file il file da ripristinare
 * @param string $archivedir il nome della cartella di archivio
 * @author Aldo Boccacci
 */
function ripristina($file,$archivedir){
	include_once("shared.php");
	if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!fd_check_path($archivedir,"","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!isset($_GET['mod'])) return;
	else if ($_GET['mod']!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);

	if(!is_admin()) fd_die(_FDNONPUOI.__LINE__);

	if(is_admin()){
// 	/*include "config.php";*/ global $siteurl;
		$filename="";
		$filename = basename($file);
		$path="";
		$path = dirname($file);

		if (eregi($archivedir,$path)){
			$path_up="";
			$path_up = substr($path,0,-16);
			rename($file,$path_up."/".$filename);
			rename("$file.description",$path_up."/".$filename.".description");

			//l'utente che ha modificato il file
			$myforum="";
			if (isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
			if (!is_alphanumeric($myforum)) $myforum ="";
			if (!versecid($myforum)) $myforum = "";

			fdlogf("$file restored by $myforum");
// 			echo "PATHUP: $path_up";
			global $extsig;
			if ($extsig=="") $extsig="sig";
			if (file_exists($file.".$extsig")){
				if (rename($file.".$extsig","$path_up/$filename.$extsig")){
					fdlogf("restored gpg sign: $file.$extsig");
				}
				else echo "I was not able to restore the gpg sign: $file.$extsig";
			}

			//avvisa e permetti di ritornare indietro
			echo "<br><br><div align=\"center\">"._FDRESTOREOK."<br><br>";
			$path = eregi_replace("http://","",$path_up);
// 			$path = eregi_replace($siteurl, "", $path);
// 			$path = eregi_replace("/sections/", "", $path);
			$path = eregi_replace(".*sections/", "", $path);
			echo "<a href=\"index.php?mod=".rawurlencodepath($path)."\"><b>"._GOTOSECTION."</b></a></div>";
			echo "</div>";
		}
		$tempdesc=array();
		$tempdesc = load_description($path_up."/".$filename);
		insert_in_max_download($path_up."/".$filename,$tempdesc['hits']);
	}
}

/**
 * Questo metodo consente di modificare i parametri memorizzati nel file .description
 * nonch di modificare il file messo in download.
 * Nel caso il nome del file sia diverso dal precedente lo script si occupa di aggiornare
 * i riferimenti al file .description
 * @param string $file il nomedel file da modificare
 * @param string $maxfilesize la dimensione massima del file
 * @author Aldo Boccacci
 */
function modifica($file,$maxFileSize){
	include_once("shared.php");
	if(!is_admin()) fd_die(_FDNONPUOI.__LINE__);
	if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!check_var($maxFileSize,"digit")) fd_die("\$maxFileSize (".strip_tags($maxFileSize).") must be a digit! FD+: ".__LINE__);
/* Apre il relativo file di descrizione "<$filename>.descrizione" */
	$description=array();
	$description = load_description($file);
	//aggiusto gli "a capo" (solo se non trovo fckeditor)
	if (!file_exists("FCKeditor/fckeditor.php")){
		if (eregi("gecko",$_SERVER['HTTP_USER_AGENT'])||eregi("msie",$_SERVER['HTTP_USER_AGENT'])){
			$description['desc'] =str_replace("<br>", "\n", $description['desc']);
		}
	}
	else if (!eregi("gecko",$_SERVER['HTTP_USER_AGENT']) and !eregi("msie",$_SERVER['HTTP_USER_AGENT'])){
		$description['desc'] =str_replace("<br>", "\n", $description['desc']);
	}

//crea interfaccia web
?>
<div align="center"><b><? echo _FDEDITDESC; ?><? echo $file; ?></b></div>
<br><br>
<? echo _FDEDITHEADER; ?> "<? echo "$file.description"; ?>"
<br><br>

<form enctype="multipart/form-data" action="index.php?mod=none_Fdplus&amp;fdaction=save" method="POST">
<!-- <input type="hidden" name="fdaction" value="save" readonly="true"> -->
<input type="hidden" name="fdfile" value="<? echo $file; ?>" readonly="readonly">
<div align="center">
<table width="70%">

  <tbody>
    <tr>
      <td  valign="top" align="right"><b><?echo _FDNAME ?></b></td>
      <td>  <input type="text" name="filename" value="<?=$description['name']?>" size="40"></td>
    </tr>
    <tr>
      <td valign="top" align="right"><b><? echo _FDDESC ?></b></td>
      <td>
      <?
      //codice per FCKEditor
      if (file_exists("FCKeditor/fckeditor.php")){
      	include("FCKeditor/fckeditor.php");
      	$oFCKeditor = new FCKeditor('description') ;
	$oFCKeditor->BasePath	= "FCKeditor/" ;
	$oFCKeditor->Value= $description['desc'];
	$oFCKeditor->Width="600";
	$oFCKeditor->ToolbarSet= "Default";
	$oFCKeditor->Create() ;
      }
      else echo "<textarea name=\"description\" rows=\"16\" cols=\"50\">".$description['desc']."</textarea>";
      ?>


    </tr>
    <tr>
      <td  valign="top" align="right"><b><? echo _FDVERSION ?></b></td>
      <td><input type="text" name="version" value="<?=$description['version']?>"></td>
    </tr>
    <tr>
      <td  valign="top" align="right"><br><b>md5</b></td>
      <td><br><input type="text" name="md5" value="<?=$description['md5']?>" size="32"></td>
    </tr>
    <tr>
      <td  valign="top" align="right"><b>sha1</b></td>
      <td><input type="text" name="sha1" value="<?=$description['sha1']?>" size="42"></td>
    </tr>
    <tr>
      <td  valign="top" align="right"><b><? echo _FDGPGSIGN; ?></b></td>
      <td><input name="fdsig" type="file">
      </td>
    </tr>
    <tr>
      <td  valign="top" align="right"><br><b><? echo _LEVEL; ?></b></td>
      <td><br><select name="fdfilelevel"><?
      echo "<option value=\"-1\">---</option>";
      $countlevel=0;
      for ($countlevel;$countlevel<11;$countlevel++){
      	if ($description['level']==$countlevel){
		echo "<option value=\"$countlevel\" selected >$countlevel</option>";
	}
	else echo "<option value=\"$countlevel\" >$countlevel</option>";
      }
      ?></select></td>
    </tr>
    <tr>
      <td  valign="top" align="right"><br><b>blocchi</b></td>
      <td><?
//       echo $description['showinblocks']; return;
      if ($description['showinblocks']=="true"){
	echo "<br><input type=\"checkbox\" name=\"showinblocks\" value=\"true\" checked>";
      }
      else echo "<br><input type=\"checkbox\" name=\"showinblocks\" value=\"true\">";

      echo "mostra il file nei blocchi di statistica";
      ?>

      </td>
    </tr>


  </tbody>
</table>
<br><div align="left"><? echo _FDEDITFOOTER; ?></div><br><br>
<input type="hidden" name="max_file_size" value="<?=$maxFileSize?>">
<input type="file" name="newfile">

<br><br><input type="SUBMIT" value="<? echo _FDEDITSAVE; ?>"></div>
</form>

<?
}

/**
 * Mette on-line il nuovo file selezionato
 * @param string $maxFileSize la dimensione massima del file da caricare
 * @param string $path il percorso in cui caricare il file
 * @param string $filename il nome del file
 * @param string $description la descrizione del file
 * @param string $version la versione del file
 * @param string $md5 la somma md5 del file
 * @param string $extensions l'elenco delle estensioni ricnonosciute
 * @param boolean $showinblocks true se il file deve essere mostrato nei blocchi
 * @author Aldo Boccacci
 */
function upload($maxFileSize, $path ,$filename, $description, $version, $md5, $sha1, $extensions, $automd5,$autosha1,$showinblocks,$filelevel){
	include_once("shared.php");
// 		echo "automd5: $automd5";
// 		die();
	//controllo tutte le variabili passate come parametro
	//$description, $filename e $version sono controllate in purge_string()
	if (!check_var($maxFileSize,"digit")) fd_die("\$maxFileSize must be a digit! FD+: ".__LINE__);
	if (!fd_check_path($path,"sections/","false")) fd_die("\$path is invalid! FD+: ".__LINE__);
	if (!fd_check_path($filename,"","false")) fd_die("\$filename is invalid! FD+: ".__LINE__);
	if (!check_var($md5,"alnum")) fd_die("\$md5 must be alphanumeric! FD+: ".__LINE__);
	if (!check_var($sha1,"alnum")) fd_die("\$sha1 must be alphanumeric! FD+: ".__LINE__);
	if (!check_var(trim($automd5),"boolean")) fd_die("\$automd5 must be 0 or 1! FD+: ".__LINE__);
	if (!check_var($autosha1,"boolean")) fd_die("\$autosha1 must be 0 or 1! FD+: ".__LINE__);
	if (!eregi("true|false",$showinblocks)) fd_die("\$showinblocks must be true or false! FD+: ".__LINE__);
	if (!check_var(trim($filelevel),"digit") and $filelevel!="-1") fd_die("\$filelevel must be a digit! FD+: ".__LINE__);

	if(!is_admin()) fd_die(_FDNONPUOI.__LINE__);

	//CONTROLLO TUTTE LE VARIABILI IN POST E FILES
	if (!isset($_GET['mod'])) return;
	else if ($_GET['mod']!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);

	if (!isset($_FILES['fdfile'])) {
		echo "<br><br><div align=\"center\"><b>"._FDFILENOTSELECT."</b></div>";
		fd_die("File to upload not selected. fd+:".__LINE__);
	}


	if (isset($_FILES['fdfile']['name']) and trim($_FILES['fdfile']['name'])==""){
		echo "<br><br><div align=\"center\">"._FDFILENOTSELECT;
		echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br></div>";
			fd_die("File to upload not selected. fd+:".__LINE__);
	}

	if ($_FILES['fdfile']['size']>$maxFileSize) {
		echo "<div align=\"center\"><br>"._FDTOOBIG;
		// Il file non  stato caricato perch le sue dimensioni sono eccessive.<br>";
		echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br>";
		echo "</div>";
		fdlogf($_FILES['fdfile']['size'].": "._FDTOOBIG);
		fd_die("File to upload has size==0. fd+:".__LINE__);

	}
	if ($_FILES['fdfile']['error']!=0){
		if ($_FILES['fdfile']['error']==1) echo _FDERROR1;
		else if ($_FILES['fdfile']['error']==2) echo _FDERROR2;
		else if ($_FILES['fdfile']['error']==3) echo _FDERROR3;
		else if ($_FILES['fdfile']['error']==4) echo _FDERROR4;
		else if ($_FILES['fdfile']['error']==6) echo _FDERROR6;
		else if ($_FILES['fdfile']['error']==7) echo _FDERROR7;

		fd_die("<br><br><b>FD+:</b> upload error.");


	}
	if ($_FILES['fdfile']['size']==0) fd_die("<br><b>Error! </b>"._FDSIZE." file: 0 kb");

	//ULTIMO CONTROLLO ALL'ARRAY $_FILES
// 	if (fd_check_uploaded_file($_FILES['fdfile'],$maxFileSize,"false")!=TRUE){
// 		fd_die("The \$_FILES array contains invalid data! FD+: ".__LINE__);
// 	}

// 	echo $_FILES['file']['size'];
	if (isset($_FILES['fdfile']['name'])){
		//impedisco di caricare file .php
		$info=array();
		$info = pathinfo($_FILES['fdfile']['name']);
		if (!isset($info['extension'])) $info['extension'] =" ";
		if (eregi("php",$info['extension'])) fd_die(_FDNONPUOI.__LINE__);

		//non posso inserire
		if (!fd_check_path($_FILES['fdfile']['name'],"","false")) fd_die(_FDNONPUOI.__LINE__);
		$extensions_array=array();
		$extensions_array = split(",",$extensions);
		if (!in_array($info['extension'],$extensions_array)) {
			echo "<br><br><div align=\"center\">"._NOTVALIDEXT;
			echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br></div>";
			fd_die();

		}

	}

	if (isset($_FILES['fdfile']['tmp_name'])){
		//impedisco di caricare file .php
		$info=array();
		$info = pathinfo($_FILES['fdfile']['tmp_name']);
		if (!isset($info['extension'])) $info['extension'] =" ";
		if (eregi("php",$info['extension'])) fd_die(_FDNONPUOI.__LINE__);

		//non posso inserire ..
// 		echo $_FILES['fdfile']['tmp_name'];
// 		if (fd_check_path($_FILES['fdfile']['tmp_name'],"","false")) fd_die(_FDNONPUOI.__LINE__);

	}
	if(is_admin()){

		if ($_FILES['fdfile']['name']<>""){
			//controllo che il file non sia gi esistente
			if (file_exists("$path/".$_FILES['fdfile']['name'])){
				echo "<div align=\"center\"><br>"._FDUPLOADEXISTS."<br>";
				echo "<br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br></div>";
				fd_die();

			}
			//inserisci il path
			if (is_admin()){
			if (move_uploaded_file($_FILES['fdfile']['tmp_name'], "$path/".$_FILES['fdfile']['name'])){
				echo "<div align=\"center\">"._FDUPLOADOK;
				//print_r($_FILES);
				echo "</div>";
			}
			else {
				echo "<div align=\"center\"><br>"._FDTOOBIG;
				// Il file non  stato caricato perch le sue dimensioni sono eccessive.<br>";
				echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br>";
				//print_r($_FILES);
				echo "</div>";
				fd_die();
			}
			}
		}
		if (trim($md5)=="" and $automd5==1){
			$md5 = md5_file("$path/".$_FILES['fdfile']['name']);
		}
		if (trim($sha1)=="" and $autosha1==1){
			$sha1 = sha1_file("$path/".$_FILES['fdfile']['name']);
		}

		if ($showinblocks!="true") $showinblocks="false";

		//l'utente che ha caricato il file
		$myforum="";
		if (isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
		if (!is_alphanumeric($myforum)) $myforum ="";
		if (!versecid($myforum)) $myforum = "";

		save_description("$path/".$_FILES['fdfile']['name'],$filename,trim($description),$version,$md5,$sha1,"","false",$showinblocks,$filelevel,$myforum);

		insert_in_max_download("$path/".$_FILES['fdfile']['name'],0);
		fdlogf("$path/".$_FILES['fdfile']['name']." uploaded by $myforum");

		//gestisco l'eventuale firma
		if ($_FILES['fdsig']['tmp_name']<>"") fd_upload_sig($path);

	}//fine is_admin(?)

		$path = eregi_replace("http://","",$path);
// 		$path = eregi_replace($siteurl, "", $path);
// 		$path = eregi_replace("/sections/", "", $path);
		$path = eregi_replace(".*sections/", "", $path);
		echo "<br><br><div align=\"center\"><a href=\"index.php?mod=".rawurlencodepath($path)."\"><b>"._FDARCHIVERETURN."</b></a></div>";
}

/**
 * Salva le modifiche apportate
 * @param string $maxFileSize la dimensione massima del file da caricare
 * @param string $filename il nome del file
 * @param string $description la descrizione del file
 * @param string $version la versione del file
 * @param string $md5 la somma md5 del file
 * @param string $sha1 la somma sha1 del file
 * @param string $extensions l'elenco delle estensioni ricnonosciute
 * @param string $automd5 se impostato a 1 calcola automaticamente la somma md5 del file
 * @param string $autosha1 se impostato a 1 calcola automaticamente la somma sha1 del file
 * @param string $showinblocks se impostato a true mostra il file nei blocchi di statistica
 * @param int $filelevel il livello del file (da -1 a 10)
 * @author Aldo Boccacci
 */
function salva($maxFileSize, $filename, $description, $version, $md5, $sha1, $extensions, $automd5, $autosha1,$showinblocks,$filelevel){
	include_once("shared.php");

	if (!check_var($maxFileSize,"digit")) fd_die("\$maxFileSize (".strip_tags($maxFileSize).") must be a digit! FD+: ".__LINE__);
	if (!check_var(trim($md5),"alnum")) fd_die("\$md5 must be alphanumeric! FD+: ".__LINE__);
	if (!check_var(trim($sha1),"alnum")) fd_die("\$sha1 must be alphanumeric! FD+: ".__LINE__);
	if (!check_var(trim($automd5),"boolean")) fd_die("\$automd5 must be 0 or 1! FD+: ".__LINE__);
	if (!check_var(trim($autosha1,"boolean"))) fd_die("\$autosha1 must be 0 or 1! FD+: ".__LINE__);
	if (!check_var(trim($showinblocks),"boolean")) fd_die("\$showinblocks must be true or false! FD+: ".__LINE__);
	if (!check_var(trim($filelevel),"digit") and $filelevel!="-1") fd_die("\$filelevel must be a digit! FD+: ".__LINE__);


	if (!isset($_GET['mod'])) return;
	else if ($_GET['mod']!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);
	if(!is_admin()) fd_die(_FDNONPUOI.__LINE__);

	if (isset($_FILES['newfile']['name']) and trim($_FILES['newfile']['name'])!=""){
		//impedisco di caricare file .php
		$info = pathinfo($_FILES['newfile']['name']);
		if (!isset($info['extension'])) {
			echo "<br><br><div align=\"center\">"._NOTVALIDEXT;
			echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br></div>";
			fd_die(_FDNONPUOI.__LINE__);
		}
		if (eregi("php",$info['extension'])) fd_die(_FDNONPUOI.__LINE__);

		//non posso inserire ..
		if (!fd_check_path($_FILES['newfile']['name'],"","false")) fd_die(_FDNONPUOI.__LINE__);
// 		if (stristr($_FILES['newfile']['name'],"%00")) fd_die(_FDNONPUOI.__LINE__);

		$extensions_array = split(",",$extensions);
		if (!in_array($info['extension'],$extensions_array)) {
			echo "<br><br><div align=\"center\">"._NOTVALIDEXT;
			echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br></div>";
			fd_die();

		}
	}

	if (isset($_FILES['newfile']['tmp_name']) and trim($_FILES['newfile']['tmp_name'])!=""){
		//impedisco di caricare file .php
		$info = pathinfo($_FILES['newfile']['tmp_name']);
		if (!isset($info['extension'])) $info['extension'] =" ";
		if (eregi("php",$info['extension'])) fd_die(_FDNONPUOI.__LINE__);

		//non posso inserire ..
		if (stristr($_FILES['newfile']['tmp_name'],"..")) fd_die(_FDNONPUOI.__LINE__);
		if (stristr($_FILES['newfile']['tmp_name'],"%00")) fd_die(_FDNONPUOI.__LINE__);

	}

	if (isset($_POST['fdfile'])){
 		if (stristr($_POST['fdfile'],"..")) fd_die(_FDNONPUOI.__LINE__);
 		if (stristr($_POST['fdfile'],"%00")) fd_die(_FDNONPUOI.__LINE__);

	}
	if(is_admin()){
		//controllo le dimensioni del file
		if ($_FILES['newfile']['size']>$maxFileSize){
			echo "<br><div align=\"center\">"._FDSAVESIZE.filesize($_FILES['newfile']['tmp_name'])."bit";
			echo "<br>"._FDTOOBIG;
			echo "<br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a></div>";
			fd_die();
		}

		if ($_FILES['newfile']['tmp_name']<>""){
			move_uploaded_file($_FILES['newfile']['tmp_name'], dirname($_POST['fdfile'])."/".$_FILES['newfile']['name']);
			if (basename($_POST['fdfile'])!=$_FILES['newfile']['name']){
				unlink($_POST['fdfile']);
				rename($_POST['fdfile'].".description",dirname($_POST['fdfile'])."/".$_FILES['newfile']['name'].".description");
				$filepathok ="";
				$filepathok = dirname($_POST['fdfile'])."/".$_FILES['newfile']['name'];
			}
			else {
				$filepathok = dirname($_POST['fdfile'])."/".$_FILES['newfile']['name'];
			}
			//se modifico il file allora devo aggiornare alche md5 e sha1
			if ($automd5==1){
				$md5 = md5_file($filepathok);
			}
			if ($autosha1==1){
				$sha1 = sha1_file($filepathok);
			}
			//se modifico il file devo eliminare anche la firma gpg
			global $extsig;
			if ($extsig=="") $extsig="sig";
			if (file_exists($_POST["fdfile"].".$extsig")){
				if (unlink($_POST["fdfile"].".$extsig")){
					fdlogf("Gpg sign deleted because the related file was changed: ".$_POST["fdfile"].".$extsig");
				}
				else "I was not able to delete the gpg sign: ".$_POST["fdfile"].".$extsig";
			}

			if ($_FILES['newfile']['error']!=0){
				if ($_FILES['newfile']['error']==1) echo _FDERROR1;
				else if ($_FILES['newfile']['error']==2) echo _FDERROR2;
				else if ($_FILES['newfile']['error']==3) echo _FDERROR3;
				else if ($_FILES['newfile']['error']==4) echo _FDERROR4;
				else if ($_FILES['newfile']['error']==6) echo _FDERROR6;
				else if ($_FILES['newfile']['error']==7) echo _FDERROR7;

				fd_die("<br><br><b>FD+:</b> errore nell'upload.");
			}

		}
		else $filepathok = $_POST['fdfile'];
		/*
		//x risolvere il problema degli spazi iniziali e finali quando si usa htmlarea
		$description = ltrim($description);
		$description = rtrim($description);
		$desc = "$filename||$description||$version";
		*/

		//se necessario calcolo md5 e sha1
		if ($md5 =="" and $automd5==1){
			$md5 = md5_file($filepathok);
		}
		if ($sha1 =="" and $autosha1==1){
			$sha1 = sha1_file($filepathok);
		}


		if ($showinblocks!="true") $showinblocks="false";

		//aggiusto gli "a capo": solo se non  attivo fckeditor
		if (!file_exists("FCKeditor/fckeditor.php")){
			$description =str_replace("\n", "<br>", $description);
		}
		else if (!eregi("gecko",$_SERVER['HTTP_USER_AGENT']) and !eregi("msie",$_SERVER['HTTP_USER_AGENT'])){
			$description =str_replace("\n", "<br>", $description);
		}

		$origdesc = load_description($filepathok);

		save_description($filepathok,
				$filename,
				trim($description),
				$version,$md5,$sha1,
				get_xml_element("fd:hits",get_file("$filepathok.description")),
				get_xml_element("fd:hide",get_file("$filepathok.description")),
				$showinblocks,
				$filelevel,
				$origdesc['uploadedby']);

		insert_in_max_download($filepathok,get_xml_element("fd:hits",get_file($filepathok.".description")));

		//l'utente che ha modificato il file
		$myforum="";
		if (isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
		if (!is_alphanumeric($myforum)) $myforum ="";
		if (!versecid($myforum)) $myforum = "";

		fdlogf("$filepathok edited by $myforum");

		if ($_FILES['fdsig']['tmp_name']<>""){
			fd_upload_sig(dirname($_POST['fdfile']),"edit");
		}
		else {
			//do nothing
		}

		//permetti di tornare indietro.
		echo "<br><br><div align=\"center\">"._FDEDITDONE."<br><br>";
		$path = dirname($_POST['fdfile']);
		#$path = eregi_replace("http://","",$path);
		#$path = eregi_replace($siteurl, "", $path);
// 		$path = eregi_replace("/sections/", "", $path);
		$path = eregi_replace(".*sections/", "", $path);
		echo "<a href=\"index.php?mod=".rawurlencodepath($path)."\"><b>"._FDRETURN."</b></a></div>";

	}
	else {
	//se non sono amministratore stampo:
	echo _FDNONPUOI.__LINE__;
	}
}


/**
 * Maschera per l'inserimento di un nuovo file
 * @param string $maxfilesize la dimensione massima del file da caricare
 * @author Aldo Boccacci
 */
function nuovoFile($maxFileSize){
include_once("shared.php");
if (isset($_POST['path'])) $path =$_POST['path'];
else fd_die(_FDNONPUOI.__LINE__);
if (!isset($_GET['mod'])) return;
else if ($_GET['mod']!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);
if (!check_var(trim($maxFileSize),"digit")) fd_die("\$maxFileSize (".strip_tags($maxFileSize).") must be a digit! FD+: ".__LINE__);

if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);
?>
<div align="center"><b><?echo _FDADDWHERE.$path ?></b></div>
<br><br>
<? echo _FDADDHEADER; ?>
<br><br>

<form enctype="multipart/form-data" action="index.php?mod=none_Fdplus" method="POST">
<input type="hidden" name="fdaction" value="upload" readonly="readonly">
<input type="hidden" name="path" value="<? echo $path; ?>" readonly="readonly">
<div align="center">
<table width="70%">

  <tbody>
    <tr>
      <td  valign="top" align="right"><b><? echo _FDNAME ?></b></td>
      <td>  <input type="text" name="filename" value="" size="40"></td>
    </tr>
    <tr>
      <td valign="top" align="right"><b><? echo _FDDESC ?></b></td>
      <td>
      <?
      //codice per FCKEditor
      if (file_exists("FCKeditor/fckeditor.php")){
      	include("FCKeditor/fckeditor.php");
      	$oFCKeditor = new FCKeditor('description') ;
	$oFCKeditor->BasePath	= "FCKeditor/" ;
	$oFCKeditor->Value= "";
	$oFCKeditor->Width="600";
	$oFCKeditor->ToolbarSet= "Default";
	$oFCKeditor->Create() ;
      }
      else echo "<textarea name=\"description\" rows=\"16\" cols=\"50\"></textarea>";
      ?>

      </td>
    </tr>
    <tr>
      <td  valign="top" align="right"><b><? echo _FDVERSION ?></b></td>
      <td><input type="text" name="version" value=""></td>
    </tr>
    <tr>
      <td  valign="top" align="right"><br><b>md5</b></td>
      <td><br><input type="text" name="md5" value="" size="32"></td>
    </tr>
    <tr>
      <td  valign="top" align="right"><b>sha1</b></td>
      <td><input type="text" name="sha1" value="" size="40"></td>
    </tr>
<!--     <tr> -->
    <tr>
      <td  valign="top" align="right"><b><? echo _FDGPGSIGN; ?></b></td>
      <td><input name="fdsig" type="file">
</td>
    </tr>
    <tr>
      <td  valign="top" align="right"><br><b><? echo _LEVEL; ?></b></td>
      <td><br><select name="fdfilelevel"><?
      echo "<option value=\"-1\">---</option>";
      $countlevel=0;
      for ($countlevel;$countlevel<11;$countlevel++){
	echo "<option value=\"$countlevel\" >$countlevel</option>";
      }
      ?></select></td>
    </tr>
    <tr>
      <td  valign="top" align="right"><b><br>blocchi</b></td>
      <td><?
	echo "<br><input type=\"checkbox\" name=\"showinblocks\" value=\"true\" checked>";
	echo "mostra il file nei blocchi di statistica";
      ?>

      </td>
    </tr>
  </tbody>
</table>
<br><div align="left"><? echo _FDADDFOOTER ?></div><br><br>
<input type="hidden" name="max_file_size" value="<?=$maxFileSize?>">
<input name="fdfile" type="file">

<br><br><input type="SUBMIT" value="UPLOAD" ></div>
</form>
<?
}
?>
<?

/**
 * Buona parte del codice presente in questo metodo (praticamente tutto)
 * proviene dal progetto autoindex
 * @param string $ext l'estensione del file di cui cercare l'icona
 * @param string $icon_style indica quale set di icone utilizzare
 */
function getIcon($ext,$icon_style) {
//find the appropriate icon depending on the extension (returns a link to the image file)
	if (!check_var(trim($ext),"alnum")) return;
	if (!check_var(trim($icon_style),"alnum")) return;
	if ($icon_style == '')
	{
		return '';
	}
	if ($ext == '')
	{
		$icon = 'generic';
	}
	else
	{
		$icon = 'unknown';
		static $icon_types = array(
		'binary' => array('bat', 'bin', 'com', 'exe', 'msi', 'msp', 'pif',
			'pyd', 'scr'),
		'binhex' => array('hqx'),
		'cd' => array('bwi', 'bws', 'bwt', 'ccd', 'cdi', 'cue', 'img',
			'iso', 'mdf', 'mds', 'nrg', 'nri', 'sub', 'vcd'),
		'comp' => array('cfg', 'conf', 'inf', 'ini', 'log', 'nfo', 'reg'),
		'compressed' => array('7z', 'a', 'ace', 'ain', 'alz', 'amg', 'arc',
			'ari', 'arj', 'bh', 'bz', 'bz2', 'cab', 'deb', 'dz', 'gz',
			'io', 'ish', 'lha', 'lzh', 'lzs', 'lzw', 'lzx', 'msx', 'pak',
			'rar', 'rpm', 'sar', 'sea', 'sit', 'taz', 'tbz', 'tbz2',
			'tgz', 'tz', 'tzb', 'uc2', 'xxe', 'yz', 'z', 'zip', 'zoo'),
		'dll' => array('386', 'db', 'dll', 'ocx', 'sdb', 'vxd'),
		'doc' => array('abw', 'ans', 'chm', 'cwk', 'dif', 'doc', 'dot',
			'mcw', 'msw', 'rtf', 'sdw', 'sxw', 'vor', 'wk4', 'wkb', 'wpd',
			'wps', 'wpw', 'wri', 'wsd', 'odt','ott'),
		'image' => array('adc', 'art', 'bmp', 'dib', 'gif', 'ico', 'jfif',
			'jif', 'jp2', 'jpc', 'jpe', 'jpeg', 'jpg', 'jpx', 'mng',
			'pcx', 'png', 'psd', 'psp', 'swc', 'sxd', 'tga', 'tif',
			'tiff', 'wmf', 'wpg', 'xcf', 'xif', 'yuv','odg','otg'),
		'java' => array('class', 'jar', 'jav', 'java', 'jtk'),
		'js' => array('ebs', 'js', 'jse', 'vbe', 'vbs', 'wsc', 'wsf',
			'wsh'),
		'key' => array('aex', 'asc', 'gpg', 'key', 'pgp', 'ppk'),
		'mov' => array('amc', 'dv', 'm4v', 'mac', 'mov', 'mp4v', 'mpg4',
			'pct', 'pic', 'pict', 'pnt', 'pntg', 'qpx', 'qt', 'qti',
			'qtif', 'qtl', 'qtp', 'qts', 'qtx'),
		'movie' => array('asf', 'asx', 'avi', 'div', 'divx', 'm1v', 'm2v',
			'mkv', 'mp2v', 'mpa', 'mpe', 'mpeg', 'mpg', 'mps', 'mpv',
			'mpv2', 'ogm', 'ram', 'rmvb', 'rnx', 'rp', 'rv', 'vivo',
			'vob', 'wmv', 'xvid'),
		'pdf' => array('edn', 'fdf', 'pdf', 'pdp', 'pdx'),
		'php' => array('inc', 'php', 'php3', 'php4', 'php5', 'phps',
			'phtml'),
		'ppt' => array('emf', 'pot', 'ppa', 'pps', 'ppt', 'shw', 'sxi','odp', 'otp'),
		'ps' => array('ps'),
		'sound' => array('aac', 'ac3', 'aif', 'aifc', 'aiff', 'ape', 'apl',
			'au', 'ay', 'bonk', 'cda', 'cdda', 'cpc', 'fla', 'flac',
			'gbs', 'gym', 'hes', 'iff', 'it', 'itz', 'kar', 'kss', 'la',
			'lpac', 'lqt', 'm4a', 'm4p', 'mdz', 'mid', 'midi', 'mka',
			'mo3', 'mod', 'mp+', 'mp1', 'mp2', 'mp3', 'mp4', 'mpc',
			'mpga', 'mpm', 'mpp', 'nsf', 'ofr', 'ogg', 'pac', 'pce',
			'pcm', 'psf', 'psf2', 'ra', 'rm', 'rmi', 'rmjb', 'rmm', 'sb',
			'shn', 'sid', 'snd', 'spc', 'spx', 'svx', 'tfm', 'tfmx',
			'voc', 'vox', 'vqf', 'wav', 'wave', 'wma', 'wv', 'wvx', 'xa',
			'xm', 'xmz'),
		'tar' => array('tar'),
		'text' => array('c', 'cc', 'cp', 'cpp', 'cxx', 'diff', 'h', 'hpp',
			'hxx', 'm3u', 'md5', 'patch', 'pls', 'py', 'sfv', 'sh',
			'txt'),
		'uu' => array('uu', 'uud', 'uue'),
		'web' => array('asa', 'asp', 'aspx', 'cfm', 'cgi', 'css', 'dhtml',
			'dtd', 'htc', 'htm', 'html', 'htt', 'htx', 'jsp', 'lnk',
			'mht', 'mhtml', 'perl', 'pl', 'plg', 'rss', 'shtm', 'shtml',
			'stm', 'swf', 'tpl', 'xht', 'xhtml', 'xml', 'xsl'),
		'xls' => array('csv', 'dbf', 'prn', 'sdc', 'sxc', 'xla', 'xlb',
			'xlc', 'xld', 'xlr', 'xls', 'xlt', 'xlw','ods','ots'));
		foreach ($icon_types as $png_name => $exts)
		{
			if (in_array($ext, $exts))
			{
				$icon = $png_name;
				break;
			}
		}
	}

	if (file_exists("images/mime/$icon_style/$icon.png")){
		return "<img alt=\"[$ext]\" height=\"16\" width=\"16\" src=\"images/mime/$icon_style/$icon.png\" /> ";
	}
	else return "";
}


/**
 * restituisce il numero di download del file
 * @param string $file il file di cui restituire il numero di download
 */
function getDownloads($file){
	if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);

	$string="";
	$string = get_file($file.".description");

	if (stristr($string,"<fd:hits>")){
		return get_xml_element("fd:hits",$string);
	}

	$url = ereg_replace("-", "", $file);
	$url = ereg_replace("_", "", $url);
	$url = ereg_replace("/", "", $url);
// 	$url = ereg_replace("\\", "", $url);
	$url = ereg_replace("%", "", $url);
	$url = ereg_replace(" ", "", $url);
	//$url = ereg_replace("?", "", $url);

	//se il file di tracking non esiste restituisco una stringa vuota
	if (!file_exists("misc/ftrack/".$url)){
		return "";
	}
	elseif (file_exists("misc/ftrack/".$url)){
		$trackfile = fopen("misc/ftrack/".$url,"r");
		$count = fgets($trackfile);
		return $count;

	}
}

/**
 * Restituisce true se l'utente  di livello 10
 * (e dunque possiede i privilegi di amministrazione)
 * @return TRUE se l'utente collegato  di livello 10, FALSE se non lo 
 * @author Aldo Boccacci
 */
/*function fd_is_admin(){
include_once("shared.php");
if (!isset($_COOKIE['myforum'])) return false;

if ((getlevel($_COOKIE['myforum'],"home"))=="10" and versecid($_COOKIE['myforum'])) {
	return true;
}

else return false;

}*/

function mksection_interface(){
	$fdmod="";
	if (isset($_POST['fdmod'])) $fdmod=$_POST['fdmod'];
	else fd_die(_FDNONPUOI.__LINE__);

// 	if (trim($fdmod)=="")fd_die(_FDNONPUOI.__LINE__);
	if (!fd_check_path($fdmod,"","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);
	echo "<h3>"._FDCREATESUBSECT."<b>$fdmod</b></h3><br>";

	echo _FDCHOOSESECTNAME."<br>";

	echo "<form action=\"index.php?mod=none_Fdplus\" method=\"POST\">
	<input type=\"hidden\" name=\"fdaction\" readonly=\"readonly\" value=\"createsect\">
	<input type=\"hidden\" name=\"fdmod\" readonly=\"readonly\" value=\"$fdmod\">
	<input type=\"text\" name=\"fdnewsect\" size=\"20\"><br><br>
	<input type=\"checkbox\" name=\"fdsecthidden\" value=\"true\">"._FDHIDDENSECT."<br><br><br>
	<input type=\"submit\" name=\"fdok\" value=\""._FDCREATESECT."\">
	</form>";

}

/**
 * Crea una sottosezione.
 * @param string il mod della sezione nella quale creare la sottosezione
 * @param string $dirname il nome della nuova sezione
 */
function mksection($mod, $dirname,$hidden="false"){
	if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);
	if (isset($_GET['mod'])) $currentmod=$_GET['mod'];
	else fd_die(_FDNONPUOI.__LINE__);
	if (!fd_check_path($currentmod,"","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!fd_check_path($dirname,"","false")) fd_die(_FDNONPUOI.__LINE__);
	if ($currentmod!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);
	if (!eregi("^false$|^true$",trim($hidden))) fd_die(_FDNONPUOI.__LINE__);

	$dirname = eregi_replace(" ","_",$dirname);
	$dirname = strtr($dirname,
  "???????",
  "SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy");

	if (is_admin()){
		if ($hidden=="true") $dirname="none_$dirname";
		if(mkdir("sections/$mod/".$dirname,0777)){
			echo "<div align=center><br><br>"._FDSECT." <b>sections/$mod/$dirname</b> "._FDCREATESECTOK."</div>";
			$subsection = fopen("sections/$mod/$dirname/section.php","w");
			if (fputs($subsection, "<?\ninclude_once(\"download/fd+.php\");\nfd_view_section();\n?>")){
				echo "<br><div align=\"center\"><a href=\"index.php?mod=".rawurlencodepath("$mod/$dirname")."\" title=\""._GOTOSECTION."\">"._GOTOSECTION."</a></div>";
				//l'utente che ha creato la sezione
				$myforum="";
				if (isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
				if (!is_alphanumeric($myforum)) $myforum ="";
				if (!versecid($myforum)) $myforum = "";
				fdlogf("section $mod/$dirname/ created by $myforum");
			}
			else echo _FDCREATEONLYDIR;
		}
		else echo "<div align=center><br><br>"._FDCREATEDIRERROR."<b>sections/$mod/$dirname</b><br><br>"._FDCHECKPERM."</div>";
	}
}


/**
 * Contatore dei download
 * @param string $url il percorso del file di cui effettuare il tracking
 * @since 0.6
 * @uthor Aldo Boccacci
 */
function track($url){

include_once("config.php");
include_once("shared.php");

//I files gestiti devono essere inseriti in sections/
//non posso salire
if (!fd_check_path($url,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);

//deve esistere anche il file .description
if (!file_exists($url.".description")) fd_die(_FDNONPUOI.__LINE__);


//il contatore
$track_count = 0;
$track_count = getDownloads($url);

if(is_admin()){

//in questo caso mostro unicamente il numero di visite della pagina senza
//incrementare il contatore.
//Questo per non falsare i risultati del numero di visite inserendo anche quelle dell'admin.

}

else {
//se l'utente non  loggato come admin incremento il contatore
$track_count++;

}

insert_in_max_download($url,$track_count);

//inserisco anche nel file di descrizione
// $descstring = get_file($url_orig.".description");
//SISTEMA!!!
if ($track_count=="") $track_count=0;
$description=array();
$description = load_description($url);
save_description($url, $description['name'], $description['desc'], $description['version'],$description['md5'],$description['sha1'], $track_count,$description['hide'],$description['showinblocks'],$description['level'],$description['uploadedby']);

//e finalmente scarico il file
$url_orig = ereg_replace("http://", "", $url_orig);
// global $siteurl;
//echo "$siteurl//$url_orig";
header("Location: $url");
}

/**
 * salva la descrizione nel file relativo.
 * @param string $file il nome del file nel qule salvare le modifiche
 * @param string $name il nome del file
 * @param string $desc la descrizione del file
 * @param string $version la versione del file
 * @param string $md5 md5 del file
 * @param string $sha1 sha1 del file
 * @param string $hits il numero di downloads
 * @param string $hide indica se nascondere il file ai visitatori
 * @param string $level il livello del file
 * @param boolean $showinblocks true se il file deve essere mostrato nei blocchi
 * @param string $uploadedby l'utente che ha uploadato il file
 * @since 0.6
 * @author Aldo Boccacci
 */
 function save_description($file,$name,$desc,$version,$md5,$sha1,$hits,$hide,$showinblocks,$level,$uploadedby){
	//controlli di sicurezza
	if (!fd_check_path($file,"sections/","false")) fd_die("\$file ".strip_tags($file)." is not valid! FD+: ".__LINE__);

	if (!file_exists($file)) fd_die(_FDNONPUOI.__LINE__);
	if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
	$string="<fd>
	<fd:name>".purge_string(strip_tags($name))."</fd:name>
	<fd:desc>".purge_string(purge_html_string($desc))."</fd:desc>
	<fd:version>".purge_string(trim(strip_tags($version)))."</fd:version>
	<fd:md5>".purge_string(trim(strip_tags($md5)))."</fd:md5>
	<fd:sha1>".purge_string(trim(strip_tags($sha1)))."</fd:sha1>
	<fd:hits>".purge_string(trim(strip_tags($hits)))."</fd:hits>
	<fd:hide>".purge_string(trim(strip_tags($hide)))."</fd:hide>
	<fd:showinblocks>".purge_string(trim(strip_tags($showinblocks)))."</fd:showinblocks>
	<fd:level>".purge_string(trim(strip_tags($level)))."</fd:level>
	<fd:uploadedby>".purge_string(trim(strip_tags($uploadedby)))."</fd:uploadedby>
</fd>";
	if (eregi("\<\?",$string) or eregi("\?\>",$string)) fd_die(_FDNONPUOI.__LINE__);
	$file = fopen("$file.description","w");
	fwrite($file,"<?xml version='1.0'?>\n".$string);
	fclose($file);
 }

/**
 * Carica la descrizione del file dal corrisptettivo .description
 * Lo script  in grado di riconoscere se il file contenente la descrizione
 *  nel vecchio formato con i separatori o nel nuovo formato xml.
 * @param string $file il file da cui daricare la descrizione
 * @return un array contenente la descrizione del file. La struttura dell'array :
 * array['name'] = il nome del file
 * array['desc'] = la descrizione
 * array['version'] = la versione
 * array['md5'] = la somma md5
 * array['sha1'] = la somma sha1
 * array['hits'] = il numero di download del file
 * array['hide'] = true se il file  nascosto, false se  visibile
 * array['showinblocks'] = true se il file deve essere mostrato nei blocchi di statistica, false in caso contrario
 * array['level'] = il livello del file: da -1 (visibile a tutti) a 10
 * @since 0.6
 * @author Aldo Boccacci
 */
function load_description($file){
	include_once("shared.php");
	if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!eregi("^sections",$file)) fd_die(_FDNONPUOI.__LINE__);
	$descriptions="";
	$descriptions = get_file($file.".description");
// echo $descriptions;
	$description=array();
	if (eregi("^<\?xml version=\'1.0\'\?\>",$descriptions)){
// 	echo "nuovo formato";
		$description['name'] = get_xml_element("fd:name",$descriptions);
		$description['desc'] = get_xml_element("fd:desc",$descriptions);
		$description['version'] = get_xml_element("fd:version",$descriptions);
		$description['md5'] = get_xml_element("fd:md5",$descriptions);
		$description['hits'] = str_replace("<br>","",get_xml_element("fd:hits",$descriptions));
		$description['hide'] = get_xml_element("fd:hide",$descriptions);
		//non  detto che sia presente il campo sha1
		if (eregi("\<fd:sha1\>.*\</fd:sha1\>",$descriptions)){
			$description['sha1'] = get_xml_element("fd:sha1",$descriptions);
		}
		else $description['sha1'] ="";
		//non  detto che sia presente il campo level
		if (eregi("\<fd:level\>.*\</fd:level\>",$descriptions)){
			$description['level'] = get_xml_element("fd:level",$descriptions);
		}
		else $description['level'] ="-1";
		//non  detto che sia presente il campo showinblocks
		if (eregi("\<fd:showinblocks\>.*\</fd:showinblocks\>",$descriptions)){
			if (eregi("false|true",get_xml_element("fd:showinblocks",$descriptions))){
				$description['showinblocks'] = get_xml_element("fd:showinblocks",$descriptions);
			}
			else $description['showinblocks'] ="true";
		}
		else $description['showinblocks'] ="true";
		//non  detto che sia presente il campo uploadedby
		if (eregi("\<fd:uploadedby\>.*\</fd:uploadedby\>",$descriptions)){
			$description['uploadedby'] = get_xml_element("fd:uploadedby",$descriptions);
		}
		else $description['uploadedby'] = "";

	}

	else {
// 	echo "vecchio formato";
		// nel vecchio formato
		$descriptionold = explode("||",$descriptions);
		$description['name'] = $descriptionold[0];
		$description['desc'] = $descriptionold[1];
		$description['version'] = $descriptionold[2];
		$description['md5'] = "";
		$description['sha1'] = "";
		$description['hits'] = "0";
		$description['hide'] = "false";
		$description['level'] = "-1";
		$description['showinblocks'] = "true";
		$description['uploadedby'] = "";

	}

	//Ora controllo tutto
	//...


	return $description;
}


/**
 * Purifica la stringa da inserire nel file .description
 * @param string $text il testo da controllare
 * @return la stringa purificata pronta da inserire nel file .description
 * @since 0.6
 * @author Aldo Boccacci
 */
function purge_string($text){

	//se la stringa  vuota ritorno subito
	if (trim($text)=="") return "";

	//controllo la lunghezza della stringa
	if (strlen($text)>6000){
		echo _FDDESCTOOLONG;
		echo "<br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a>";
		fd_die();
	}

// 	if (stristr($text,"<") or stristr($text,">")){
		//impedisco l'inserimento di combinazioni che possano creare collisioni con
		//la struttura del file xml
		$text = str_replace("<fd>","&#060;fd&#062;",$text);
		$text = str_replace("</fd>","&#060;/fd&#062;",$text);
		$text = str_replace("<fd:name>","&#060;fd:name&#062;",$text);
		$text = str_replace("</fd:name>","&#060;/fd:name&#062;",$text);
		$text = str_replace("<fd:desc>","&#060;fd:desc&#062;",$text);
		$text = str_replace("</fd:desc>","&#060;/fd:desc&#062;",$text);
		$text = str_replace("<fd:version>","&#060;fd:version&#062;",$text);
		$text = str_replace("</fd:version>","&#060;/fd:version&#062;",$text);
		$text = str_replace("<fd:md5>","&#060;fd:md5&#062;",$text);
		$text = str_replace("</fd:md5>","&#060;/fd:md5&#062;",$text);
		$text = str_replace("<fd:sha1>","&#060;fd:sha1&#062;",$text);
		$text = str_replace("</fd:sha1>","&#060;/fd:sha1&#062;",$text);
		$text = str_replace("<fd:hits>","&#060;fd:hits&#062;",$text);
		$text = str_replace("</fd:hits>","&#060;/fd:hits&#062;",$text);
		$text = str_replace("<fd:hide>","&#060;fd:hide&#062;",$text);
		$text = str_replace("</fd:hide>","&#060;/fd:hide&#062;",$text);
		$text = str_replace("<fd:level>","&#060;fd:level&#062;",$text);
		$text = str_replace("</fd:level>","&#060;/fd:level&#062;",$text);
		$text = str_replace("<fd:showinblocks>","&#060;fd:showinblocks&#062;",$text);
		$text = str_replace("</fd:showinblocks>","&#060;/fd:showinblocks&#062;",$text);
		$text = str_replace("<fd:uploadedby>","&#060;fd:uploadedby&#062;",$text);
		$text = str_replace("</fd:uploadedby>","&#060;/fd:uploadedby&#062;",$text);
		$text = str_replace("<script>","&#060;script&#062;",$text);
		$text = str_replace("</script>","&#060;/script&#062;",$text);
		$text = str_replace("<script","&#060;script",$text);
		$text = str_replace("(","&#040;",$text);
		$text = str_replace(")","&#041;",$text);
// 		$text = str_replace(";","&#059;",$text);
		$text = str_replace("$","&#036;",$text);
		$text = str_replace("%","&#037;",$text);
		$text = str_replace("+","&#043;",$text);
// 		$text = str_replace("/","&#047;",$text);
		//impedisco l'inserimento di codice php
		$text = str_replace("<?","&#060;&#063;",$text);
		$text = str_replace("?>", "&#063;&#062;", $text);

// 	}
	//imposto per andare a capo
	$text = str_replace("\n", "", $text);
	$text = str_replace("\r", "", $text);

	//ritorno la stringa purificata
	return stripslashes($text);
}

/**
 * Inserisce il percorso del file e il numero di download nel file contenente
 * le statistiche di download.
 * @param string $filepath il path del file da inserire nelle statistiche
 * @param int $hits in numero di download
 * @author Aldo Boccacci
 * @since 0.6
 */
function insert_in_max_download($filepath,$hits){
// 	include("shared.php");
	global $max_download_file;
	if (!fd_check_path($filepath,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
	if ($hits!= "" and !check_var(trim($hits),"digit")) fd_die(_NONPUOI.__LINE__);
	if (!fd_check_path($max_download_file,"","true")) fd_die(_FDNONPUOI.__LINE__);
	//se non esiste la cartella di archivio la creo
	if (!file_exists("misc/fdplus/")) mkdir("misc/fdplus/",0777);

	//idem per il file con le statistiche
	if (!file_exists("misc/fdplus/".$max_download_file)){
		$string= "<?xml version='1.0'?>\n<fd:topdownloads>\n</fd:topdownloads>";
		$file = fopen("misc/fdplus/".$max_download_file,"w");
		fwrite($file,$string);
		fclose($file);
	}

	//carico la vecchia stringa
	$oldstring="";
	$oldfile = fopen("misc/fdplus/$max_download_file","r");
	$oldstring = fread($oldfile,filesize("misc/fdplus/$max_download_file"));
	fclose($oldfile);

	$array=array();
	$array = get_xml_array("fd:file",$oldstring);
	$newstring = "<fd:topdownloads>";

	//per ciascun elemento contenuto nel file con le statistiche
	foreach ($array as $element){
		//creo un array avente per indice il path del file
		//e per valore il numero di downloads
		$index="";
		$value="";
		$index = get_xml_element("fd:path",$element);
		$value = get_xml_element("fd:hits",$element);
		$stats[$index] = $value;
	}

	//inserico il nuovo valore
	$stats[$filepath] = $hits;

	//effettuo il sorting dei dati
	if (count($stats)!=0){
		arsort($stats,SORT_NUMERIC);

		foreach ($stats as $element){
			$key = key($stats);
			next($stats);

		//controlla esistenza  dei file (alcuni potrebbero essere stati spostati)
		if (!file_exists($key)) continue;

		//normalizzo il percorso del file
		//rimuovo i doppi slash
		$key = str_replace("//","/",$key);
		$filepath = str_replace("//","/",$filepath);
		//rimuovo un eventuale slash iniziale
		$key = eregi_replace("^/","",$key);
		$filepath = eregi_replace("^/","",$filepath);

		//sembra che a volte sia presente un \n o un <br> (?)
		$hits = eregi_replace("\n","",$hits);
		$hits = eregi_replace("<br>","",$hits);

			if ($key == $filepath){

			$newstring .="\n\t<fd:file>
		<fd:path>$filepath</fd:path>
		<fd:hits>$hits</fd:hits>
	</fd:file>";
			}

			else {

				$newstring .="\n\t<fd:file>
		<fd:path>$key</fd:path>
		<fd:hits>$element</fd:hits>
	</fd:file>";

			}

		}
	}
	if (!stristr($newstring,$filepath)){
// 		echo "non  contenuta";
		$newstring .= "\n\t<fd:file>
		<fd:path>$filepath</fd:path>
		<fd:hits>$hits</fd:hits>
	</fd:file>";
	}

	//per sicurezza
	if (eregi("\<\?",$newstring) or eregi("\?\>",$newstring)) fd_die(_FDNONPUOI.__LINE__);

	$newstring ="<?xml version='1.0'?>\n".$newstring."\n</fd:topdownloads>";
// 	global $max_download_file;
	$file = fopen("misc/fdplus/$max_download_file","w");
	fwrite($file,$newstring);
	fclose($file);

}

/**
 * converte la cartella di archivio eventualmente presente con il vecchio nome
 * @param string $archivedir il nuovo nome della cartella di archivio
 * @author Aldo Boccacci
 * @since 0.6
 */
function rename_archivedir($archivedir){
	if (isset($_GET['mod'])) $mod =$_GET['mod'];
	else return;
	if (!fd_check_path($mod,"","false")) return;
	if (!fd_check_path($archivedir,"","false")) return;
	if (is_dir("sections/$mod/vecchie_versioni/") and (!file_exists("sections/$mod/$archivedir"))){
		rename("sections/$mod/vecchie_versioni","sections/$mod/$archivedir");
	}

}
/**
 * Imposta se nascondere o meno un file.
 * Il file viene nascosto se value  impostata a "true" e viene mostrato se  impostata
 * a "false".
 * @param string $filepath il percorso del file di cui mosificare le impostazioni
 * @param string $value indica se nascondere o meno un file
 * @author Aldo Boccacci
 * @since 0.6
 */
function hide_file($filepath,$value){
	include_once("shared.php");
	if (!fd_check_path($filepath,"sections/","false")) fd_die("\$filepath is not valid! FD+: ".__LINE__);
	if (!eregi("^false$|^true$",$value)) fd_die("\$value must be true or false! FD+: ".__LINE__);
	if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);
	if (is_admin()){
		$description=array();
		$description = load_description($filepath);
		save_description($filepath,$description['name'],$description['desc'],$description['version'],$description['md5'],$description['sha1'],$description['hits'],$value,$description['showinblocks'],"-1",$description['uploadedby']);
	}

	//l'utente che ha modificato il file
	$myforum="";
	if (isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
	if (!is_alphanumeric($myforum)) $myforum ="";
	if (!versecid($myforum)) $myforum = "";

	fdlogf("$filepath hide status set to \"$value\" by $myforum");

	//torna alla sezione
	$mod = dirname($filepath);
// 		echo $mod;
	$mod = eregi_replace("^.*sections/","",$mod);
// 	echo $mod;
	header("Location: index.php?mod=".rawurlencodepath($mod));
}

/**
 * Questa funzione crea e visualizza la tabella con le informazioni
 * per il file indicato come argomento
 * @param string $filename il file da mostrare
 * @since 0.7
 * @author Aldo Boccacci
 */
function fd_view_file($filename){

	if (!fd_check_path($filename,"sections/","")) {
		fdlogf("\$filename \"".strip_tags($filename)."\" is not valid! FD+: ".__LINE__);
		return;
	}
	global $extensions,$icon_style,$archivedir,$newfiletime,$extsig;
	if ($extsig=="") $extsig="sig";
	$extensions_array=array();
	$extensions_array = explode(",",$extensions);
//estraggo l'estensione
		$fileinfo = array();
		$fileinfo = pathinfo($filename);
		$ext ="";
		if (isset($fileinfo['extension'])) $ext = $fileinfo['extension'];
		else return;

		if (!in_array($ext,$extensions_array)){
			return;
		}

		//se  un file php ritorno
		if (eregi("php",$ext)) {
			return;
		}

		/* Calcola la grandezza del file */
		$size="";
		$size = round(filesize($filename)/1024)."Kb";
		/* Calcola la data di ultimo aggiornamento */
		$lastupdate="";
		$lastupdate = date(_FDDATEFORMAT, filemtime($filename) );

		/*
		 * Apre il relativo file di descrizione "<$filename>.descrizione"
		 * se non esiste lo creo io.
		 */
		if (!file_exists($filename.".description")){
			save_description($filename,"","","","","","","false","true","-1","");

		}

		//NUOVA FUNZIONE PER IL CARICAMENTO DELLA DESCRIZIONE
		$description=array();
		$description= load_description($filename);
		//solo gli amministratori possono vedere i file nascosti
		if ($description['hide']=="true" and !is_admin()) return;
		//controllo se il livello dell'utente  adeguato a quello del file
		if ($description['level']!="-1"){
			if (isset($_COOKIE['myforum']) and versecid($_COOKIE['myforum'])){
				if ($description['level']>getLevel($_COOKIE['myforum'],"home")){
					return;
				}
			}
			else return;

		}
		$newfilestring="";
		//Calcolo se inserire l'icona per il nuovo file
		if (file_exists("images/mime/new.gif")){
			if ((time()-filectime($filename))<$newfiletime*3600) {
				if (file_exists("images/mime/new.gif")){
// 					echo "dirname: ".strrchr($fileinfo['dirname'],"/");
					if (strrchr($fileinfo['dirname'],"/")!="/".$archivedir){
					$newfilestring = "&nbsp;<img src=\"images/mime/new.gif\" alt=\"new file!\">";
					}
				}
			}
		}

		else $newfilestring = "";

		$string_title="";
		/* Generazione Tabella */
		echo "<br><br>";
		if (ltrim($description['name'])==""){
			$string_title = "<a id=\"".basename($filename)."\" title=\"mime icon\">".getIcon($ext,$icon_style)."</a>".basename($filename);
			if ($description['hide']=="true") $string_title = "<span style=\"color : #ff0000; text-decoration : line-through;\">".$string_title."</span>";
			OpenTableTitle($string_title.$newfilestring);
		}

		else if (ltrim($description['name'])!=""){
			$string_title = "<a id=\"".basename($filename)."\">".getIcon($ext,$icon_style)."</a>".$description['name'];
			if ($description['hide']=="true") $string_title = "<span style=\"color : #ff0000; text-decoration : line-through;\">".$string_title."</span>";
			OpenTableTitle("$string_title".$newfilestring);
		}

		?>
		<p align="left">
		<table style="border-style : hidden;" width="100%" cellpadding="0" cellspacing="4" class="download">
			<tr>
				<td align="left" width="20%"><b><? echo _FDNAME;?></b></td>
				<td><?php

				//ora  possibile scaricare il file anche cliccando sul suo nome
				if (ltrim($description['name'])==""){
// 					echo basename($filename);
					echo "<b><u><a href=\"index.php?mod=none_Fdplus&amp;fdaction=download&amp;url=".rawurlencodepath($filename)."\" title=\""._FDDOWNLOADFILE.basename($filename)."\">".basename($filename)."</a></u></b>";
					//inserisco la chiave
					if (file_exists($filename.".$extsig")){
						echo " | (<b><a href=\"$filename.$extsig\" title=\""._FDGPGSIGNTITLE.basename($filename)."\">"._FDGPGSIGN."</a></b>)";
					}
				}

				else if (ltrim($description['name'])!=""){
// 					echo $description['name'];
					echo "<b><u><a href=\"index.php?mod=none_Fdplus&amp;fdaction=download&amp;url=$filename\" title=\""._FDDOWNLOADFILE.basename($filename)."\">".$description['name']."</a></u></b>";
					//inserisco la chiave
					if (file_exists($filename.".$extsig")){
						echo " | (<b><a href=\"$filename.$extsig\" title=\""._FDGPGSIGNTITLE."\">"._FDGPGSIGN."</a></b>)";
					}
					}
				?></td>
			</tr>
			<?
			global $showuploader;
			if ($showuploader =="1" or trim($description['uploadedby'])!=""){
				if (is_alphanumeric(trim($description['uploadedby']))){
					if (file_exists("forum/users/".trim($description['uploadedby']).".php")){
						echo "<tr><td align=\"left\" valign=\"top\"><b>"._FDUPLOADER."</b></td>
						<td><a href=\"forum/index.php?op=profile&amp;user=".$description['uploadedby']."\" title=\""._FDUPLOADERTITLE."\">".$description['uploadedby']."</a></td></tr>";
					}
					else {
						echo "<tr><td align=\"left\" valign=\"top\"><b>"._FDUPLOADER."</b></td>
						<td>".$description['uploadedby']."</td></tr>";
					}
				}
				else if (trim($description['uploadedby'])!=""){
					fdlogf("Uploader field is invalid (".$description['uploadedby'].")FD+: ".__LINE__);
				}

			}

			$desc = eregi_replace("<br>","",$description['desc']);
			$desc = eregi_replace("<br />","", $desc);
			if (ltrim($desc)!=""){
			echo "<tr><td align=\"left\" valign=\"top\"><b>"._FDDESC."</b></td>
				<td>".$description['desc']."</td>
			</tr>";
			}
			//se non  nullo mostro anche il campo "versione"
			if (trim($description['version'])!=""){
				echo "<tr><td align=\"left\"><b>"._FDVERSION."</b></td>";
				echo "<td>".$description['version']."</td></tr>";
			}

			//se non  nullo mostro anche il campo "md5"
			if (ltrim($description['md5'])!=""){
				echo "<tr><td align=\"left\"><b>md5</b></td>";
				echo "<td>".$description['md5']."</td></tr>";
			}

			//se non  nullo mostro anche il campo "md5"
			if (ltrim($description['sha1'])!=""){
				echo "<tr><td align=\"left\"><b>sha1</b></td>";
				echo "<td>".$description['sha1']."</td></tr>";
			}
			?>
			<tr>
				<td align="left"><b><?echo _FDSIZE; ?></b></td>
				<td><?php echo $size; ?></td>
			</tr>
			<tr>
				<td align="left" nowrap><b><? echo _FDDATE; ?></b></td>
				<td><? echo $lastupdate; ?></td>
			</tr>

			<?
			$track="";
			$track = getDownloads($filename);
			//se esiste un contatore
			if ($track!=""){
				?>
				<tr>
				<td align="left"><b><?echo _FDHITS; ?></b></td>
				<td><? echo $track; ?></td>
				</tr>

				<?
			}

			?>
			<tr>

			<?
// 				echo "<tr><td></td><td></td></tr>";
				echo "<th colspan=\"2\"><a href=\"index.php?mod=none_Fdplus&amp;fdaction=download&amp;url=".rawurlencodepath($filename)."\" title=\""._FDDOWNLOADFILE.basename($filename)."\">"._FDDOWNLOAD."</a></th>";
			?>

			</tr>
			<?
			//controlla se l'utente  admin
			if(is_admin()){
				file_admin_panel($filename);
			}
			?>
		</table>
		<?php
		CloseTableTitle();
}

/**
 * Crea una sezione che riepiloga tutti i file gestiti
 * da fd+ presenti nelle sottosezioni.
 * @since 0.7
 * @author Aldo Boccacci
 */
function fd_overview(){
global $archivedir;
	//controllo $mod
	$mod ="";
	if (isset($_GET['mod'])){
		$mod = $_GET['mod'];
		if (!fd_check_path($mod,"","false")) return;
	}
	else return;
	$myforum="";
	if (isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
	if (!is_alphanumeric($myforum)) $myforum ="";

	//elenco delle sottocartelle
	include_once("include/filesystem/DeepDir.php");
	$files = NULL;
	$files = new DeepDir();
	$files ->setDir("sections/$mod");
	$files ->load();
	if (!count($files->dirs)==0){

		foreach ($files->dirs as $dir){
			$descriptions=array();
			$descriptions = glob("$dir/*\.description");
	// 		htmlentities(print_r($descriptions));
			//se non ci sono file .description continuo
			if (count($descriptions)==0 and getlevel($myforum,"home")!=10) continue;
			//procedura arzigogolata per verificare se nella
			//sottosezione c' almeno un file non nascosto e con livello adeguato al mio
			$showdir = FALSE;

			//per evitare problemi con windows se non ci sono sottosezioni o file .description
			$descriptions[]="nonull";
			foreach ($descriptions as $tempdescription){
				if ($tempdescription=="nonull") continue;
				$tempdesc=array();
				$tempdesc = load_description(eregi_replace("\.description$","",$tempdescription));
				if ($tempdesc['hide']=="false") {
					if ($tempdesc['level']!="-1"){
						if (isset($_COOKIE['myforum']) and versecid($_COOKIE['myforum'])){
						if (getLevel($_COOKIE['myforum'],"home")>$tempdesc['level']){
						$showdir=TRUE;
						break;
						}
					}

					}//fine level
					else {
						$showdir=TRUE;
						break;
					}


				}//fine hide

			}
			if ($showdir ==FALSE and getLevel($myforum,"home")!=10) continue;
			//se  una cartella di archivio continuo
			if (basename($dir)==$archivedir) continue;


			//ora visualizzo le categorie e i files
			$category = "";
			$category = eregi_replace("sections\/$mod\/","",$dir);
			$catmod = "";
			$catmod = eregi_replace("sections\/","",$dir);


			//se la sottocartella ha un livello superiore al mio ritorno
			if (getLevel($myforum,"home") < getsectlevel($catmod)) continue;


			//elenco delle categorie
	// 		echo "<ul>\n";
			echo "\t<h2><a href=\"index.php?mod=".rawurlencodepath($catmod)."\" title=\""._GOTOSECTION.": $catmod\"><b>$category</b></a></h2>";
			//elenco dei file per ogni capegoria
			echo "\t<ul>\n";
			$description ="";
			foreach($descriptions as $description){
				if ($description=="nonull") continue;
				$filename="";
				$filename = eregi_replace("\.description$","",$description);
				$newfilestring="";
				//errore
				$fileinfo=array();
				$fileinfo = pathinfo($filename);
				//Calcolo se inserire l'icona per il nuovo file
				if (file_exists("images/mime/new.gif")){
					global $newfiletime;
					if ((time()-filectime($filename))<$newfiletime*3600) {
						if (file_exists("images/mime/new.gif")){
							if (strrchr($fileinfo['dirname'],"/")!="/".$archivedir){
							$newfilestring = "&nbsp;<img src=\"images/mime/new.gif\" alt=\"new file!\">";
							}
						}
					}
				}

				$desc = array();
				$desc = load_description($filename);

				if (getLevel($myforum,"home")!=10 and $desc['hide']=="true") continue;
				//controllo il livello
				if ($desc['level']!="-1"){
				if (isset($_COOKIE['myforum']) and versecid($_COOKIE['myforum'])){
					if (getLevel($_COOKIE['myforum'],"home")>$desc['level']){
					//ok
					}
					else continue;
				}
				else continue;

			}

				echo "\t\t<li>";
				echo "<a href=\"index.php?mod=".rawurlencodepath($catmod)."#".rawurlencode(basename($filename))."\" title=\""._FDDOWNLOADFILE.basename($filename)."\">";
				//se il file e' nascosto...
				if (getLevel($myforum,"home")==10 and $desc['hide']=="true") echo "<span style=\"color : #ff0000; text-decoration : line-through;\">";

				if (trim($desc['name'])!=""){
					echo trim($desc['name']);
				}
				else echo basename($filename);

				if (getLevel($myforum,"home")==10 and $desc['hide']=="true") echo "</span>";
				echo "</a> $newfilestring (";
				echo date(_FDDATEFORMAT, filemtime($filename))." | ";
				echo round(filesize($filename)/1024)."Kb | ";

				echo $desc['hits'];
				echo ")</li>\n";
			}
			//fine elenco file
			echo "\t</ul>\n";
			//fine elenco categoria
	// 		echo "</ul>\n";

		}
	}//fine if controllo files->dirs!=0

	if(is_admin()){
		if (is_writable("sections/$mod")){
			//pulsante per creare una nuova sezione
			echo "<div align=\"center\"><br><br><form action=\"index.php?mod=none_Fdplus&amp;\" method=\"POST\">
			<input type=\"hidden\" name=\"fdmod\" value=\"$mod\" readonly=\"readonly\">
			<input type=\"hidden\" name=\"fdaction\" value=\"createsectinterface\" readonly=\"readonly\">
			<input type=\"SUBMIT\" value=\""._FDCREATESECTDOWNLOAD."\"></form></div>";
		}
		else echo "<br><span style=\"color : #ff0000;\">"._FDREDONLYDIR."</span>";
	}

	module_copyright("FDplus",get_fd_version(),"<b>Aldo Boccacci</b> aka Zorba","zorba_(AT)tin.it", "http://www.aldoboccacci.it", "Gpl version 2.0");

}

/**
 * Restituisce il livello del file messo in download
 * @since 0.7
 * @author Aldo Boccacci
 * @return string il livello del file
 * @param string $filepath il percorso del file di cui restituire il livello
 */
function get_file_level($filepath){
if (!fd_check_path($filepath,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
$desc = load_description($filepath);
return $desc['level'];


}

/**
 * Controlla il percorso di file che gli viene passato come parametro.
 * @param string $filename il nome del file
 * @param string $dirbase il file deve essere all'interno di questa directory o di
 * una sua sottodirectory
 * @param string $allow_php se settato a "true" permette che il file abbia estensione .php e simili
 * @author Aldo Boccacci
 * @since 0.7
 */
function fd_check_path($filename,$dirbase,$allow_php){
// echo $filename;
	if (stristr($filename,"..")) return FALSE;
	if (stristr($filename,"%00")) return FALSE;
	if (stristr($filename,chr(13))) return FALSE;
	if (stristr($filename,chr(10))) return FALSE;
	if (stristr($filename,chr(00))) return FALSE;
	if (stristr($filename,"://")) return FALSE;
	if (stristr($filename,"?")) return FALSE;
	if (stristr($filename,"&")) return FALSE;
	if (stristr($filename,"$")) return FALSE;
	if (stristr($filename,"[")) return FALSE;
	if (stristr($filename,"]")) return FALSE;
	if (stristr($filename,"(")) return FALSE;
	if (stristr($filename,")")) return FALSE;
	if (stristr($filename,"<")) return FALSE;
	if (stristr($filename,">")) return FALSE;
// 	if (stristr($filename,"+")) return FALSE;
// 	if (stristr($filename,"\"")) return FALSE;


 if ($dirbase!=""){
  $dir = "";
  $path = $filename;
  $limit = 0;
  //controlla / iniziale
  while (eregi("^/",$path)){
   $path = eregi_replace("^/","",$path);
   if ($limit==5) return FALSE;
   $limit++;
  }
//   $path = eregi_replace("^\.","",$path);
  if (!eregi("^$dirbase",$path)) return FALSE;
  if (eregi("^forum",$path)) return FALSE;
 }

 if ($allow_php!="true"){
//  echo "controllo php";
  if (eregi("\.php.$|\.php$",$filename)) return FALSE;
 }

 return TRUE;
}

/**
 * Questa funzione crea l'interfaccia grafica per rinominare un file gestito da fd+
 * @param string $file il file da rinominare
 * @since 0.7
 * @author Aldo Boccacci
 */
function rename_interface($file){
if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);
if (!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
if (!isset($_GET['mod'])) return;
else if ($_GET['mod']!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);

echo _FDRENAMETITLE."<b>$file</b><br><br>";

echo _FDRENAMECHOOSE."<br>";
echo "<form action=\"index.php?mod=none_Fdplus\" method=\"POST\">
<input type=\"hidden\" name=\"fdaction\" readonly=\"readonly\" value=\"renamefile\">
<input type=\"hidden\" name=\"fdpath\" readonly=\"readonly\" value=\"".dirname($file)."\">
<input type=\"hidden\" name=\"oldfilename\" readonly=\"readonly\" value=\"".basename($file)."\">
<input type=\"text\" name=\"newfilename\" size=\"35\" value=\"".basename($file)."\"><br><br>
<input type=\"submit\" name=\"fdok\" value=\""._FDRENAME." file\">";

echo "</form>";

echo _FDRENAMEEXTLIMIT;

}

/**
 * Rinomina un file gestito da fd+
 * @param string $oldname il vecchio nome del file
 * @param string $newname il nuovo nome del file
 * @param string $path il percorso del file
 * @since 0.7
 * @author Aldo Boccacci
 */
function rename_file($oldname, $newname, $path){
if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);
if (!fd_check_path($oldname,"","false")) fd_die(_FDNONPUOI.__LINE__);
if (!fd_check_path($newname,"","false")) fd_die(_FDNONPUOI.__LINE__);
if (!fd_check_path($path,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
if (!isset($_GET['mod'])) return;
else if ($_GET['mod']!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);
// echo "$path/$oldname.description";
//controllo la presenza del corrispondente file .description
if (!file_exists("$path/$oldname.description")){
	echo _FDRENAMEFILE."<b>$path/$oldname</b>"._FDRENAMENOFD;
	fd_die(_FDNONPUOI.__LINE__);
}
$basemod = "";
$basemod = eregi_replace("^sections/","",$path);
//se il nome non cambia...
if ($oldname==$newname) {
	echo _FDRENAMENOTCHANGED;
	echo "<br><br><a href=\"index.php?mod=".rawurlencodepath($basemod)."\">"._FDARCHIVERETURN."</a>";
	return;
}

//se la cartella non  scrivibile...
if (!is_writable($path)){
	echo _FDREDONLYDIR;
	echo "<br><br><a href=\"index.php?mod=".rawurlencodepath($basemod)."\">"._FDARCHIVERETURN."</a>";
	return;
}
//se esiste gi un file con quel nome...
if (file_exists("$path/$newname")){
	echo _FDRENAMEEXISTS1." <b>$newname</b> "._FDRENAMEEXISTS2." <b>$path</b>.<br>"._FDRENAMECHANGENAME;
	echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a>";
	return;
}

//non posso cambiare l'estensione
$oldinfo = array();
$newinfo = array();
$oldinfo = pathinfo($oldname);
$newinfo = pathinfo($newname);
if (isset($oldinfo['extension'])) $oldext = $oldinfo['extension'];
else $oldext="";
if (isset($newinfo['extension'])) $newext = $newinfo['extension'];
else $newext="";

if ($oldext !=$newext){
	echo _FDERROR." "._FDRENAMEEXTLIMIT;
	echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a>";
	return;
}

//se tutti i controlli vengono passati posso rinominare il file
if (rename("$path/$oldname","$path/$newname") and rename("$path/$oldname.description","$path/$newname.description")){
	echo _FDRENAMEOK;
	echo "<br><br><a href=\"index.php?mod=".rawurlencodepath($basemod)."\">"._FDARCHIVERETURN."</a>";
	//l'utente che ha modificato il file
	$myforum="";
	if (isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
	if (!is_alphanumeric($myforum)) $myforum ="";
	if (!versecid($myforum)) $myforum = "";

	fdlogf("$path/$oldname \n\trenamed in $path/$newname by $myforum");
}

else {
	echo _FDRENAMEALERT."<b> $oldname</b>";
	return;
}

//inserisco in max_download
$desc=array();
$desc= load_description("$path/$newname");
insert_in_max_download("$path/$newname",$desc['hits']);

//firma gpg
global $extsig;
if ($extsig=="") $extsig="sig";
if (file_exists("$path/$oldname.$extsig")){
	if (rename("$path/$oldname.$extsig","$path/$newname.$extsig")){
		fdlogf("Gpg sign file succesfully renamed: $path/$newname.$extsig");
	}
	else {
		echo "I was not able to rename the gpg sign file $path/$oldname.$extsig in $path/$newname.$extsig";
		fdlogf("I was not able to rename the gpg sign file $path/$oldname.$extsig in $path/$newname.$extsig");
	}

}

}
/**
 *
 * @return TRUE se l'utente ha i permessi per vedere il file specificato, FALSE se
 * non li ha
 * @since 0.7
 * @author Aldo Boccacci
 */
/*
function user_can_view_file($file){
	if (!fc_check_path($file)) return FALSE;
}
*/

/**
 * Questa funzione serve per salvare il log di fd+.
 * Il messaggio viene formattato aggiungendo campi di interesse
 * @param string $message il messaggio da salvare
 * @author Aldo Boccacci
 * @since 0.7
 */
function fdlogf($message) {
	global $fdlogfile;

	if (!isset($fdlogfile)) $fdlogfile="misc/log/fdpluslog.php";

	if (eregi("\<\?",$message) or eregi("\?\>",$message)) fd_die(_FDNONPUOI.__LINE__);

	if (!is_dir("misc/log/")){
		mkdir("misc/log","0777");

	}

	if (!file_exists("$fdlogfile")){
		$fl = NULL;
		$fl=fopen("$fdlogfile","a");
		fwrite($fl, "<?exit(1);?>\n");
		fclose($fl);
	}
	else {
		$logtext="";
		$logtext = get_file($fdlogfile);
		if (!eregi("\<\?exit\(1\);\?\>",$logtext)){
// 		echo "no codice controllo";
			$flogtemp = fopen($fdlogfile,"w");
			fwrite($flogtemp,"<?exit(1);?>\n$logtext");
			fclose($flogtemp);
		}
	}


	//l'utente collegato
	$myforum="";
	if (isset($_COOKIE['myforum'])) $myforum = $_COOKIE['myforum'];
// 	if (!is_alphanumeric($myforum)) $myforum ="";
	if (!versecid($myforum)) $myforum .= "(NOT VALID!)";
	$REMOTE_ADDR="";
	if (isset($_SERVER['REMOTE_ADDR'])) $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
	else $REMOTE_ADDR="";
	if (isset($_GET['mod'])) $mod=$_GET['mod'];
	else $mod="";

// 	if (!is_alphanumeric($myforum)) die(_NONPUOI." FD+: ".__LINE__);
// 	if (!fd_check_path($mod,"","false")) die(_NONPUOI." FD+: ".__LINE__);
// 	if (!eregi("^[0-9\.]+$",$REMOTE_ADDR)) die(_NONPUOI." FD+: ".__LINE__);


	$messageok = date(_FDDATEFORMAT)."
	fd version: ".get_fd_version()."
	user: $myforum
	remoteaddr: $REMOTE_ADDR
	section: $mod
	message: $message";

	$fl=fopen("$fdlogfile","a");
	fwrite($fl, strip_tags("$messageok\n"));
	fclose($fl);

}

/**
 * Questa funzione serve per salvare il log di fd+
 * @param string $message il messaggio da salvare
 * @author Aldo Boccacci
 * @since 0.7
 */
function fdlog($message) {
	global $fdlogfile;

	if (eregi("\<\?",$message) or eregi("\?\>",$message)) fd_die(_FDNONPUOI.__LINE__);
// 	echo "fdlogfile: $fdlogfile";

	if (!is_dir("misc/log/")){
		mkdir("misc/log","0777");

	}

	if (!file_exists("$fdlogfile")){
		$fl = NULL;
		$fl=fopen("$fdlogfile","a");
		fwrite($fl, "<?exit(1);?>\n");
		fclose($fl);
	}
	else {
		$logtext="";
		$logtext = get_file($fdlogfile);
		if (!eregi("\<\?exit\(1\);\?\>",$logtext)){
// 		echo "no codice controllo";
			$flogtemp = fopen($fdlogfile,"w");
			fwrite($flogtemp,"<?exit(1);?>\n".strip_tags($logtext));
			fclose($flogtemp);
		}
	}

	if (isset($_COOKIE['myforum'])) $myforum=$_COOKIE['myforum'];
	else $myforum="";
	if (isset($_SERVER['REMOTE_ADDR'])) $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
	else $REMOTE_ADDR="";
	if (isset($_GET['mod'])) $mod=$_GET['mod'];
	else $mod="";

	if (!is_alphanumeric($myforum)) die(_NONPUOI.__LINE__);
	if (!fd_check_path($mod,"","false")) die(_NONPUOI.__LINE__);
	if (!eregi("^[0-9\.]+$",$REMOTE_ADDR)) die(_NONPUOI.__LINE__);


	$fl=fopen("$fdlogfile","a");
	fwrite($fl, strip_tags(date(_FDDATEFORMAT)."\n\t$message\n"));
	fclose($fl);

}

/**
 * Funzione di die() personalizzata per fd+ che prima di uccidere il processo
 * salva un messaggio nel log
 * @param string $message il messaggio da stampare a schermo e da salvare nel log
 * @author Aldo Boccacci
 * @since 0.7
 */
function fd_die($message=""){
	fdlogf($message);
	die($message);
}


/**
 * Interfaccia grafica per permettere lo spostamento dei file gestiti da fd+
 * @param string $file il file da spostare
 * @author Aldo Boccacci
 * @since 0.7
 */
function move_file_interface($file){
	if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);
	if(!fd_check_path($file,"sections/","false")) die(_FDNONPUOI.__line__);
	if (!isset($_GET['mod'])) return;
	else if ($_GET['mod']!="none_Fdplus") fd_die(_FDNONPUOI.__LINE__);

	$startdir ="";
	$startdir = dirname($file);

	echo "<br>"._FDMOVEFILE."<b>$file</b>"._FDMOVEFILESECTION.":<br><i>"._FDMOVELINK."</i><br><br>";
	$dirs = list_fd_sections(".");
	foreach($dirs as $dir){
// 	echo "$startdir<br>$dir<br><rb>";
		if ($startdir==eregi_replace("^\./","",$dir)) continue;
		if (is_writable($dir)) echo "<a href=\"index.php?mod=none_Fdplus&amp;fdaction=movefileconfirm&amp;fdfile=".rawurlencodepath($file)."&amp;newdir=".rawurlencodepath($dir)."\">".eregi_replace("^\./","",$dir)."</a><br>";
		else {
			echo "<span style=\"color : #ff0000; text-decoration : line-through;\">".eregi_replace("^\./","",$dir)."</span><br>";
		}
	}

	echo "<br><hr><a href=\"javascript:history.back()\">&lt;&lt; "._FDCANC."</a>";

}

/**
 * Chiede conferma prima di spostare effettivamente il file
 * @param string $file il file da spotare
 * @param string $newdir la cartella in cui spostare il file
 * @author Aldo Boccacci
 * @since 0.7
 */
function move_file_confirm($file, $newdir){
	if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);
	if(!fd_check_path($file,"sections/","false")) fd_die(_FDNONPUOI.__line__);
	if(!fd_check_path($newdir,"sections/","false")) fd_die(_FDNONPUOI.__line__);

	if (!file_exists($file.".description")) fd_die(_FDRENAMEFILE." $file"._FDRENAMENOFD." FD+: ".__LINE__);

	echo "<br>"._FDMOVECONFIRM." <b>$file</b> <br>"._FDMOVEFILESECTION." <b>$newdir</b>?<br>";

	echo "<br><br><form action=\"index.php?mod=none_Fdplus\" method=\"POST\">
<input type=\"hidden\" name=\"fdfile\" value=\"$file\" readonly=\"readonly\">
<input type=\"hidden\" name=\"fdaction\" value=\"movefile\" readonly=\"readonly\">
<input type=\"hidden\" name=\"newdir\" value=\"$newdir\" readonly=\"readonly\">
<input type=\"SUBMIT\" value=\""._FDMOVE."\"></form>";

	echo "<br><hr><a href=\"javascript:history.back()\">&lt;&lt; "._FDCANC."</a>";

}

/**
 * Sposta il file $file nella cartella $newdir
 * @param string $file il file da spotare
 * @param string $newdir la cartella in cui spostare il file
 * @author Aldo Boccacci
 * @since 0.7
 */
function fd_move_file($file, $newdir){
	if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);
	if(!fd_check_path($file,"sections/","false")) die(_FDNONPUOI.__line__);
	if(!fd_check_path($newdir,"sections/","false")) die(_FDNONPUOI.__line__);

	//il file deve essere gestito da fd+!
	if (!file_exists($file.".description")) fd_die(_FDRENAMEFILE." $file"._FDRENAMENOFD." FD+: ".__LINE__);

	$newdir = eregi_replace("^\./","",$newdir);

	if (!is_writable($newdir)) {
		echo _FDDIR." <b>$newdir</b> "._FDNOTWRITE;
		echo "<br>"._FDCHECKPERM;
		echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a>";
		return;
	}

	if (!is_fd_sect($newdir)){
		echo "The dir $newdir is not managed by FD+.";
		echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a>";
		return;
	}

	if (file_exists($newdir."/".basename($file))){
		echo _FDRENAMEEXISTS1." <b>".basename($file)."</b> "._FDRENAMEEXISTS2." <b>$newdir</b>";
		echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br>";
		return;

	}
	if (file_exists($newdir."/".basename($file).".description")){
		echo _FDRENAMEEXISTS1." <b>".basename($file).".description</b> "._FDRENAMEEXISTS2." <b>$newdir</b>";
		echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br>";
		return;
	}

	global $extsig;
	if ($extsig=="") $extsig="sig";
	if (file_exists($newdir."/".basename($file).".$extsig")){
		echo _FDRENAMEEXISTS1." <b>".basename($file).".$extsig</b> "._FDRENAMEEXISTS2." <b>$newdir</b>";
		echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br>";
		return;
	}

	if (rename($file,$newdir."/".basename($file)) and rename($file.".description",$newdir."/".basename($file).".description")){
		echo "File <b>$file</b> "._FDMOVESUCCESS." <b>$newdir</b>";
	}
	else {
		echo _FDMOVEFAIL."<b>$file</b>";
	}

	if (file_exists($file.".$extsig")){
		if (rename($file.".$extsig",$newdir."/".basename($file).".$extsig")){
			//ok
		}
		else {
			echo "Attention: I cannot move the gpg sign of the file!";
			fdlogf("I cannot move the gpg sign of the file: $file to the dir: $newdir");
		}
	}

	//inserisco in $max_download
	$desc = array();
	$desc = load_description($newdir."/".basename($file));
	insert_in_max_download($newdir."/".basename($file),$desc['hits']);

	$olddir = eregi_replace("sections/","",dirname($file));
	echo "<br><br><div align=\"center\"><a href=\"index.php?mod=".rawurlencodepath($olddir)."\"><b>"._FDARCHIVERETURN."</b></a> | ";

	$newdir = eregi_replace("sections/","",$newdir);
	echo "<a href=\"index.php?mod=".rawurlencodepath($newdir)."\" title=\""._GOTOSECTION."\"><b>"._GOTOSECTION." $newdir</b></a></div>";
}


/**
 * Restituisce un array con l'elenco delle sezioni gestite dal metodo fd_view_section
 * @param string $basedir la dir da cui effettuare le ricerche
 * @param string $list_archivedir se settato a true include nei risultati anche le dir di archivio
 * @return un array contenente i percorsi delle sezioni gestite dal metodo fd_view_section
 * @author Aldo Boccacci
 * @since 0.7
 */
function list_fd_sections($basedir,$list_archivedirs=FALSE){
	if(!fd_check_path($basedir,"","false")) fd_die(_FDNONPUOI.__line__);
	if (eregi("^FALSE$|^TRUE$",$list_archivedirs)) fd_die(_FDNONPUOI.__line__);
	$dirlist = array();

	include_once("include/filesystem/DeepDir.php");
	$files = NULL;
	$files = new DeepDir();
	$files ->setDir($basedir);
	$files ->load();
	if (!count($files->dirs)==0){
		$dir ="";
		foreach($files->dirs as $dir){
			if (file_exists($dir."/section.php")) {
				if (is_fd_sect(eregi_replace("^\./","",$dir))){
					if (eregi("none_archivedir$",$dir) or eregi("none_archivedir./$",$dir)) continue;
					$dirlist[] = $dir;
				}
			}
		}
	}
	return $dirlist;
}

/**
 * Restituisce TRUE se la sezione passata come parametro  gestita dal metodo fd_view_section()
 * Attenzione: non la ritengo affidabile al 100%. Potrebbero essere segnalate sezioni
 * che contengono il codice richiesto come semplice testo, e non come codice eseguibile.
 * @param string $sect la sezione da verificare
 * @return TRUE se la sezione passata come parametro  gestita dal metodo fd_view_section, FALSE
 *         in caso contrario
 * @author Aldo Boccacci
 * @since 0.7
 */
function is_fd_sect($sect){
	if(!fd_check_path($sect,"sections/","false")) {
		fdlogf("the sect name \"$sect\" is not valid! FD+: ".__LINE__);
		return FALSE;
// 		fd_die(_FDNONPUOI.__LINE__);
	}
	if (file_exists($sect."/section.php")){
		$text="";
		$text=get_file($sect."/section.php");
		if (eregi("\<\?.*fd_view_section().*\?\>",$text)){
			return TRUE;
		}

	}
	return FALSE;
}

/**
 * Questa funzione si occupa di caricare la firma gpg
 * @param string $dir la cartella in cui caricare la firma
 * @param string $mode "upload" se stiamo caricando un nuovo file, "edit" se ne stiamo modificando
 *                     uno gi presente
 * @author Aldo Boccacci
 * @since 0.7
 */

function fd_upload_sig($dir,$mode="upload"){
	if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);

	//CONTROLLO PARAMETRI
	if (!fd_check_path($dir,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);
	if (!eregi("^upload$|^edit$",$mode)) {
		fd_die("Error: \$mode value is invalid: must be \"upload\" or \"edit\". FD+: ".__LINE__);
	}
	global $extsig;
	if ($extsig=="") $extsig="sig";
	//FINE CONTROLLO PARAMETRI

	if (!isset($_FILES['fdsig'])) {
		$message="";
		$message="<b>Error! </b> ".'$_FILES[\'fdsig\'] is not set! FD+: '.__LINE__;
		fdlogf($message);
		return;
	}

	if (eregi("\.php*$|\.php$","",$_FILES['fdsig']['name'])){
// 		echo "The extension of the sig file is \".php\", not \".sig\"";
		fd_die("The extension of the sig file is \".php\", not \".$extsig\" FD+: ".__LINE__);
	}

	if (isset($_FILES['fdsig']['name']) and trim($_FILES['fdsig']['name'])==""){
		echo "<br><br><div align=\"center\">"._FDFILENOTSELECT;
		echo "<br><br><a href=\"javascript:history.back()\">&lt;&lt; "._FDBACK."</a><br><br></div>";
			fd_die(_FDNONPUOI.__LINE__);
	}

	if ($_FILES['fdsig']['size']>300) {
		fd_die("The sig file is too big! ".$dir."/".$_FILES['fdsig']['name'].".$extsig"."FD+: ".__LINE__);
		die_die(_FDNONPUOI.__LINE__);

	}


	if ($_FILES['fdsig']['error']!=0){
		if ($_FILES['fdfile']['error']==1) echo _FDERROR1;
		else if ($_FILES['fdsig']['error']==2) echo _FDERROR2;
		else if ($_FILES['fdsig']['error']==3) echo _FDERROR3;
		else if ($_FILES['fdsig']['error']==4) echo _FDERROR4;
		else if ($_FILES['fdsig']['error']==6) echo _FDERROR6;
		else if ($_FILES['fdsig']['error']==7) echo _FDERROR7;

		fd_die("<br><br><b>FD+:</b> upload error.");


	}
	if ($_FILES['fdsig']['size']==0) fd_die("<br><b>Error! </b>"._FDSIZE." file: 0 kb");

	if (!fd_check_path($dir."/".$_FILES['fdsig']['name'],"sections/","false")) fd_die("The sig file path is not valid!: ".$dir."/".$_FILES['fdsig']['name'].".$extsig"."FD+:".__LINE__);

	if (file_exists($dir."/".$_FILES['fdsig']['name'])){
		echo "<b>Attention!</b> Already exists a file called".$_FILES['fdsig']['name']." in the dir <b>$dir</b>";
		fdlogf("Error! Already exists a file called".$_FILES['fdsig']['name']." in the dir <b>$dir</b>");
		echo "<a href=\"javascript:history.back()\">"._FDCANC."</a>";
		return;
	}
	//verifica la corrispondenza tra la firma e il file relativo

	if ($mode=="upload"){
		if ($_FILES['fdfile']['name'].".$extsig"!=$_FILES['fdsig']['name']){
			echo "<b>Error! </b>The sig file is called <b>".$_FILES['fdsig']['name']."</b>, but the correspondant file is called <b>".$_FILES['fdfile']['name']."</b> The sig file was not uploaded.";
			return;
		}
		else {
		//ok
		}
	}
	else if ($mode=="edit"){
		if (!file_exists($dir."/".eregi_replace("\.$extsig$","",$_FILES['fdsig']['name']))){
			$message="";
			$message= "<hr><b>Error!</b> the sig file is called <b>".$_FILES['fdsig']['name']."</b> but does'nt exists a file called <b>".eregi_replace("\.$extsig$","",$_FILES['fdsig']['name'])."</b> in the dir <b>$dir</b><hr>";
			echo $message;
			fdlogf($message);
			return;
		}
	}

	//controllo per codice php
	if (eregi("\<\?|\?\>",get_file($_FILES['fdsig']['tmp_name']))){
		fd_die("The sign file contains php tags! "._FDNONPUOI.__LINE__);
	}

	if (!fd_check_path($dir."/".$_FILES['fdsig']['name'],"sections/","false")) fd_die(_FDNONPUOI.__LINE__);

	if (move_uploaded_file($_FILES['fdsig']['tmp_name'],$dir."/".$_FILES['fdsig']['name'])){
		fdlogf("Uploaded sign file: ".$_FILES['fdsig']['name']." in the dir $dir");
	}
	else {
		echo "I was not able to upload the sig file :".$_FILES['fdsig']['name']." in the dir $dir";
		fdlogf("I was not able to upload the sig file :".$_FILES['fdsig']['name']." in the dir $dir FD+: ".__LINE__);
		return;
	}
}

/**
 * Per verificare i parametri passati alle funzioni.
 * tipi supportati:
 * (integer e val)
 * 1. digit: solo numeri
 * 2. alnum: numeri e cifre (no spazi)
 * 3. text (no html): restituisce true se il testo  uguale al testo restituito dalla funzione strip_tag
 *                    (ovvero non sono presenti tag html/php nella stringa)
 * 4. boolean: i valori validi sono "1", "0", "true", "false" (case insensitive)
 * al momento inutilizzata (da testare)
 */
/*function check_var($var, $type="alnum",$lenght=""){
include_once("include/php_filters/sanitize.php");
	$var = trim($var);
	if ($var=="") return TRUE;
	if ($type=="digit"){
		if (ctype_digit($var)){
			return TRUE;
		}
		else return FALSE;
	}
	else if ($type=="alnum"){
		if (ctype_alnum($var)){
			return TRUE;
		}
		else return FALSE;
	}
	else if ($type=="text"){
		if ($var==strip_tags($var)){
			return TRUE;
		}
		else return FALSE;
	}
	else if ($type=="boolean"){
		if (eregi("^1$|^0$|^true$|^false$",$var)){
			return TRUE;
		}
		else return FALSE;
	}
	else return FALSE;
}*/

/**
 * Per purificare una stringa html da tutto quello che non  permesso
 * Questa funzione usa la libreria kses
 * @param string $string la stringa da purificare
 * @return la stringa purificata
 * @author Aldo Boccacci
 * @since 0.7
 */
function purge_html_string($string){
	if (file_exists("include/php_filters/kses.php")){
		include_once("include/php_filters/kses.php");
		$allowed = array ('address' => array (), 'a' => array ('href' => array (), 'title' => array (), 'rel' => array (), 'rev' => array (), 'name' => array ()), 'abbr' => array ('title' => array ()), 'acronym' => array ('title' => array ()), 'b' => array (), 'big' => array (), 'blockquote' => array ('cite' => array ()), 'br' => array (), 'button' => array ('disabled' => array (), 'name' => array (), 'type' => array (), 'value' => array ()), 'caption' => array ('align' => array ()), 'code' => array (), 'col' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'span' => array (), 'valign' => array (), 'width' => array ()), 'del' => array ('datetime' => array ()), 'dd' => array (), 'div' => array ('align' => array ()), 'dl' => array (), 'dt' => array (), 'em' => array (), 'fieldset' => array (), 'font' => array ('color' => array (), 'face' => array (), 'size' => array ()), 'form' => array ('action' => array (), 'accept' => array (), 'accept-charset' => array (), 'enctype' => array (), 'method' => array (), 'name' => array (), 'target' => array ()), 'h1' => array ('align' => array ()), 'h2' => array ('align' => array ()), 'h3' => array ('align' => array ()), 'h4' => array ('align' => array ()), 'h5' => array ('align' => array ()), 'h6' => array ('align' => array ()), 'hr' => array ('align' => array (), 'noshade' => array (), 'size' => array (), 'width' => array ()), 'i' => array (), 'img' => array ('alt' => array (), 'align' => array (), 'border' => array (), 'height' => array (), 'hspace' => array (), 'longdesc' => array (), 'vspace' => array (), 'src' => array (), 'width' => array ()), 'ins' => array ('datetime' => array (), 'cite' => array ()), 'kbd' => array (), 'label' => array ('for' => array ()), 'legend' => array ('align' => array ()), 'li' => array (), 'p' => array ('align' => array ()), 'pre' => array ('width' => array ()), 'q' => array ('cite' => array ()), 's' => array (), 'strike' => array (), 'strong' => array (), 'sub' => array (), 'sup' => array (), 'table' => array ('align' => array (), 'bgcolor' => array (), 'border' => array (), 'cellpadding' => array (), 'cellspacing' => array (), 'rules' => array (), 'summary' => array (), 'width' => array ()), 'tbody' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 'td' => array ('abbr' => array (), 'align' => array (), 'axis' => array (), 'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 'colspan' => array (), 'headers' => array (), 'height' => array (), 'nowrap' => array (), 'rowspan' => array (), 'scope' => array (), 'valign' => array (), 'width' => array ()), 'textarea' => array ('cols' => array (), 'rows' => array (), 'disabled' => array (), 'name' => array (), 'readonly' => array ()), 'tfoot' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 'th' => array ('abbr' => array (), 'align' => array (), 'axis' => array (), 'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 'colspan' => array (), 'headers' => array (), 'height' => array (), 'nowrap' => array (), 'rowspan' => array (), 'scope' => array (), 'valign' => array (), 'width' => array ()), 'thead' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 'title' => array (), 'tr' => array ('align' => array (), 'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 'tt' => array (), 'u' => array (), 'ul' => array (), 'ol' => array (), 'var' => array () );
		return kses(stripslashes($string), $allowed);
	}
	else return $string;
}
/**
 * Mostra i controlli di amministrazione per il file specificato
 * @param string $path il percorso del file da amministrare
 * @author Aldo Boccacci
 * @since 0.7
 */
function file_admin_panel($path){
	if (!is_admin()) fd_die(_FDNONPUOI.__LINE__);
	if (!fd_check_path($path,"sections/","false")) fd_die(_FDNONPUOI.__LINE__);

	$mod ="";
	if (!isset($_GET['mod'])) return;
	if (fd_check_path($_GET['mod'],"","false")) $mod=$_GET['mod'];
	else return;

	//gestisco i file in attesa di validazione
	if (file_exists("fduser.php")){
		//CONTROLLARE!
		include_once("fduser.php");
		if ($mod=="none_Fdplus" or user_uploaded($path)) {
			global $separator_char;
			$correctname ="";
			$correctname = eregi_replace("[0-9]+\\$separator_char","",$path);
			echo "<tr><th colspan=\"2\"><div align=\"center\"><br><form action=\"index.php?mod=none_Fdplus\" method=\"POST\">
			<input type=\"hidden\" name=\"fdaction\" value=\"publishuserfile\" readonly=\"readonly\">
			<input type=\"hidden\" name=\"fdfile\" value=\"$path\" readonly=\"readonly\">
			<input type=\"SUBMIT\" value=\"Pubblica ".basename($correctname)."\"></form></div>";

			echo "<div align=\"center\"><br><form action=\"index.php?mod=none_Fdplus\" method=\"POST\">
			<input type=\"hidden\" name=\"fdaction\" value=\"deleteuserfile\" readonly=\"readonly\">
			<input type=\"hidden\" name=\"fdfile\" value=\"$path\" readonly=\"readonly\">
			<input type=\"SUBMIT\" value=\"Elimina ".basename($correctname)."\"></form></div></th></tr>";
			return;
		}

	}//fine if fduser.php exists


	global $extsig,$archivedir;

	$filename=$path;

	$description=array();
	$description = load_description($path);

	echo "<tr>";

				if ($description['hide'] != "true"){
					if(is_writable($filename.".description")){
						echo "<th colspan=\"2\"><a href=\"index.php?mod=none_Fdplus&amp;fdaction=hide&amp;value=true&amp;fdfile=".rawurlencodepath($filename)."\" title=\""._FDHIDETITLE.basename($filename)."\">"._FDHIDE."</a> | ";
					}
					else {
						echo "<th colspan=\"2\"><span style=\"color : #ff0000; text-decoration : line-through;\">"._FDHIDE."</span> | ";
					}
				}

				if ($description['hide'] == "true"){
					if(is_writable($filename.".description")){
						echo "<th colspan=\"2\"><a href=\"index.php?mod=none_Fdplus&amp;fdaction=hide&amp;value=false&amp;fdfile=".rawurlencodepath($filename)."\" style=\"color : #ff0000;\" title=\""._FDSHOWTITLE.basename($filename)."\">"._FDSHOW."</a> | ";
					}
					else {
						echo "<th colspan=\"2\"><span style=\"color : #ff0000; text-decoration : line-through;\">"._FDSHOW."</span> | ";
					}
				}
				//pulsante per rinominare
				if (is_writable($filename) and is_writable($filename.".description") and is_writable(dirname($filename))  and (!file_exists($filename.".$extsig") or is_writable($filename.".$extsig"))){
					echo "<a href=\"index.php?mod=none_Fdplus&amp;fdaction=renameinterface&amp;fdfile=".rawurlencodepath($filename)."\" title=\""._FDRENAMETITLE.basename($filename)."\">"._FDRENAME."</a> | ";
				}
				else {
					echo "<span style=\"color : #ff0000; text-decoration : line-through;\">"._FDRENAME."</span> | ";
				}

				//pulsante per spostare

				if (is_writable($filename) and is_writable($filename.".description") and (!file_exists($filename.".$extsig") or (is_writeable($filename.".$extsig")))) {

					echo "<a href=\"index.php?mod=none_Fdplus&amp;fdaction=moveinterface&amp;fdfile=".rawurlencodepath($filename)."\" title=\""._FDMOVETITLE.basename($filename)."\">"._FDMOVE."</a> | ";

				}
				else {
					echo "<span style=\"color : #ff0000; text-decoration : line-through;\">"._FDMOVE."</span> | ";
				}

				//fine pulsante per spostare


				//pulsante per archiviare/ripristinare
				$lastdir="";
				//controllo se ci troviamo in una dir di archivio
				$lastdir = strrchr(dirname($filename),"/");
				if (eregi($archivedir,$lastdir)){
					if (is_writable($filename) and is_writable($filename.".description") and is_writable(dirname($filename)) and is_writable(eregi_replace("$archivedir$","",dirname($filename)))  and (!file_exists($filename.".$extsig") or is_writable($filename.".$extsig"))){
						echo "<a href=\"index.php?mod=none_Fdplus&amp;fdaction=ripristina&amp;fdfile=".rawurlencodepath($filename)."\" title=\""._FDRESTORETITLE.basename($filename)."\">"._FDRESTORE."</a> | ";
					}
					else {
						echo "<span style=\"color : #ff0000; text-decoration : line-through;\">"._FDRESTORE."</span> | ";
					}
				}
				else if (!eregi($archivedir,$lastdir)){
					if (is_writable($filename) and is_writable($filename.".description") and is_writable(dirname($filename))  and (!file_exists($filename.".$extsig") or is_writable($filename.".$extsig"))){
						if (is_dir(dirname($filename)."/$archivedir") and is_writable(dirname($filename)."/$archivedir")){
							echo "<a href=\"index.php?mod=none_Fdplus&amp;fdaction=archive&amp;fdfile=".rawurlencodepath($filename)."\" title=\""._FDARCHIVETITLE.basename($filename)."\">"._FDARCHIVE."</a> | ";
					 	}
					 	else {
					   		if (!is_dir(dirname($filename)."/$archivedir")){
					   		echo "<a href=\"index.php?mod=none_Fdplus&amp;fdaction=archive&amp;fdfile=".rawurlencodepath($filename)."\" title=\""._FDARCHIVETITLE.basename($filename)."\">"._FDARCHIVE."</a> | ";
					    		}
					    	else echo "<span style=\"color : #ff0000; text-decoration : line-through;\">"._FDARCHIVE."</span> | ";
					    	}
					}
					else {
						echo "<span style=\"color : #ff0000; text-decoration : line-through;\">"._FDARCHIVE."</span> | ";
					}
				}

				if (is_writable($filename) and is_writable($filename.".description") and is_writable(dirname($filename))  and (!file_exists($filename.".$extsig") or is_writable($filename.".$extsig"))){
					echo "<a href=\"index.php?mod=none_Fdplus&amp;fdaction=modify&amp;fdfile=".rawurlencodepath($filename)."\" title=\""._FDEDITTITLE.basename($filename)."\">"._FDEDIT."</a> | ";
				}
				else {
					echo "<span style=\"color : #ff0000; text-decoration : line-through;\">"._FDEDIT."</span> | ";
				}
				//Opzione elimina
				if (is_writable($filename) and is_writable($filename.".description") and is_writable(dirname($filename)) and (!file_exists($filename.".$extsig") or is_writable($filename.".$extsig"))){
					echo "<a href=\"index.php?mod=none_Fdplus&amp;fdaction=confirmDelete&amp;fdfile=".rawurlencodepath($filename)."\" title=\""._FDDELETETITLE.basename($filename)."\">"._FDDELETE."</a></th>";
				}
				else {
					echo "<span style=\"color : #ff0000; text-decoration : line-through;\">"._FDDELETE."</span></th>";
				}
				echo "</tr>";
}

/**
 * restituisce una stringa contenente la versione di fdplus
 * @return la versione di fdplus
 * @author Aldo Boccacci
 * @since 0.7rc4
 */
function get_fd_version(){
	return "0.7";
}
?>